package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.design.Diff;
import com.bokesoft.yes.design.MetaObjectType;
import com.bokesoft.yes.design.constant.ConstantUtil;
import com.bokesoft.yes.design.io.DesignIOMetaUtil;
import com.bokesoft.yes.design.utils.MetaUtils;
import com.bokesoft.yes.design.xml.XmlParser;
import com.bokesoft.yes.design.xml.node.TagNode;
import com.bokesoft.yes.design.xml.node.XmlTree;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.meta.form.MetaForm;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;

import java.io.File;

/**
 * XML内容检查
 */
public class CheckXMLChanged {
	public static boolean checkXMLChanged(String content, int line, String orgFragment, String newFragment) {
		@SuppressWarnings("unused")
		String result = mergeXML(content, line, orgFragment, newFragment, null, true);
		// TODO: 进行检查，检查通过后可载入配置对象
		return true;
	}

	public static String mergeXML(String content, int lineIndex, String orgFragment, String newFragment, ReplaceStringEntry entry, boolean insertIndent) {
		content = content.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
		Line line = getLine(content, lineIndex);
		if (StringUtils.isBlank(orgFragment)) {
			throw new RuntimeException("这个操作目前不支持或没有引起Xml源代码实质变化，可直接修改Xml源代码。");
		}
		String orgFragmentWithPrefix = orgFragment;
		String newFragmentWithPrefix = newFragment;
		if (entry != null) { // 若是用户在源代码界面输入，不进行任何处理
			orgFragment = orgFragment.trim(); // 从源代码界面传来XML片断的带空格
			newFragment = newFragment.trim();
			orgFragment = orgFragment.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
			newFragment = newFragment.replaceAll("\r\n", "\n").replaceAll("\n", "\r\n");
			if (!orgFragment.startsWith(line.content.trim())) {
				throw new RuntimeException("内容不一致，请检查文件版本。");
			}
			String indent = DesignIOMetaUtil.getSubString(line.content, "^(\\s*)<");
			orgFragmentWithPrefix = indent + orgFragment;
			newFragmentWithPrefix = indent + (insertIndent ? newFragment.replaceAll("\n", "\n" + indent) : newFragment);
		}
		StringBuilder sb = new StringBuilder(content.length() - orgFragment.length() + newFragmentWithPrefix.length());
		//数据对象表单会多添加一个</DataObject>,导致XML异常，这里做一个区分
		//if (MetaObjectType.DataObject.name.equals(tagName)){
		//sb.append(content.substring(0, line.pos)).append(newFragmentWithPrefix);
		//} else {
		if (line.content.equals("<CommonDef>") || line.content.startsWith("<Setting")|| line.content.startsWith("<ParaTable>")|| line.content.startsWith("<Parameter>")
			|| line.content.equals("<RightsDefinition>") || line.content.equals("<Enhance>")
			|| line.content.equals("<DataElementDef>") || line.content.equals("<DomainDef>")
			|| line.content.equals("<IOSetting>") || line.content.startsWith("<Solution")){
			sb.append(content, 0, line.pos).append(newFragmentWithPrefix);
		} else {
			sb.append(content, 0, line.pos).append(newFragmentWithPrefix);
			int beginIndex = line.pos + orgFragmentWithPrefix.length();
			if (beginIndex < content.length()) {
				sb.append(content.substring(beginIndex));
			}
		}
		//}
		if (entry != null) {
			entry.orgString = orgFragmentWithPrefix;
			entry.newString = newFragmentWithPrefix;
		}
		return sb.toString();
	}

	public static void mergerSortedXml(Diff diff, String tempFilePath, String projectKey, String oldXml) throws Throwable {
		XmlTree xmlTree = XmlParser.parse(oldXml);
		TagNode root = XmlParser.parse(oldXml).getRoot();
		String tagName = root.getTagName();
		if(tagName.equals(MetaObjectType.DataObject.toString())) return;

		if(StringUtils.isNotBlank(root.getAttributes().get(ConstantUtil.EXTEND))) {
			return;
		}

		MetaForm metaForm1 = NewFormCmd.loadMetaFormByPath(tempFilePath, projectKey);
		String sortXml = MetaUtils.getNewXml(tempFilePath, metaForm1, null);
		// 获取排序后该节点的xml片段
		XmlTree sortXmlTree = XmlParser.parse(sortXml);
		TagNode sortTagNode = (TagNode) sortXmlTree.getMapNodes().get(ControlType.toString(diff.controlType) + "@" + diff.getKey());
		if (sortTagNode == null) return;
		// 获取未排序时该节点的xml片段
		TagNode tagNode = (TagNode) xmlTree.getMapNodes().get(ControlType.toString(diff.controlType) + "@" + diff.getKey());
		TagNode parent = tagNode.getParent();
		if (parent != null) {
			int index = parent.getChildren().indexOf(tagNode);
			parent.getChildren().remove(index);
			parent.getChildren().add(index, sortTagNode);
		}
		String xml = xmlTree.getRoot().toXml(0, false);
		xml = RegExUtils.replaceAll(xml, "[\r\n]+(\\s*[\r\n]+)*", "\r\n");
		FileUtils.writeStringToFile(new File(tempFilePath), xml, "UTF-8");
	}

	/**
	 * 从文本中取行，line从0开始
	 *
	 * @param content
	 * @param line
	 * @return
	 */
	private static Line getLine(String content, int line) {
		// \r 13 <回车> Carriage Return; \n 10 <换行> Line Feed
		// Dos和windows采用回车+换行CR/LF表示下一行, \r\n
		// 而UNIX/Linux采用换行符LF表示下一行 \n
		// 苹果机(MAC OS系统)则采用回车符CR表示下一行 \r
		int pos = 0;
		for (int i = 0; i < line; i++) {
			pos = content.indexOf("\n", pos + 1);
		}
		int pos2 = content.indexOf("\n", pos + 1);
		if (content.substring(pos2 - 1, pos2).equals("\r")) {
			--pos2;
		}
		String lineContent = content.substring(pos + 1, pos2);
		return new Line(pos + 1, lineContent);
	}
}

class Line {
	final int pos;
	final String content;

	public Line(int pos, String content) {
		this.pos = pos;
		this.content = content;
	}
}