package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.meta.dataobject.MetaDataSource;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaFormList;
import com.bokesoft.yigo.meta.form.MetaFormProfile;
import com.bokesoft.yigo.mid.base.DefaultContext;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class CheckViewExistCmd  extends DesignerServiceCmd {
    public static final String CMD = "CheckViewExist";

    private String objectKey;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        objectKey = (String) arguments.get("objectKey");
    }

    @Override
    public Object innerDoCmd(DefaultContext context) throws Throwable {
        List<UICommand> result = new ArrayList<UICommand>();
        MetaFormList metaFormList = MetaFactory.getGlobalInstance().getMetaFormList();
        List<MetaFormProfile> needDeleteMetaFormProfiles = new ArrayList<MetaFormProfile>();
        for (MetaFormProfile metaFormProfile : metaFormList) {
            MetaDataSource metaDataSource = metaFormProfile.getForm().getDataSource();
            if (metaDataSource != null) {
                if(StringUtils.equals(metaDataSource.getRefObjectKey(), objectKey)) {
                    needDeleteMetaFormProfiles.add(metaFormProfile);
                }
            }
        }
        if (needDeleteMetaFormProfiles.size() > 0) {
            needDeleteMetaFormProfiles.sort(Comparator.comparing(MetaFormProfile::getKey));
            result.add(UICommand.showError("操作失败,迁移表不允许被引用,请删除表单" + needDeleteMetaFormProfiles.get(0).getKey()));
        }
        return UICommand.toJson(result);
    }

    @Override
    public String getCmd() {
        return CMD;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new CheckViewExistCmd();
    }
}
