package com.bokesoft.yes.design.cmd;

import com.bokesoft.yes.common.struct.StringHashMap;
import com.bokesoft.yes.mid.cmd.IServiceCmd;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.mid.base.DefaultContext;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CheckNumPrecisionCmd extends DesignerServiceCmd {
    public static final String CMD = "CheckNumPrecision";

    private String tableKey;
    private String columnKey;
    private String formKey;
    private int precision;
    private int columnType;

    @Override
    public void dealArguments(DefaultContext context, StringHashMap<Object> arguments) throws Throwable {
        tableKey = TypeConvertor.toString(arguments.get("tableKey")).trim();
        columnKey = TypeConvertor.toString(arguments.get("columnKey")).trim();
        formKey = TypeConvertor.toString(arguments.get("formKey")).trim();
        precision = TypeConvertor.toInteger(arguments.get("precision"));
        columnType = TypeConvertor.toInteger(arguments.get("columnType"));
    }

    @Override
    public Object innerDoCmd(DefaultContext defaultContext) throws Throwable {
        MetaDataObject metaDataObject = MetaFactory.getGlobalInstance().getDataObject(formKey);
        if (metaDataObject == null) {
            metaDataObject = MetaFactory.getGlobalInstance().getMetaForm(formKey).getDataSource().getDataObject();
            if (metaDataObject == null) {
                return null;
            }
        }
        MetaTable metaTable = metaDataObject.getMetaTable(tableKey);
        List<UICommand> result = new ArrayList<UICommand>();
        if (metaTable != null) {
            for (MetaColumn metaColumn : metaTable) {
                if (metaColumn.getKey().equals(columnKey)) {
                    Integer metaPrecision = metaColumn.getPrecision();
                    if (Objects.isNull(metaPrecision)) {
                        if (columnType == DataType.INT) {
                            metaPrecision = 9;
                        }
                        if (columnType == DataType.LONG) {
                            metaPrecision = 16;
                        }
                    }
                    if (precision > (metaPrecision !=null ? metaPrecision :0)) {
                        result.add(UICommand.showError("数值控件的数值精度不允许大于绑定数据源的数值精度"));
                        return UICommand.toJson(result);
                    }
                    switch (columnType) {
                        case 1005:
                            if (precision != metaPrecision) {
                                result.add(UICommand.showError("绑定数值类型的数据源时，数值控件的数值精度需与其一致"));
                                return UICommand.toJson(result);
                            }
                            break;
                        case 1010:
                            if (precision > 19) {
                                result.add(UICommand.showError("绑定长整型的数据源时，数值控件的数值精度需小于19"));
                                return UICommand.toJson(result);
                            }
                            break;
                        case 1001:
                            if (precision > 9) {//绑定的整形数据源列的数值精度,数值控件的数值精度少于9
                                result.add(UICommand.showError("绑定整型的数据源时，数值控件的数值精度需小于9"));
                                return UICommand.toJson(result);
                            }
                            break;
                    }

                }
            }
        }
        return null;
    }

    @Override
    public IServiceCmd<DefaultContext> newInstance() {
        return new CheckNumPrecisionCmd();
    }

    @Override
    public String getCmd() {
        return CMD;
    }
}
