package com.bokesoft.erp.desigerfunction;

import java.util.List;

import com.bokesoft.yigo.parser.IFunImplCluster;
import com.bokesoft.yigo.parser.IFunctionProvider;

/**
 * ERP的所有中间层公式，因为yigo2中对公式进行了多次register，主要是web-mid中对View的公式进行再次注册，所以将这些公式写成这样
 */
public class MidDesigerFunctionCluster implements IFunImplCluster, IFunctionProvider {
	@Override
	public Object[][] getImplTable() {
		List<String> names = DesigerFunctionUtil.getDesigerFunctionNames();
		int length = names.size();
		Object[][] result = new Object[length][];
		for (int i = 0; i < length; i++) {
			Object[] tmp = new Object[2];
			tmp[0] = names.get(i);
			tmp[1] = InvokeMidDesigerFunctionImpl.instance;
			result[i] = tmp;
		}
		return result;
	}

	@Override
	public IFunImplCluster[] getClusters() {
		return new IFunImplCluster[] {this};
	}

}
