package com.bokesoft.erp.desigerfunction;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.cmd.richdocument.strut.uiprocess.LocaleData;
import com.bokesoft.yes.util.ERPStringUtil;
import org.apache.commons.lang3.reflect.FieldUtils;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.erp.annotation.FunctionRunOnlyInClient;
import com.bokesoft.yes.mid.base.MidVE;
import com.bokesoft.yes.mid.cmd.richdocument.strut.DocumentRecordDirty;
import com.bokesoft.yes.mid.cmd.richdocument.strut.RichDocumentContext;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yes.mid.parameterizedsql.SqlStringUtil;
import com.bokesoft.yes.parser.IFunImpl;
import com.bokesoft.yes.report.ReportDataSource;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.parser.IEvalContext;
import com.bokesoft.yigo.parser.IExecutor;
import com.bokesoft.yigo.report.expr.ReportEvalContext;
import com.bokesoft.yigo.struct.document.Document;
import com.bokesoft.yigo.struct.usrpara.Paras;

public class InvokeMidDesigerFunctionImpl implements IFunImpl {
	/** 单例对象 */
	public static final InvokeMidDesigerFunctionImpl instance = new InvokeMidDesigerFunctionImpl();

	@Override
	public Object eval(String name, IEvalContext context, Object[] args, IExecutor executor) throws Throwable {
		if (context instanceof DefaultContext) {
			// int action = Performance.startAction("InvokeMidFunctionImpl/", name);
			Object result = evalImpl(name, (DefaultContext) context, args, executor);
			// Performance.endActive(action);
			if (result instanceof LocaleData) {
				LocaleData localeData = (LocaleData) result;
				result = ERPStringUtil.formatMessage(localeData.getEnv(), localeData.getMsg(), localeData.getParas());
			}
			return result;
		} else if (context instanceof ReportEvalContext) {
			return evalImpl(name, (ReportEvalContext) context, args, executor);
		} else {
			throw new Exception("暂时未支持此种类型的上下文。" + context.getClass().getName());
		}
	}

	@Override
	public boolean isAsync() {
		return false;
	}

	private Object evalImpl(String name, ReportEvalContext context, Object[] args, IExecutor executor) throws Throwable {
		Method method = DesigerFunctionUtil.getFunctionMethod(name, args.length);
		if (null == method) {
			throw new Exception("系统中找不到 " + name + " 方法,请修改!");
		}
		Object[] paras = null;
		int length = method.getParameterTypes().length;
		int argLength = args.length;
		if (length > 0) {
			Class<?>[] paraTypes = method.getParameterTypes();
			paras = new Object[length];
			if (VariableParasMethds.variableParasMethods.get(name) == null) {
				for (int i = 0; i < length; i++) {
					Class<?> paraType = paraTypes[i];
					paras[i] = convertType(args[i], paraType);
				}
			} else {
				// 方法参数可变的情况，argLength > length
				for (int i = 0; i < length -1; i++) {
					Class<?> paraType = paraTypes[i];
					paras[i] = convertType(args[i], paraType);
				}
				Class<?> paraType = paraTypes[length -1];
				if (paraType == String[].class) {
					String[] tmp = new String[argLength-length+1];
					int j = 0;
					for (int i = length -1; i < argLength; i++) {
						tmp[j] = (String) convertType(args[i], String.class);
						j ++;
					}
					paras[length - 1] = tmp;
				} else if (paraType == Object[].class) {
					Object[] tmp = new Object[argLength-length+1];
					int j = 0;
					for (int i = length -1; i < argLength; i++) {
						tmp[j] = convertType(args[i], Object.class);
						j ++;
					}
					paras[length - 1] = tmp;
				}
			}
		}
		Class<?> clz = DesigerFunctionUtil.getClass(name);// ERPDesigerFunctionUtil.ERPMidFunctionClasses.get(name);
		Object obj = getReportEvalContextInstanceByClass(context, clz);
		try {
			return method.invoke(obj, paras);
		} catch (InvocationTargetException e) {
			LogSvr.getInstance().error(e.getMessage(), e);
			if (e.getTargetException() != null) {
				throw e.getTargetException();
			}
			throw e;
		}
	}

	public Object evalImpl(String name, DefaultContext context, Object[] args, IExecutor executor) throws Throwable {
		int argLength = args.length;
		Method method = DesigerFunctionUtil.getFunctionMethod(name, argLength);
		if (null == method) {
			throw new Exception("系统中找不到 " + name + " 方法,请修改!");
		}
		// 对于在中间层new了Billentity，为某个字段赋值时，恰巧这个字段的值变化含有只能在客户端运行的公式，这里就直接返回true
		// 对于可以直接中间层赋值的字段，配置中应该避免使用值变化事件，IIF(Confirm(..)...
		if (method.getAnnotation(FunctionRunOnlyInClient.class) != null) {
			return true;
		}
		Object[] paras = null;
		int length = method.getParameterTypes().length;
		if (length > 0) {
			Class<?>[] paraTypes = method.getParameterTypes();
			paras = new Object[length];
			if (VariableParasMethds.variableParasMethods.get(name) == null) {
				for (int i = 0; i < length; i++) {
					Class<?> paraType = paraTypes[i];
					paras[i] = convertType(args[i], paraType);
				}
			} else {
				// 方法参数可变的情况，argLength > length
				for (int i = 0; i < length -1; i++) {
					Class<?> paraType = paraTypes[i];
					paras[i] = convertType(args[i], paraType);
				}
				Class<?> paraType = paraTypes[length -1];
				if (paraType == String[].class) {
					String[] tmp = new String[argLength-length+1];
					int j = 0;
					for (int i = length -1; i < argLength; i++) {
						tmp[j] = (String) convertType(args[i], String.class);
						j ++;
					}
					paras[length - 1] = tmp;
				} else if (paraType == Object[].class) {
					Object[] tmp = new Object[argLength-length+1];
					int j = 0;
					for (int i = length -1; i < argLength; i++) {
						tmp[j] = convertType(args[i], Object.class);
						j ++;
					}
					paras[length - 1] = tmp;
				}
			}
		}
		Object obj = null;
		if (!Modifier.isStatic(method.getModifiers())) {
			obj = getInstanceByClass(context, name);
		}
		try {
			return method.invoke(obj, paras);
		} catch (InvocationTargetException e) {
//			throw new Exception("运行方法,方法名：" + name + "参数:" + args.length,e);
			if (e.getTargetException() != null) {
				throw e.getTargetException();
			}
			throw e;
		}
	}

	/**
	 * 根据类型进行数据转化
	 * 
	 * @param srcObj
	 * @param tgtType
	 * @return
	 * @throws Throwable
	 */
	public static Object convertType(Object srcObj, Class<?> tgtType) throws Throwable {
		Object result;
		if (tgtType == String.class) {
			result = TypeConvertor.toString(srcObj);
		} else if (tgtType == BigDecimal.class) {
			result = TypeConvertor.toBigDecimal(srcObj);
		} else if (tgtType == Long.class || tgtType == long.class) {
			result = TypeConvertor.toLong(srcObj);
		} else if (tgtType == Object.class) {
			result = srcObj;
		} else if (tgtType == int.class || tgtType == Integer.class) {
			result = TypeConvertor.toInteger(srcObj);
		} else if (tgtType == Boolean.class || tgtType == boolean.class) {
			result = TypeConvertor.toBoolean(srcObj);
		} else if (tgtType == Timestamp.class) {
			result = VarUtil.toTimestamp(srcObj);
		} else if (tgtType == Date.class) {
			result = TypeConvertor.toDate(srcObj);
		} else if (tgtType == SqlString.class) {
			result = SqlStringUtil.ToSqlString(srcObj);
		} else {
			throw new RuntimeException("未处理的类型" + tgtType.getName());
		}
		return result;
	}

	public static final String ERP_FUNCTION_INSTANCE = "ERP_FUNCTION_INSTANCE";

	/**
	 * 根据类取对象，这些对象被缓冲在会话级
	 * 
	 * @param context
	 * @param clz
	 * @return
	 * @throws Throwable
	 */
	@SuppressWarnings("unchecked")
	public static Object getReportEvalContextInstanceByClass(ReportEvalContext context, Class<?> clz) throws Throwable
	{
		ReportDataSource dataSource = (ReportDataSource)context.getDataSource();
		Map<Class<?>, Object> instances = (Map<Class<?>, Object>) dataSource.get(ERP_FUNCTION_INSTANCE);
		if (instances == null) {
			synchronized (InvokeMidDesigerFunctionImpl.class) {
				instances = (Map<Class<?>, Object>) dataSource.get(ERP_FUNCTION_INSTANCE);
				if (instances == null) {
					instances = new HashMap<Class<?>, Object>();
				}

			}
		}
		Object result = instances.get(clz);
		if (result == null) {
			synchronized (InvokeMidDesigerFunctionImpl.class) {
				result = instances.get(clz);
				if (result == null) {
					Constructor<?> c = clz.getConstructor(RichDocumentContext.class);

					IMetaFactory metaFactory = MetaFactory.getGlobalInstance();
					
					// FIXME:此处暂时这么处理，希望以后有更好的处理方式
					String formKey = TypeConvertor.toString(FieldUtils.readField(dataSource, "formKey", true));
					Object veObj = FieldUtils.readField(dataSource, "ve", true);
					Object documentObj = FieldUtils.readField(dataSource, "document", true);
					Object parasObj = FieldUtils.readField(dataSource, "paras", true);

					Object queryProxy = FieldUtils.readField(dataSource, "queryProxy", true);
					DefaultContext defaultContext = (DefaultContext) FieldUtils.readField(queryProxy, "context", true);

					if (veObj == null || !(veObj instanceof MidVE) || StringUtil.isBlankOrNull(formKey)
							|| documentObj == null) {
						throw new Exception("暂时不支持这种情况，请联系开发人员！");
					}
					Document document = (Document) documentObj;
					MetaForm metaForm = metaFactory.getMetaForm(formKey);
					if (document.getMetaDataObject() == null && metaForm != null && metaForm.getDataSource() != null) {
						document.setMetaDataObject(metaForm.getDataSource().getDataObject());
					}
					
					RichDocumentContext richContext = new RichDocumentContext(defaultContext);
					DocumentRecordDirty richDocument = DocumentRecordDirty.getDocumentFromDoc(document, metaForm);
					richContext.setFormKey(formKey);
					richContext.setDocument(richDocument);
					richContext.setParas((Paras) parasObj);
					
					result = c.newInstance(richContext);
					instances.put(clz, result);
				}
			}
		}
		return result;
	}
	
	private static Map<Class<?>, Constructor<?>> clzConstructor = new HashMap<Class<?>, Constructor<?>>();

	/**
	 * 根据类取对象，这些对象目前没有缓冲
	 * @param context
	 * @param functionName
	 * @return
	 * @throws Throwable
	 */
	public static Object getInstanceByClass(DefaultContext context, String functionName) throws Throwable {
		Class<?> clz = DesigerFunctionUtil.getClass(functionName);
		Constructor<?> c = clzConstructor.get(clz);
		if (c == null) {
			c = clz.getConstructor(RichDocumentContext.class);
			clzConstructor.put(clz, c);
		}
		RichDocumentContext midContext;
		if (context instanceof RichDocumentContext) {
			midContext = (RichDocumentContext) context;
		} else {
			IMetaFactory metaFactory = context.getVE().getMetaFactory();
			String metaFormKey = context.getFormKey();
			RichDocumentContext richContext = new RichDocumentContext(context);
			if (metaFormKey != null && context.getDocument() != null) {
				MetaForm metaForm = metaFactory.getMetaForm(metaFormKey);
				DocumentRecordDirty richDocument = DocumentRecordDirty.getDocumentFromDoc(context.getDocument(),
						metaForm);
				richContext.setDocument(richDocument);
			}

			midContext = richContext;
		}
		Object result = c.newInstance(midContext);
		return result;
	}
	
	@Override
	public boolean needFullName() {
		return true;
	}
}
