/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.util;

import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.util.MetaUtil;
import com.bokesoft.yigo.struct.env.Env;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;

public final class ERPStringUtil {
    public static String join(List<?> list, String string) {
        if (list == null) {
            return "";
        }
        String string2 = "";
        for (Object obj : list) {
            string2 = String.valueOf(string2) + String.valueOf(obj) + string;
        }
        if (string2.length() != 0) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public static String join(Object[] objectArray, String string) {
        String string2 = "";
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            string2 = String.valueOf(string2) + object.toString() + string;
            ++n2;
        }
        if (string2.length() != 0) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        return string2;
    }

    public static boolean isBlankOrNull(Object object) {
        return object == null || object.toString().trim().length() == 0;
    }

    public static boolean isNotBlankOrNull(Object object) {
        return !ERPStringUtil.isBlankOrNull(object);
    }

    public static boolean isBlankOrStrNull(String string) {
        return string == null || string.length() == 0 || string.equalsIgnoreCase("null") || string.trim().length() == 0;
    }

    public static String join(String string, String string2, String string3) {
        if (string3 == null) {
            string3 = " and ";
        }
        return ERPStringUtil.isBlankOrStrNull(string) ? string2 : String.valueOf(string) + (ERPStringUtil.isBlankOrStrNull(string2) ? "" : String.valueOf(string3) + string2);
    }

    public static String append(String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object != null) {
                stringBuilder.append(object).append(string);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String append(StringBuilder stringBuilder, String string, Object ... objectArray) {
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object != null) {
                stringBuilder.append(object).append(string);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static String formatMessage(CharSequence charSequence, Object ... objectArray) {
        if (ERPStringUtil.isBlankOrNull(charSequence)) {
            return "";
        }
        if (objectArray == null || objectArray.length == 0) {
            return charSequence.toString();
        }
        return ERPStringUtil.formatMessage(charSequence.toString(), objectArray);
    }

    public static String formatMessage(String string, Object ... objectArray) {
        if (ERPStringUtil.isBlankOrNull(string) || objectArray == null || objectArray.length == 0) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n + 50);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            int n4 = string.indexOf("{}", n2);
            if (n4 == -1) {
                if (n2 == 0) {
                    return string;
                }
                stringBuilder.append(string, n2, n);
                return stringBuilder.toString();
            }
            if (n4 > 0 && string.charAt(n4 - 1) == '\\') {
                if (n4 > 1 && string.charAt(n4 - 2) == '\\') {
                    stringBuilder.append(string, n2, n4 - 1);
                    stringBuilder.append(TypeConvertor.toString((Object)objectArray[n3]));
                    n2 = n4 + 2;
                } else {
                    --n3;
                    stringBuilder.append(string, n2, n4 - 1);
                    stringBuilder.append('{');
                    n2 = n4 + 1;
                }
            } else {
                stringBuilder.append(string, n2, n4);
                stringBuilder.append(TypeConvertor.toString((Object)objectArray[n3]));
                n2 = n4 + 2;
            }
            ++n3;
        }
        stringBuilder.append(string, n2, string.length());
        return stringBuilder.toString();
    }

    public static String formatMessage(Env env, String string, Object ... objectArray) {
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        try {
            string = MetaUtil.getString((IMetaFactory)iMetaFactory, (String)env.getLocale(), null, (String)string);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        if (objectArray == null || objectArray.length == 0) {
            return string;
        }
        return SimpleStringFormat.format((String)string, (Object[])objectArray);
    }

    public static String formatMessageByLocale(String string, String string2, Object ... objectArray) {
        IMetaFactory iMetaFactory = MetaFactory.getGlobalInstance();
        try {
            string2 = MetaUtil.getString((IMetaFactory)iMetaFactory, (String)string, null, (String)string2);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        if (objectArray == null || objectArray.length == 0) {
            return string2;
        }
        return SimpleStringFormat.format((String)string2, (Object[])objectArray);
    }

    public static String format(String string, Object ... objectArray) {
        MessageFormat messageFormat = new MessageFormat(string, Locale.getDefault());
        return messageFormat.format(objectArray);
    }
}

