/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.cmd.attachmentPreview;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.cmd.attachmentPreview.IAttachmentPreview;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Base64;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.HWPFDocumentCore;
import org.apache.poi.hwpf.converter.PicturesManager;
import org.apache.poi.hwpf.converter.WordToHtmlConverter;
import org.apache.poi.hwpf.usermodel.PictureType;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.util.IOUtils;
import org.w3c.dom.Document;

public class DocAttachmentPreview
implements IAttachmentPreview {
    @Override
    public boolean isSupport(String string) throws Throwable {
        return string.equalsIgnoreCase("doc");
    }

    @Override
    public boolean isBlob() {
        return false;
    }

    @Override
    public boolean isShowInPDF() {
        return false;
    }

    @Override
    public String preview(byte[] byArray) throws Throwable {
        ByteArrayInputStream byteArrayInputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        IOUtils.setByteArrayMaxOverride((int)Integer.MAX_VALUE);
        try {
            byteArrayInputStream = new ByteArrayInputStream(byArray);
            byteArrayOutputStream = new ByteArrayOutputStream();
            HWPFDocument hWPFDocument = new HWPFDocument((InputStream)byteArrayInputStream);
            WordToHtmlConverter wordToHtmlConverter = new WordToHtmlConverter(DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument());
            wordToHtmlConverter.setPicturesManager(new PicturesManager(){

                public String savePicture(byte[] byArray, PictureType pictureType, String string, float f, float f2) {
                    return "data:" + pictureType.toString() + ";base64," + Base64.getEncoder().encodeToString(byArray);
                }
            });
            wordToHtmlConverter.processDocument((HWPFDocumentCore)hWPFDocument);
            Document document = wordToHtmlConverter.getDocument();
            DOMSource dOMSource = new DOMSource(document);
            StreamResult streamResult = new StreamResult(byteArrayOutputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "html");
            transformer.transform(dOMSource, streamResult);
            String string = "";
            if (byteArrayOutputStream.size() > 0) {
                string = byteArrayOutputStream.toString("UTF-8");
            }
            if (!StringUtil.isBlankOrNull((String)string)) {
                string = string.replaceAll("<a ", "<a target=\"_blank\" ");
            }
            String string2 = string;
            return string2;
        }
        catch (OfficeXmlFileException officeXmlFileException) {
            throw new Exception("\u5f53\u524d\u9884\u89c8\u9644\u4ef6\u4e0d\u662f97-2003\u683c\u5f0fWord\u6587\u6863\uff0c\u8bf7\u68c0\u67e5\u6587\u4ef6\u683c\u5f0f", officeXmlFileException);
        }
        catch (Exception exception) {
            throw new Exception("\u9884\u89c8\u6570\u636e\u51fa\u73b0\u9519\u8bef", exception);
        }
        finally {
            if (byteArrayInputStream != null) {
                byteArrayInputStream.close();
            }
            if (byteArrayOutputStream != null) {
                byteArrayOutputStream.close();
            }
        }
    }
}

