/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.MySQLIndexHint;
import net.boke.jsqlparser.expression.OracleHint;
import net.boke.jsqlparser.expression.SQLServerHints;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.FromItemVisitor;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.Limit;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.OrderByVisitor;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;
import net.boke.jsqlparser.statement.select.SelectItemVisitor;
import net.boke.jsqlparser.statement.select.SelectVisitor;
import net.boke.jsqlparser.statement.select.SubJoin;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Top;
import net.boke.jsqlparser.statement.select.Union;

public class SelectDeParser
implements SelectVisitor,
OrderByVisitor,
SelectItemVisitor,
FromItemVisitor {
    protected int dbType;
    boolean isChange = false;
    protected StringBuffer buffer;
    protected ExpressionVisitor expressionVisitor;

    public boolean isChange() {
        return this.isChange;
    }

    public void setChange() {
        this.isChange = true;
    }

    public SelectDeParser() {
    }

    public SelectDeParser(ExpressionVisitor expressionVisitor, StringBuffer buffer) {
        this.buffer = buffer;
        this.expressionVisitor = expressionVisitor;
    }

    protected Expression getPlainSelectWhere(PlainSelect plainSelect) {
        return plainSelect.getWhere();
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        Expression where;
        Top top;
        this.buffer.append("SELECT ");
        OracleHint hint = plainSelect.getOracleHint();
        if (hint != null) {
            this.buffer.append(hint).append(" ");
        }
        if (plainSelect.getDistinct() != null) {
            this.buffer.append("DISTINCT ");
            if (plainSelect.getDistinct().getOnSelectItems() != null) {
                this.buffer.append("ON (");
                Iterator iter = plainSelect.getDistinct().getOnSelectItems().iterator();
                while (iter.hasNext()) {
                    SelectItem selectItem = (SelectItem)iter.next();
                    selectItem.accept(this);
                    if (!iter.hasNext()) continue;
                    this.buffer.append(", ");
                }
                this.buffer.append(") ");
            }
        }
        if ((top = plainSelect.getTop()) != null) {
            this.buffer.append(top.toString()).append(" ");
        }
        Iterator iter = plainSelect.getSelectItems().iterator();
        while (iter.hasNext()) {
            SelectItem selectItem = (SelectItem)iter.next();
            selectItem.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
        this.buffer.append(" ");
        if (plainSelect.getFromItem() != null) {
            this.buffer.append("FROM ");
            plainSelect.getFromItem().accept(this);
        }
        if (plainSelect.getJoins() != null) {
            for (Join join : plainSelect.getJoins()) {
                this.deparseJoin(join);
            }
        }
        if ((where = this.getPlainSelectWhere(plainSelect)) != null) {
            this.buffer.append(" WHERE ");
            where.accept(this.expressionVisitor);
        }
        if (plainSelect.getOracleHierarchical() != null) {
            plainSelect.getOracleHierarchical().accept(this.expressionVisitor);
        }
        if (plainSelect.getGroupByColumnReferences() != null) {
            this.buffer.append(" GROUP BY ");
            Iterator iter2 = plainSelect.getGroupByColumnReferences().iterator();
            while (iter2.hasNext()) {
                Expression columnReference = (Expression)iter2.next();
                columnReference.accept(this.expressionVisitor);
                if (!iter2.hasNext()) continue;
                this.buffer.append(", ");
            }
        }
        if (plainSelect.getHaving() != null) {
            this.buffer.append(" HAVING ");
            plainSelect.getHaving().accept(this.expressionVisitor);
        }
        if (plainSelect.getOrderByElements() != null) {
            this.deparseOrderBy(plainSelect.isOracleSiblings(), plainSelect.getOrderByElements());
        }
        if (plainSelect.getLimit() != null) {
            boolean isSingleValue;
            Limit limit = plainSelect.getLimit();
            this.buffer.append(" LIMIT ");
            boolean bl = isSingleValue = !limit.isOffsetJdbcParameter() || !limit.isRowCountJdbcParameter();
            if (limit.isOffsetJdbcParameter()) {
                limit.getOffsetJdbcParameterValue().accept(this.expressionVisitor);
            }
            if (!isSingleValue) {
                this.buffer.append(", ");
            }
            if (limit.isRowCountJdbcParameter()) {
                limit.getRowCountJdbcParameterValue().accept(this.expressionVisitor);
            }
        }
        if (plainSelect.isForUpdate()) {
            this.buffer.append(" FOR UPDATE");
        }
        if (plainSelect.getForXmlPath() != null) {
            this.buffer.append(" FOR XML PATH (").append(plainSelect.getForXmlPath()).append(")");
        }
    }

    @Override
    public void visit(Union union) {
        String allDistinct = "";
        if (union.isAll()) {
            allDistinct = "ALL ";
        } else if (union.isDistinct()) {
            allDistinct = "DISTINCT ";
        }
        Iterator iter = union.getPlainSelects().iterator();
        while (iter.hasNext()) {
            PlainSelect plainSelect = (PlainSelect)iter.next();
            plainSelect.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(" UNION ").append(allDistinct);
        }
        if (union.getOrderByElements() != null) {
            this.deparseOrderBy(false, union.getOrderByElements());
        }
        if (union.getLimit() != null) {
            this.deparseLimit(union.getLimit());
        }
    }

    @Override
    public void visit(OrderByElement orderBy) {
        OrderByElement.NullOrdering nullOrdering;
        orderBy.getExpression().accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        }
        if ((nullOrdering = orderBy.getNullOrdering()) != null) {
            this.buffer.append(' ');
            this.buffer.append(nullOrdering == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
        }
    }

    public void visit(Column column) {
        this.buffer.append(column.getWholeColumnName());
    }

    @Override
    public void visit(AllColumns allColumns) {
        this.buffer.append("*");
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
        this.buffer.append(String.valueOf(allTableColumns.getTable().getWholeTableName()) + ".*");
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.expressionVisitor);
        if (selectExpressionItem.getAlias() != null) {
            this.buffer.append(" AS " + selectExpressionItem.getAlias());
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.buffer.append("(");
        subSelect.getSelectBody().accept(this);
        this.buffer.append(")");
        String alias = subSelect.getAlias();
        if (alias != null && !alias.isEmpty()) {
            this.buffer.append(" ").append(alias);
        }
    }

    @Override
    public void visit(Table tableName) {
        SQLServerHints sqlServerHints;
        MySQLIndexHint indexHint;
        this.buffer.append(tableName.getWholeTableName());
        String alias = tableName.getAlias();
        if (alias != null && !alias.isEmpty()) {
            this.buffer.append(" ").append(alias);
            if (this.dbType == 2) {
                this.setChange();
            }
        }
        if ((indexHint = tableName.getIndexHint()) != null) {
            String action = indexHint.getAction().toUpperCase();
            String indexQualifier = indexHint.getIndexQualifier().toUpperCase();
            List<String> indexNames = indexHint.getIndexNames();
            this.buffer.append(" ").append(action).append(" ").append(indexQualifier).append(" (");
            int i = 0;
            while (i < indexNames.size()) {
                if (i > 0) {
                    this.buffer.append(", ");
                }
                String indexName = indexNames.get(i);
                this.buffer.append(indexName.toUpperCase());
                ++i;
            }
            this.buffer.append(")");
        }
        if ((sqlServerHints = tableName.getSqlServerHints()) != null) {
            this.buffer.append(" WITH (");
            Boolean noLock = sqlServerHints.getNoLock();
            String indexName = sqlServerHints.getIndexName();
            if (Boolean.TRUE.equals(noLock)) {
                this.buffer.append("NOLOCK");
            }
            if (indexName != null) {
                if (Boolean.TRUE.equals(noLock)) {
                    this.buffer.append(", ");
                }
                this.buffer.append("INDEX (").append(indexName.toUpperCase()).append(")");
            }
            this.buffer.append(")");
        }
    }

    public void deparseOrderBy(boolean isOracleSiblings, List<?> orderByElements) {
        if (isOracleSiblings) {
            this.buffer.append(" ORDER SIBLINGS BY ");
        } else {
            this.buffer.append(" ORDER BY ");
        }
        Iterator<?> iter = orderByElements.iterator();
        while (iter.hasNext()) {
            OrderByElement orderByElement = (OrderByElement)iter.next();
            orderByElement.accept(this);
            if (!iter.hasNext()) continue;
            this.buffer.append(", ");
        }
    }

    public void deparseLimit(Limit limit) {
        this.buffer.append(" LIMIT ");
        if (limit.hasOffsetKey()) {
            if (limit.isRowCountJdbcParameter()) {
                this.buffer.append("?");
            } else if (limit.getRowCount() != 0L) {
                this.buffer.append(limit.getRowCount());
            } else {
                this.buffer.append("18446744073709551615");
            }
            if (limit.isOffsetJdbcParameter()) {
                this.buffer.append(" OFFSET ?");
            } else if (limit.getOffset() != 0L) {
                this.buffer.append(" OFFSET " + limit.getOffset());
            }
        } else {
            if (limit.isOffsetJdbcParameter()) {
                this.buffer.append("?, ");
            } else if (limit.getOffset() != 0L) {
                this.buffer.append(String.valueOf(limit.getOffset()) + ", ");
            }
            if (limit.isRowCountJdbcParameter()) {
                this.buffer.append("?");
            } else if (limit.getRowCount() != 0L) {
                this.buffer.append(limit.getRowCount());
            } else {
                this.buffer.append("18446744073709551615");
            }
        }
    }

    public StringBuffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(StringBuffer buffer) {
        this.buffer = buffer;
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor visitor) {
        this.expressionVisitor = visitor;
    }

    @Override
    public void visit(SubJoin subjoin) {
        this.buffer.append("(");
        subjoin.getLeft().accept(this);
        this.buffer.append(" ");
        this.deparseJoin(subjoin.getJoin());
        this.buffer.append(")");
    }

    protected Expression getJoinOnExpression(Join join) {
        return join.getOnExpression();
    }

    public void deparseJoin(Join join) {
        if (join.isSimple()) {
            this.buffer.append(", ");
        } else {
            this.buffer.append(" ");
            if (join.isRight()) {
                this.buffer.append("RIGHT ");
            } else if (join.isNatural()) {
                this.buffer.append("NATURAL ");
            } else if (join.isFull()) {
                this.buffer.append("FULL ");
            } else if (join.isLeft()) {
                this.buffer.append("LEFT ");
            }
            if (join.isOuter()) {
                this.buffer.append("OUTER ");
            } else if (join.isInner()) {
                this.buffer.append("INNER ");
            }
            this.buffer.append("JOIN ");
        }
        FromItem fromItem = join.getRightItem();
        fromItem.accept(this);
        Expression onExpression = this.getJoinOnExpression(join);
        if (onExpression != null) {
            this.buffer.append(" ON ");
            onExpression.accept(this.expressionVisitor);
        }
        if (join.getUsingColumns() != null) {
            this.buffer.append(" USING ( ");
            Iterator iterator = join.getUsingColumns().iterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                this.buffer.append(column.getWholeColumnName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(" ,");
            }
            this.buffer.append(")");
        }
    }
}

