/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.source;

import java.sql.SQLException;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.query.source.AbstractSelectSource;
import net.boke.jsqlparser.query.source.QuerySourceFactory;
import net.boke.jsqlparser.query.source.part.QueryOrderby;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Union;

public class UnionSource
extends AbstractSelectSource<Union> {
    private QueryOrderby orderby = null;

    public UnionSource(Union union) throws SQLException {
        super(union, "");
    }

    @Override
    protected void buildSubSource(Union union) throws SQLException {
        boolean bFirst = true;
        for (Object obj : union.getPlainSelects()) {
            PlainSelect plain = (PlainSelect)obj;
            AbstractQuerySource<?> fromSource = QuerySourceFactory.create(plain);
            this.addFromSource(fromSource);
            if (!bFirst) continue;
            this.primarySource = fromSource;
            bFirst = false;
        }
        this.setOrderby(new QueryOrderby(union.getOrderByElements(), (AbstractQuerySource<?>)this));
    }

    protected void setOrderby(QueryOrderby orderby) {
        this.orderby = orderby;
    }

    public QueryOrderby getOrderby() {
        return this.orderby;
    }

    @Override
    public void addFromSource(AbstractQuerySource<?> fromSource) {
        int index = this.ensureMapSourceFromBlocks().size();
        this.ensureMapSourceFromBlocks().put("UNION_" + index, fromSource);
        fromSource.setParentSource(this);
    }
}

