/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.source;

import java.sql.SQLException;
import net.boke.jsqlparser.base.ISqlElement;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.query.source.PlainSource;
import net.boke.jsqlparser.query.source.SubJoinSource;
import net.boke.jsqlparser.query.source.SubSelectSource;
import net.boke.jsqlparser.query.source.TableSource;
import net.boke.jsqlparser.query.source.UnionSource;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SubJoin;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;

public class QuerySourceFactory {
    public static AbstractQuerySource<?> create(ISqlElement elem) throws SQLException {
        if (elem instanceof SubSelect) {
            return SubSelectSource.newInstance((SubSelect)elem);
        }
        if (elem instanceof SubJoin) {
            return SubJoinSource.newInstance((SubJoin)elem);
        }
        if (elem instanceof Table) {
            return TableSource.newInstance((Table)elem);
        }
        if (elem instanceof PlainSelect) {
            return new PlainSource((PlainSelect)elem);
        }
        if (elem instanceof Union) {
            return new UnionSource((Union)elem);
        }
        throw new SQLException("Sqlitem unsupport to create query block:" + elem.toString());
    }
}

