/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.query.source;

import com.bokesoft.yes.mid.mysqls.sql.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.query.source.AbstractQuerySource;
import net.boke.jsqlparser.query.source.QuerySourceFactory;
import net.boke.jsqlparser.query.source.part.QueryGroupby;
import net.boke.jsqlparser.query.source.part.QueryHaving;
import net.boke.jsqlparser.query.source.part.QueryItems;
import net.boke.jsqlparser.query.source.part.QueryJoinOn;
import net.boke.jsqlparser.query.source.part.QueryOrderby;
import net.boke.jsqlparser.query.source.part.QueryWhere;
import net.boke.jsqlparser.query.source.type.EJoinOnType;
import net.boke.jsqlparser.query.util.SourceHelperUtil;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class PlainSource
extends AbstractQuerySource<PlainSelect> {
    private QueryItems queryItems = null;
    private QueryWhere where = null;
    private QueryGroupby groupby = null;
    private QueryOrderby orderby = null;
    private QueryHaving having = null;

    public PlainSource(PlainSelect plainSelect) throws SQLException {
        super(plainSelect, "");
        this.buildPlainSelectPart(plainSelect);
    }

    @Override
    protected void buildSubSource(PlainSelect plain) throws SQLException {
        FromItem fromItem = plain.getFromItem();
        if (fromItem == null) {
            return;
        }
        AbstractQuerySource<?> fromSource = QuerySourceFactory.create(fromItem);
        this.addFromSource(fromSource);
    }

    protected void buildPlainSelectPart(PlainSelect plain) throws SQLException {
        List joins = plain.getJoins();
        if (joins != null) {
            Join join;
            for (Object item : joins) {
                join = (Join)item;
                AbstractQuerySource<?> joinSource = QuerySourceFactory.create(join.getRightItem());
                this.addFromSource(joinSource);
            }
            for (Object item : joins) {
                join = (Join)item;
                EJoinOnType joinType = SourceHelperUtil.getJoinOnType(join);
                this.addJoinOn(new QueryJoinOn(joinType, join.getOnExpression(), this));
            }
        }
        this.setQueryItems(new QueryItems(plain.getSelectItems(), (AbstractQuerySource<?>)this));
        this.buildPlainSelectPart(this, plain);
    }

    protected void buildPlainSelectPart(PlainSource source, PlainSelect plain) throws SQLException {
        if (plain.getWhere() != null) {
            source.setWhere(new QueryWhere(plain.getWhere(), (AbstractQuerySource<?>)source));
        }
        if (plain.getGroupByColumnReferences() != null) {
            source.setGroupby(new QueryGroupby(plain.getGroupByColumnReferences(), (AbstractQuerySource<?>)source));
        }
        if (plain.getOrderByElements() != null) {
            source.setOrderby(new QueryOrderby(plain.getOrderByElements(), (AbstractQuerySource<?>)source));
        }
        if (plain.getHaving() != null) {
            source.setHaving(new QueryHaving(plain.getHaving(), (AbstractQuerySource<?>)source));
        }
    }

    protected void setQueryItems(QueryItems queryItems) {
        this.queryItems = queryItems;
    }

    protected void setWhere(QueryWhere where) {
        this.where = where;
    }

    protected void setGroupby(QueryGroupby groupby) {
        this.groupby = groupby;
    }

    protected void setOrderby(QueryOrderby orderby) {
        this.orderby = orderby;
    }

    private void setHaving(QueryHaving having) {
        this.having = having;
    }

    @Override
    public AbstractSqlElement getResultItem(String columnName, String tableAlias) {
        if (this.queryItems == null) {
            return null;
        }
        return this.queryItems.getItemByColumnName(columnName, tableAlias);
    }

    @Override
    public List<Field> getResultFields() throws Throwable {
        return this.queryItems.getResultFields();
    }

    @Override
    public Field getField(String columnName) throws SQLException {
        AbstractSqlElement elem = this.getResultItem(columnName);
        if (elem != null) {
            return this.parseSelectItem2Field((SelectExpressionItem)elem);
        }
        throw new SQLException("Can't match column:" + columnName);
    }

    @Override
    public List<Field> getAllFields() throws Throwable {
        ArrayList<Field> list = new ArrayList<Field>();
        if (this.mapFromSources == null) {
            return list;
        }
        for (AbstractQuerySource source : this.mapFromSources.values()) {
            list.addAll(source.getResultFields());
        }
        return list;
    }

    @Override
    public AbstractSqlElement getResultItemInSubSources(String columnName) {
        if (this.mapFromSources == null) {
            return null;
        }
        for (AbstractQuerySource subSource : this.mapFromSources.values()) {
            AbstractSqlElement result = subSource.getResultItem(columnName, null);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean isResultColumn(String columnName) {
        return this.queryItems.containResultColumn(columnName);
    }

    @Override
    public boolean isNoSplit() {
        return ((PlainSelect)this.getSqlItem()).isNoSplit();
    }

    @Override
    public void bindPartsSource() throws SQLException {
        if (this.queryItems != null) {
            this.queryItems.bindSource();
        }
        if (this.where != null) {
            this.where.bindSource();
        }
        if (this.groupby != null) {
            this.groupby.bindSource();
        }
        if (this.orderby != null) {
            this.orderby.bindSource();
        }
        if (this.having != null) {
            this.having.bindSource();
        }
        super.bindPartsSource();
    }

    @Override
    public void clearAll() {
        this.queryItems = null;
        this.where = null;
        this.groupby = null;
        this.orderby = null;
        this.having = null;
        super.clearAll();
    }
}

