/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.expression.operators.relational;

import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.IElementVisitor;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.schema.Column;

public class MultiInExpression
extends AbstractSqlElement
implements Expression {
    private List<Column> columnList;
    private List<List<Expression>> valuesList;

    public MultiInExpression() {
    }

    public MultiInExpression(List<Column> columnList, List<List<Expression>> valuesList) {
        this.setColumnList(columnList);
        this.setValuesList(valuesList);
    }

    public List<Column> getColumnList() {
        return this.columnList;
    }

    public List<List<Expression>> getValuesList() {
        return this.valuesList;
    }

    public void setColumnList(List<Column> columnList) {
        this.columnList = columnList;
    }

    public void setValuesList(List<List<Expression>> valuesList) {
        this.valuesList = valuesList;
    }

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("(");
        List<Column> columnList = this.getColumnList();
        buffer.append(columnList.get(0));
        int i = 1;
        int size = columnList.size();
        while (i < size) {
            buffer.append(",").append(columnList.get(i));
            ++i;
        }
        buffer.append(") IN (");
        List<List<Expression>> valuesList = this.getValuesList();
        buffer.append(MultiInExpression.valuesToString(valuesList.get(0)));
        int i2 = 1;
        int size2 = valuesList.size();
        while (i2 < size2) {
            buffer.append(",");
            buffer.append(MultiInExpression.valuesToString(valuesList.get(i2)));
            ++i2;
        }
        buffer.append(")");
        return buffer.toString();
    }

    private static String valuesToString(List<Expression> values) {
        StringBuilder buffer = new StringBuilder(512);
        buffer.append("(");
        Expression value = values.get(0);
        buffer.append(value);
        int i = 1;
        int size = values.size();
        while (i < size) {
            value = values.get(i);
            buffer.append(",").append(value);
            ++i;
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void traversalChildren(IElementVisitor sqlElementVisitor) {
        for (Column column : this.columnList) {
            column.traversal(sqlElementVisitor);
        }
        for (List list : this.valuesList) {
            for (Expression value : list) {
                value.traversal(sqlElementVisitor);
            }
        }
    }
}

