/*
 * Decompiled with CFR 0.152.
 */
package net.boke.jsqlparser.expression;

import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.base.IElementVisitor;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.statement.select.PlainSelect;

public class AnalyticExpression
extends AbstractSqlElement
implements Expression {
    private ExpressionList partitionExpressionList;
    private List orderByElements;
    private String name;
    private Expression expression;
    private boolean allColumns = false;

    @Override
    public void accept(ExpressionVisitor expressionVisitor) {
        expressionVisitor.visit(this);
    }

    public List getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List orderByElements) {
        this.orderByElements = orderByElements;
    }

    public ExpressionList getPartitionExpressionList() {
        return this.partitionExpressionList;
    }

    public void setPartitionExpressionList(ExpressionList partitionExpressionList) {
        this.partitionExpressionList = partitionExpressionList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.intern();
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public boolean isAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(boolean allColumns) {
        this.allColumns = allColumns;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.name).append("(");
        if (this.expression != null) {
            b.append(this.expression.toString());
        } else if (this.isAllColumns()) {
            b.append("*");
        }
        b.append(") ");
        b.append("OVER");
        b.append(" (");
        this.toStringPartitionBy(b);
        this.toStringOrderByElements(b);
        b.append(")");
        return b.toString();
    }

    private void toStringPartitionBy(StringBuilder b) {
        if (this.partitionExpressionList != null && !this.partitionExpressionList.getExpressions().isEmpty()) {
            b.append("PARTITION BY ");
            b.append(PlainSelect.getStringList(this.partitionExpressionList.getExpressions(), true, false));
            b.append(" ");
        }
    }

    private void toStringOrderByElements(StringBuilder b) {
        if (this.orderByElements != null && !this.orderByElements.isEmpty()) {
            b.append("ORDER BY ");
            int i = 0;
            while (i < this.orderByElements.size()) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(this.orderByElements.get(i).toString());
                ++i;
            }
        }
    }

    @Override
    public void traversalChildren(IElementVisitor sqlElementVisitor) {
        if (this.partitionExpressionList != null) {
            this.partitionExpressionList.traversal(sqlElementVisitor);
        }
        if (this.orderByElements != null) {
            for (Object item : this.orderByElements) {
                if (!(item instanceof Expression)) continue;
                ((Expression)item).traversal(sqlElementVisitor);
            }
        }
        if (this.expression != null) {
            this.expression.traversal(sqlElementVisitor);
        }
    }
}

