/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.util;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.IQueryColumnMetaData;
import com.bokesoft.yes.mid.mysqls.result.process.util.ResultProcessUtils;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.exception.StructException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Locale;

public class DocumentDBUtil {
    public static DataTable populate(IDBManager dbManager, ResultSet rs, IQueryColumnMetaData columnMetaData) throws Throwable {
        if (rs instanceof DataTableResultSet && ((DataTableResultSet)rs).getHiddenColumnCount() == 0) {
            return ((DataTableResultSet)rs).getDataTable();
        }
        return DocumentDBUtil.impl_populate(dbManager, rs, columnMetaData, null);
    }

    public static DataTable populate(IDBManager dbManager, ResultSet rs) throws Throwable {
        if (rs instanceof DataTableResultSet && ((DataTableResultSet)rs).getHiddenColumnCount() == 0) {
            return ((DataTableResultSet)rs).getDataTable();
        }
        return DocumentDBUtil.impl_populate(dbManager, rs, new NormalQueryColumnMetaData(dbManager), null);
    }

    public static DataTable populate(IDBManager dbManager, ResultSet resultSet, DataTableMetaData cachedDataTableMetaData) throws Throwable {
        if (resultSet instanceof DataTableResultSet && ((DataTableResultSet)resultSet).getHiddenColumnCount() == 0) {
            return ((DataTableResultSet)resultSet).getDataTable();
        }
        NormalQueryColumnMetaData columnMetaData = cachedDataTableMetaData != null ? null : new NormalQueryColumnMetaData(dbManager);
        return DocumentDBUtil.impl_populate(dbManager, resultSet, columnMetaData, cachedDataTableMetaData);
    }

    private static DataTable impl_populate(IDBManager dbManager, ResultSet rs, IQueryColumnMetaData columnMetaData, DataTableMetaData dataTableMetaData) throws Throwable {
        int i;
        ResultSetMetaData metaData = rs.getMetaData();
        int hiddenColumnCount = rs instanceof ResultSetGetObjectByPos ? ((ResultSetGetObjectByPos)rs).getHiddenColumnCount() : 0;
        int columnCount = metaData.getColumnCount() - hiddenColumnCount;
        int[] SQLTypeList = new int[columnCount];
        int[] dataTypeList = new int[columnCount];
        int[] scaleList = new int[columnCount];
        String[] colNameList = new String[columnCount];
        if (dataTableMetaData == null) {
            dataTableMetaData = new DataTableMetaData();
            i = 1;
            while (i <= columnCount) {
                int scale;
                String columnName = metaData.getColumnLabel(i);
                int SQLType2 = metaData.getColumnType(i);
                if (StringUtil.isBlankOrNull((String)columnName)) {
                    columnName = ResultProcessUtils.genAutoColumnName(i);
                }
                int dataType = columnMetaData.getColumnType(metaData, i, columnName);
                scaleList[i - 1] = scale = metaData.getScale(i);
                if (dataType == 1005 && DBManagerUtil.isOracleLikeDatabase((int)dbManager.getDBType()) && scale == 0) {
                    int precision = metaData.getPrecision(i);
                    if (precision >= 1 && precision <= 9) {
                        dataType = 1001;
                    } else if (precision >= 10 && precision <= 20) {
                        dataType = 1010;
                    }
                }
                SQLTypeList[i - 1] = SQLType2;
                dataTypeList[i - 1] = dataType;
                colNameList[i - 1] = columnName = DocumentDBUtil.getNotRepeatColumnName(dataTableMetaData, columnName);
                ColumnInfo c = new ColumnInfo(columnName, dataType);
                if (dataType == 1002) {
                    c.setLength(metaData.getColumnDisplaySize(i));
                }
                c.setScale(scale);
                dataTableMetaData.addColumn(c);
                ++i;
            }
        } else {
            i = 1;
            while (i <= columnCount) {
                SQLTypeList[i - 1] = metaData.getColumnType(i);
                colNameList[i - 1] = metaData.getColumnLabel(i);
                dataTypeList[i - 1] = dataTableMetaData.getColumnInfo(colNameList[i - 1]).getDataType();
                scaleList[i - 1] = dataTableMetaData.getColumnInfo(colNameList[i - 1]).getScale();
                ++i;
            }
        }
        DataTable table = new DataTable(dataTableMetaData);
        rs.beforeFirst();
        if (rs.next()) {
            do {
                int rowIndex = table.append();
                Row row = table.getRowByIndex(rowIndex);
                Object[] dataList = row.getDataList();
                int i2 = 1;
                while (i2 <= columnCount) {
                    Object value = rs.getObject(i2);
                    int dataType = dbManager.convertDataType(SQLTypeList[i2 - 1]);
                    if (value != null) {
                        value = dataType == 1005 && scaleList[i2 - 1] > 0 ? TypeConvertor.toBigDecimal((Object)value, (Integer)scaleList[i2 - 1]) : TypeConvertor.toDataType((int)dataType, (Object)value);
                    }
                    dataList[i2 - 1] = value = dbManager.convert(value, dataTypeList[i2 - 1], SQLTypeList[i2 - 1]);
                    ++i2;
                }
                row.updateIndex();
            } while (rs.next());
            rs.close();
        } else {
            rs.close();
        }
        return table;
    }

    private static String getNotRepeatColumnName(DataTableMetaData dataTableMetaData, String columnName) {
        if (dataTableMetaData.findColumnIndexByKey(columnName) < 0) {
            return columnName;
        }
        int i = 0;
        while (i < 1024) {
            String newColumnName = String.valueOf(columnName) + i;
            if (dataTableMetaData.findColumnIndexByKey(newColumnName) < 0) {
                return newColumnName;
            }
            ++i;
        }
        throw new RuntimeException("\u751f\u6210\u4e0d\u91cd\u590d\u7684\u5b57\u6bb5\u540d " + columnName + " \u51fa\u9519\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
    }

    public static void populateRow(IDBManager dbManager, DataTable table, ResultSet rs, ArrayList<String> DBKeyList) throws Throwable {
        ResultSetMetaData rsMetaData = rs.getMetaData();
        int resultSetColumnCount = rsMetaData.getColumnCount();
        String[] resultSetDBKeys = new String[resultSetColumnCount];
        int i = 0;
        while (i < resultSetColumnCount) {
            String columnLabel;
            resultSetDBKeys[i] = columnLabel = rsMetaData.getColumnLabel(i + 1);
            ++i;
        }
        DataTableMetaData tableMetaData = table.getMetaData();
        int columnCount = DBKeyList.size();
        int[] dataTableTypes = new int[columnCount];
        int[] resultSetIndex = new int[columnCount];
        int[] resultSetTypes = new int[columnCount];
        int i2 = 0;
        while (i2 < columnCount) {
            int tmp;
            resultSetIndex[i2] = tmp = DocumentDBUtil.findIgnoreCase(resultSetDBKeys, DBKeyList.get(i2));
            if (tmp != -1) {
                resultSetTypes[i2] = rsMetaData.getColumnType(tmp + 1);
                dataTableTypes[i2] = tableMetaData.getColumnInfo(i2).getDataType();
            }
            ++i2;
        }
        Row row = table.getRowByIndex(table.getPos());
        Object[] dataList = row.getDataList();
        int i3 = 0;
        while (i3 < columnCount) {
            int tmp = resultSetIndex[i3];
            if (tmp >= 0) {
                Object value;
                dataList[i3] = value = dbManager.convert(rs.getObject(tmp + 1), dataTableTypes[i3], resultSetTypes[i3]);
            }
            ++i3;
        }
        table.batchUpdate();
    }

    public static void processTableSort(DataTable dataTable, SortCriteria[] vCriteria) throws Throwable {
        dataTable.setSort(vCriteria);
        dataTable.sort((row1, row2) -> {
            DataTableMetaData metaData = dataTable.getMetaData();
            SortCriteria[] sortCriteriaArray2 = vCriteria;
            int n = vCriteria.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    int ret;
                    SortCriteria s;
                    block10: {
                        Object value2;
                        Object value1;
                        ColumnInfo columnInfo;
                        block9: {
                            s = sortCriteriaArray2[n2];
                            int columnIndex = 0;
                            try {
                                columnIndex = metaData.findColumnIndexByKey(s.getColumnKey());
                            }
                            catch (StructException e) {
                                break block8;
                            }
                            columnInfo = metaData.getColumnInfo(columnIndex);
                            ret = 0;
                            value1 = row1.getObject(columnIndex);
                            value2 = row2.getObject(columnIndex);
                            if (columnInfo.getDataType() != 1002) break block9;
                            if (value1 == value2) break block8;
                            if (value1 == null) {
                                ret = -1;
                            } else if (value2 == null) {
                                ret = 1;
                            } else {
                                Collator collator = Collator.getInstance(Locale.US);
                                collator.setStrength(0);
                                ret = collator.compare(value1, value2);
                            }
                            break block10;
                        }
                        ret = columnInfo.getDataTypeAction().compare(value1, value2);
                    }
                    int n3 = ret = s.isAscending() ? ret : -ret;
                    if (ret != 0) {
                        return ret;
                    }
                }
                ++n2;
            }
            return 0;
        });
    }

    private static int findIgnoreCase(String[] array, String s) {
        int size = array.length;
        int i = 0;
        while (i < size) {
            if (s.equalsIgnoreCase(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static final class NormalQueryColumnMetaData
    implements IQueryColumnMetaData {
        private IDBManager dbManager = null;

        public NormalQueryColumnMetaData(IDBManager dbManager) {
            this.dbManager = dbManager;
        }

        public int getColumnType(ResultSetMetaData metaData, int index, String column) throws Throwable {
            return this.dbManager.convertDataType(metaData.getColumnType(index));
        }
    }
}

