/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.sql;

import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.dbmanager.interceptor.stage.visitor.BaseExpressionVisitor;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.sql.ColumnValue;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import java.sql.SQLException;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.update.Update;

public class UpdateSqlInfo
extends SqlInfo {
    final Update update;
    boolean hasCheckSupportMultiDBs = false;
    Boolean isNoGroup = null;

    private UpdateSqlInfo(String sql) {
        super(sql);
        this.update = null;
    }

    UpdateSqlInfo(String sql, Update update) {
        super(sql);
        this.update = update;
    }

    @Override
    public Statement getStatement() {
        return this.update;
    }

    @Override
    public String parseTableName() {
        String result = this.update.getTable().getName();
        return result;
    }

    @Override
    public ColumnValue parseGroupOriginalValue(String columnKey) throws SQLException {
        Expression where = this.update.getWhere();
        return SelectSqlInfo.parsePrimaryKeyValueInWhere(where, columnKey, this.getJdbcParameters(), null);
    }

    @Override
    public ColumnValue parseGroupNewValue(String columneKey) throws SQLException {
        List columns = this.update.getColumns();
        int i = 0;
        int len = columns.size();
        while (i < len) {
            String columnNameTmp = ((Column)columns.get(i)).getColumnName();
            if (columneKey.equalsIgnoreCase(columnNameTmp)) {
                List expressions = this.update.getExpressions();
                ColumnValue result = new ColumnValue();
                Object value = expressions.get(i);
                if (value instanceof JdbcParameter) {
                    result.parameterIndex = this.getJdbcParameters().indexOf((JdbcParameter)value) + 1;
                } else if (value instanceof LongValue) {
                    result.valueInSQL = Long.valueOf(value.toString());
                } else {
                    throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u5206\u7ec4\u5b57\u6bb5" + columneKey + "\u7684\u503c\u53ea\u652f\u6301\u5e38\u91cf\uff0cSQL " + this.update + "\u4e0d\u652f\u6301\u3002");
                }
                return result;
            }
            ++i;
        }
        return null;
    }

    public Expression getWhere() {
        return this.update.getWhere();
    }

    public void checkSupportMultiDBs() {
        if (!this.hasCheckSupportMultiDBs) {
            if (this.update.getWhere() != null) {
                this.update.getWhere().accept(new BaseExpressionVisitor(){

                    @Override
                    public void visit(SubSelect subSelect) {
                        throw new RuntimeException("SQL\u4e0d\u652f\u6301\u5206\u5e93\uff0cDELETE\u8bed\u53e5\u4e0d\u5e94\u8be5\u5305\u542b\u5b50\u67e5\u8be2" + subSelect.toString() + "\uff0c\u8bf7\u4fee\u6539\u3002\n" + UpdateSqlInfo.this.sql);
                    }
                });
            }
            this.hasCheckSupportMultiDBs = true;
        }
    }

    @Override
    public boolean isNoGroup() {
        if (this.isNoGroup == null) {
            boolean hasGroup;
            String tableName = this.parseTableName();
            boolean bl = hasGroup = TableGroupProps.getInstance().getTableGroupProp(tableName) != null;
            if (!hasGroup) {
                final RefObject hasGroupTmp = new RefObject((Object)false);
                BaseExpressionVisitor visitor = new BaseExpressionVisitor(){

                    @Override
                    public void visit(Table tableName) {
                        if (!((Boolean)hasGroupTmp.getValue()).booleanValue() && TableGroupProps.getInstance().getTableGroupProp(tableName.getName()) != null) {
                            hasGroupTmp.setValue((Object)true);
                        }
                        super.visit(tableName);
                    }
                };
                if (this.update.getWhere() != null) {
                    this.update.getWhere().accept(visitor);
                }
                int i = 0;
                int size = this.update.getExpressions().size();
                while (i < size) {
                    Expression exp = (Expression)this.update.getExpressions().get(i);
                    exp.accept(visitor);
                    ++i;
                }
                hasGroup = (Boolean)hasGroupTmp.getValue();
            }
            this.isNoGroup = !hasGroup;
        }
        return this.isNoGroup;
    }
}

