/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.sql;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.group.DateGroupField;
import com.bokesoft.yes.mid.mysqls.group.DictGroupField;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.YearGroupField;
import com.bokesoft.yes.mid.mysqls.group.YearMonthGroupField;
import com.bokesoft.yes.mid.mysqls.sql.BetweenValue;
import com.bokesoft.yes.mid.mysqls.sql.ColumnValue;
import com.bokesoft.yes.mid.mysqls.sql.FindJdbcParameter;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.parser.CCJSqlParserManager;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.update.Update;
import org.apache.commons.lang3.ArrayUtils;

public abstract class SqlInfo {
    protected final String sql;
    private String tableName = null;
    HashMapIgnoreCase<ColumnValue> columnOriginalValues;
    HashMapIgnoreCase<ColumnValue> columnNewValues;
    private List<JdbcParameter> jdbcParameters;

    public SqlInfo(String sql) {
        this.sql = sql;
    }

    public String getSql() {
        return this.sql;
    }

    public abstract Statement getStatement();

    public String getTableName() {
        if (this.tableName == null) {
            this.tableName = this.parseTableName();
        }
        return this.tableName;
    }

    public abstract String parseTableName();

    public synchronized boolean hasGroupOriginalValue(String columnKey) throws SQLException {
        ColumnValue columnValue;
        if (this.columnOriginalValues == null) {
            this.columnOriginalValues = new HashMapIgnoreCase();
        }
        if (!this.columnOriginalValues.containsKey(columnKey) || this.columnOriginalValues.get(columnKey) == null) {
            columnValue = this.parseGroupOriginalValue(columnKey);
            this.columnOriginalValues.put(columnKey, (Object)columnValue);
        }
        return (columnValue = (ColumnValue)this.columnOriginalValues.get(columnKey)) != null && columnValue.hasValue();
    }

    public synchronized boolean hasGroupNewValue(String columnKey) throws SQLException {
        ColumnValue columnValue;
        if (this.columnNewValues == null) {
            this.columnNewValues = new HashMapIgnoreCase();
        }
        if (!this.columnNewValues.containsKey(columnKey)) {
            columnValue = this.parseGroupNewValue(columnKey);
            this.columnNewValues.put(columnKey, (Object)columnValue);
        }
        return (columnValue = (ColumnValue)this.columnNewValues.get(columnKey)) != null && columnValue.hasValue();
    }

    protected abstract ColumnValue parseGroupOriginalValue(String var1) throws SQLException;

    protected abstract ColumnValue parseGroupNewValue(String var1) throws SQLException;

    public Long getPrimaryKeyLongNewValue(String columnKey, Parameters parameters) throws SQLException {
        Long result;
        if (parameters != null && columnKey.equalsIgnoreCase(parameters.getColumnNameRefHeadOID())) {
            result = parameters.getHeadOID(columnKey);
        } else {
            Object value = this.getPrimaryKeyNewValue(columnKey, parameters);
            result = TypeConvertor.toLong((Object)value);
        }
        return result;
    }

    public synchronized OneOrMultiValue<Long> getPrimaryKeyLongOriginalValue(String columnKey, Parameters parameters) throws SQLException {
        OneOrMultiValue<Long> result = new OneOrMultiValue<Long>();
        if (parameters != null && columnKey.equalsIgnoreCase(parameters.getColumnNameRefHeadOID())) {
            result.addValue(parameters.getHeadOID(columnKey));
        } else {
            Object value = this.getPrimaryKeyOriginalValue(columnKey, parameters);
            result = OneOrMultiValue.getLongs(value);
        }
        return result;
    }

    public synchronized OneOrMultiValue<Long> getPrimaryKeyLongOriginalValue(String columnKey, List<Parameters> parametersList) throws SQLException {
        OneOrMultiValue<Long> result = null;
        if (parametersList == null) {
            result = this.getPrimaryKeyLongOriginalValue(columnKey, (Parameters)null);
        } else {
            for (Parameters parameters : parametersList) {
                OneOrMultiValue<Long> tmp = this.getPrimaryKeyLongOriginalValue(columnKey, parameters);
                if (result == null) {
                    result = tmp;
                    continue;
                }
                result.addAllValue(tmp);
            }
        }
        return result;
    }

    public synchronized OneOrMultiValue<Long> getPrimaryKeyLongNewValue(String columnKey, List<Parameters> parametersList) throws SQLException {
        OneOrMultiValue<Long> result = new OneOrMultiValue<Long>();
        if (parametersList == null) {
            Long tmp = this.getPrimaryKeyLongNewValue(columnKey, (Parameters)null);
            result.addValue(tmp);
        } else {
            for (Parameters parameters : parametersList) {
                Long tmp = this.getPrimaryKeyLongNewValue(columnKey, parameters);
                result.addValue(tmp);
            }
        }
        return result;
    }

    public synchronized Object getPrimaryKeyOriginalValue(String columnKey, Parameters parameters) throws SQLException {
        ColumnValue columnValue;
        if (this.hasGroupOriginalValue(columnKey) && (columnValue = (ColumnValue)this.columnOriginalValues.get(columnKey)) != null) {
            return this.getPrimaryKeyValue(columnValue, parameters);
        }
        return null;
    }

    public synchronized String[] getPrimaryKeyOriginalStringValues(String columnKey, Parameters parameters) throws SQLException {
        ColumnValue columnValue;
        if (this.hasGroupOriginalValue(columnKey) && (columnValue = (ColumnValue)this.columnOriginalValues.get(columnKey)) != null) {
            return this.getPrimaryKeyStringValues(columnValue, parameters);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public synchronized Object getPrimaryKeyNewValue(String columnKey, Parameters parameters) throws SQLException {
        ColumnValue columnValue;
        if (this.hasGroupNewValue(columnKey) && (columnValue = (ColumnValue)this.columnNewValues.get(columnKey)) != null) {
            return this.getPrimaryKeyValue(columnValue, parameters);
        }
        return null;
    }

    private Object getPrimaryKeyValue(ColumnValue columnValue, Parameters parameters) throws SQLException {
        if (columnValue == null) {
            return null;
        }
        if (columnValue.valueInSQL != null) {
            return columnValue.valueInSQL;
        }
        if (columnValue.parameterIndex != -1) {
            return parameters.getValue(columnValue.parameterIndex);
        }
        if (columnValue.getStart() != null && columnValue.getEnd() != null) {
            ColumnValue start = columnValue.getStart();
            Object startValue = start.valueInSQL != null ? start.valueInSQL : parameters.getValue(start.parameterIndex);
            ColumnValue end = columnValue.getEnd();
            Object endValue = end.valueInSQL != null ? end.valueInSQL : parameters.getValue(end.parameterIndex);
            return new BetweenValue<Object>(startValue, endValue);
        }
        if (columnValue.inValues != null && columnValue.inValues.size() > 0 || columnValue.inParameterIndexes != null && columnValue.inParameterIndexes.size() > 0) {
            int size2;
            int n = size2 = columnValue.inParameterIndexes != null ? columnValue.inParameterIndexes.size() : 0;
            if (size2 == 0) {
                return columnValue.inValues.toArray(new Long[columnValue.inValues.size()]);
            }
            int size1 = columnValue.inValues != null ? columnValue.inValues.size() : 0;
            ArrayList<Long> result = new ArrayList<Long>(size1 + size2);
            if (size1 > 0) {
                result.addAll(columnValue.inValues);
            }
            int i = 0;
            while (i < size2) {
                Object obj = parameters.getValue(columnValue.inParameterIndexes.get(i));
                result.add(TypeConvertor.toLong((Object)obj));
                ++i;
            }
            return result.toArray(new Long[result.size()]);
        }
        return null;
    }

    private String[] getPrimaryKeyStringValues(ColumnValue columnValue, Parameters parameters) throws SQLException {
        if (columnValue != null) {
            if (columnValue.valueInSQL != null) {
                return new String[]{TypeConvertor.toString((Object)columnValue.valueInSQL)};
            }
            if (columnValue.parameterIndex != -1) {
                return new String[]{TypeConvertor.toString((Object)parameters.getValue(columnValue.parameterIndex))};
            }
            if (columnValue.inValues != null && columnValue.inValues.size() > 0 || columnValue.inParameterIndexes != null && columnValue.inParameterIndexes.size() > 0) {
                int size2 = columnValue.inParameterIndexes != null ? columnValue.inParameterIndexes.size() : 0;
                ArrayList<String> result = new ArrayList<String>(size2);
                int i = 0;
                while (i < size2) {
                    Object obj = parameters.getValue(columnValue.inParameterIndexes.get(i));
                    result.add(TypeConvertor.toString((Object)obj));
                    ++i;
                }
                return result.toArray(new String[result.size()]);
            }
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public OneOrMultiValue<Object> getGroupOriginalValue(GroupField groupField, String columnKey, Parameters parameters) throws SQLException {
        Object value = this.getPrimaryKeyOriginalValue(columnKey, parameters);
        return this.processGroupValue(groupField, value);
    }

    public Object getGroupNewValue(String columnKey, Parameters parameters) throws SQLException {
        Object value = this.getPrimaryKeyNewValue(columnKey, parameters);
        return value;
    }

    private OneOrMultiValue<Object> processGroupValue(GroupField groupField, Object value) {
        OneOrMultiValue<Object> result = new OneOrMultiValue<Object>();
        if (groupField instanceof DateGroupField) {
            if (value == null) {
                result.addValue(GroupField.UndefinedGroupValue);
            } else if (value instanceof BetweenValue) {
                int start = TypeConvertor.toInteger(((BetweenValue)value).start);
                int end = TypeConvertor.toInteger(((BetweenValue)value).end);
                int[] values = ((DateGroupField)groupField).getValues(start, end);
                result.addAllValue(values);
            } else if (value instanceof Object[]) {
                result.addAllValue((Object[])((Object[])value));
            } else {
                result.addValue(TypeConvertor.toInteger((Object)value));
            }
        } else if (groupField instanceof YearMonthGroupField) {
            if (value == null) {
                result.addValue(GroupField.UndefinedGroupValue);
            } else if (value instanceof BetweenValue) {
                int start = TypeConvertor.toInteger(((BetweenValue)value).start);
                int end = TypeConvertor.toInteger(((BetweenValue)value).end);
                int[] values = ((YearMonthGroupField)groupField).getValues(start, end);
                result.addAllValue(values);
            } else if (value instanceof Object[]) {
                result.addAllValue((Object[])((Object[])value));
            } else {
                result.addValue(TypeConvertor.toInteger((Object)value));
            }
        } else if (groupField instanceof YearGroupField) {
            if (value == null) {
                result.addValue(GroupField.UndefinedGroupValue);
            } else if (value instanceof BetweenValue) {
                int start = TypeConvertor.toInteger(((BetweenValue)value).start);
                int end = TypeConvertor.toInteger(((BetweenValue)value).end);
                int[] values = ((YearGroupField)groupField).getValues(start, end);
                result.addAllValue(values);
            } else if (value instanceof Object[]) {
                result.addAllValue((Object[])((Object[])value));
            } else {
                result.addValue(TypeConvertor.toInteger((Object)value));
            }
        } else if (groupField instanceof DictGroupField) {
            if (value == null) {
                result.addValue(GroupField.UndefinedGroupValue);
            } else {
                if (value instanceof BetweenValue) {
                    throw new RuntimeException("\u5206\u5e93\u5b57\u6bb5" + groupField.getKey() + "\u4e0d\u652f\u6301\u8303\u56f4\u3002");
                }
                if (value instanceof Object[]) {
                    result.addAllValue((Object[])((Object[])value));
                } else {
                    result.addValue(TypeConvertor.toLong((Object)value));
                }
            }
        } else {
            throw new RuntimeException("ERROR!");
        }
        return result;
    }

    public boolean isInsert() {
        Statement statement = this.getStatement();
        return statement instanceof Insert;
    }

    public boolean isInsertOrDeleteOrUpdate() {
        Statement statement = this.getStatement();
        return statement instanceof Insert || statement instanceof Delete || statement instanceof Update;
    }

    public boolean isQuery() {
        Statement statement = this.getStatement();
        return statement instanceof Select;
    }

    public int getJDBCParameterCount() {
        return this.getJdbcParameters().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JdbcParameter> getJdbcParameters() {
        if (this.jdbcParameters == null) {
            SqlInfo sqlInfo = this;
            synchronized (sqlInfo) {
                if (this.jdbcParameters == null) {
                    List<JdbcParameter> tmp = FindJdbcParameter.getAllJdbcParameters(this.getStatement());
                    int i = 0;
                    int size = tmp.size();
                    while (i < size) {
                        JdbcParameter jdbcParameter = tmp.get(i);
                        if (jdbcParameter.getIndexInSql() < 0) {
                            jdbcParameter.setIndexInSql(i);
                        }
                        ++i;
                    }
                    this.jdbcParameters = tmp;
                }
            }
        }
        return this.jdbcParameters;
    }

    public void clearJdbcParameters() {
        this.jdbcParameters = null;
    }

    protected Statement getStatementNoCache(String sql) {
        Statement statement;
        CCJSqlParserManager parser = new CCJSqlParserManager();
        try {
            statement = parser.parse(sql);
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("SQL\u8bed\u53e5\u89e3\u6790\u5931\u8d25\uff1a" + sql, e);
        }
        return statement;
    }

    public abstract boolean isNoGroup();

    public String toString() {
        return this.sql;
    }
}

