/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.service.convert.group;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.route.service.convert.group.IGroupConditionContext;
import com.bokesoft.yes.mid.mysqls.route.util.ShardingUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.expression.AllComparisonExpression;
import net.boke.jsqlparser.expression.AnyComparisonExpression;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DateValue;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.ExpressionVisitor;
import net.boke.jsqlparser.expression.Function;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.TimeValue;
import net.boke.jsqlparser.expression.TimestampValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.boke.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.boke.jsqlparser.expression.operators.arithmetic.Concat;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Modulo;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.Between;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExistsExpression;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.expression.operators.relational.IsNullExpression;
import net.boke.jsqlparser.expression.operators.relational.ItemsList;
import net.boke.jsqlparser.expression.operators.relational.LikeExpression;
import net.boke.jsqlparser.expression.operators.relational.Matches;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MultiInExpression;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SubSelect;

public class GroupConditionConvertor
implements ExpressionVisitor {
    private IGroupConditionContext context = null;
    private final Stack<Expression> stackValues = new Stack();

    public GroupConditionConvertor(IGroupConditionContext context) {
        this.context = context;
    }

    public Expression calcExpression(Expression expression) {
        if (expression == null) {
            return null;
        }
        expression.accept(this);
        return this.stackValues.pop();
    }

    @Override
    public void visit(NullValue nullValue) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Function function) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(InverseExpression inverseExpression) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(JdbcParameter jdbcParameter) {
        AbstractSqlElement result = null;
        Object value = this.getParameterValue(jdbcParameter);
        if (value instanceof String) {
            result = new StringValue((String)value);
        } else if (value instanceof Long || value instanceof Integer) {
            result = new LongValue(value.toString());
        }
        this.stackValues.push((Expression)((Object)result));
    }

    private Object getParameterValue(JdbcParameter jdbcParameter) {
        int index = -1;
        index = jdbcParameter.getIndexInSql() < 0 ? jdbcParameter.getIndex() : jdbcParameter.getIndexInSql() + 1;
        return this.context.getParameters().getValue(index);
    }

    @Override
    public void visit(DoubleValue doubleValue) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(LongValue longValue) {
        this.stackValues.push(longValue);
    }

    @Override
    public void visit(DateValue dateValue) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(TimeValue timeValue) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(TimestampValue timestampValue) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Parenthesis parenthesis) {
        Expression result = this.calcExpression(parenthesis.getExpression());
        Parenthesis newParenthesis = null;
        if (result != null) {
            newParenthesis = new Parenthesis();
            if (parenthesis.isNot()) {
                newParenthesis.setNot();
            }
            newParenthesis.setExpression(result);
        }
        this.stackValues.push(newParenthesis);
    }

    @Override
    public void visit(StringValue stringValue) {
        this.stackValues.push(stringValue);
    }

    @Override
    public void visit(Addition addition) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Subtraction subtraction) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Multiplication multiplication) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Division division) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Modulo modulo) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(AndExpression andExpression) {
        Expression result1 = this.calcExpression(andExpression.getLeftExpression());
        Expression result2 = this.calcExpression(andExpression.getRightExpression());
        Expression newExpression = null;
        if (result1 != null && result2 != null) {
            newExpression = new AndExpression(result1, result2);
        } else if (result1 != null) {
            newExpression = result1;
        } else if (result2 != null) {
            newExpression = result2;
        }
        this.stackValues.push(newExpression);
    }

    @Override
    public void visit(OrExpression orExpression) {
        Expression result1 = this.calcExpression(orExpression.getLeftExpression());
        Expression result2 = this.calcExpression(orExpression.getRightExpression());
        Expression newExpression = null;
        if (result1 != null && result2 != null) {
            newExpression = new OrExpression(result1, result2);
        } else if (result1 != null) {
            newExpression = result1;
        } else if (result2 != null) {
            newExpression = result2;
        }
        this.stackValues.push(newExpression);
    }

    @Override
    public void visit(Between between) {
        Expression value = this.calcExpression(between.getLeftExpression());
        if (this.containsNull(value)) {
            this.stackValues.push(null);
            return;
        }
        Expression start = this.calcExpression(between.getBetweenExpressionStart());
        Expression end = this.calcExpression(between.getBetweenExpressionEnd());
        if (start == null || end == null) {
            this.stackValues.push(null);
            return;
        }
        Between newBetween = new Between();
        newBetween.setLeftExpression(value);
        newBetween.setBetweenExpressionStart(start);
        newBetween.setBetweenExpressionEnd(end);
        newBetween.setNot(between.isNot());
        this.stackValues.push(newBetween);
    }

    @Override
    public void visit(InExpression inExpression) {
        Expression value = this.calcExpression(inExpression.getLeftExpression());
        if (this.containsNull(value)) {
            this.stackValues.push(null);
            return;
        }
        ItemsList inItems = inExpression.getItemsList();
        InExpression newInExpression = new InExpression();
        newInExpression.setLeftExpression(value);
        if (inItems instanceof ExpressionList) {
            ExpressionList newValueList = this.calcExpressionListResults((ExpressionList)inItems);
            newInExpression.setItemsList(newValueList);
        } else if (inItems instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)inItems;
            ArrayList<Object> arguments = new ArrayList<Object>();
            this.fetchArgumentValues(subSelect.getSelectBody(), arguments);
            try {
                ExpressionList newValueList = this.context.parseSubSelect2List(subSelect.getSelectBody().toString(), arguments);
                newInExpression.setItemsList(newValueList);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        newInExpression.setNot(inExpression.isNot());
        this.stackValues.push(newInExpression);
    }

    private void fetchArgumentValues(SelectBody selectBody, List<Object> arguments) {
        selectBody.traversal(elem -> {
            if (elem instanceof JdbcParameter) {
                Object value = this.getParameterValue((JdbcParameter)elem);
                arguments.add(value);
            }
            return true;
        });
    }

    @Override
    public void visit(EqualsTo equalsTo) {
        BinaryExpression result = this.calcBinaryExpressionResult(equalsTo, EqualsTo::new);
        this.stackValues.push(result);
    }

    @Override
    public void visit(GreaterThan greaterThan) {
        BinaryExpression result = this.calcBinaryExpressionResult(greaterThan, GreaterThan::new);
        this.stackValues.push(result);
    }

    @Override
    public void visit(GreaterThanEquals greaterThanEquals) {
        BinaryExpression result = this.calcBinaryExpressionResult(greaterThanEquals, GreaterThanEquals::new);
        this.stackValues.push(result);
    }

    @Override
    public void visit(MinorThan minorThan) {
        BinaryExpression result = this.calcBinaryExpressionResult(minorThan, MinorThan::new);
        this.stackValues.push(result);
    }

    @Override
    public void visit(MinorThanEquals minorThanEquals) {
        BinaryExpression result = this.calcBinaryExpressionResult(minorThanEquals, MinorThanEquals::new);
        this.stackValues.push(result);
    }

    @Override
    public void visit(NotEqualsTo notEqualsTo) {
        BinaryExpression result = this.calcBinaryExpressionResult(notEqualsTo, NotEqualsTo::new);
        this.stackValues.push(result);
    }

    @Override
    public void visit(Column column) {
        try {
            Column groupColumn = null;
            String tableName = ShardingUtil.getTableNameByColumn(column);
            String groupFieldKey = this.context.getGroupFieldKey(tableName, column.getColumnName());
            if (!StringUtil.isBlankOrNull((String)groupFieldKey)) {
                groupColumn = new Column(null, groupFieldKey);
            }
            this.stackValues.push(groupColumn);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void visit(MultiInExpression inExpression) {
        int index = 0;
        HashMap<Integer, Column> mapGroupColumns = new HashMap<Integer, Column>();
        for (Column column : inExpression.getColumnList()) {
            String tableName = ShardingUtil.getTableNameByColumn(column);
            String groupFieldKey = this.context.getGroupFieldKey(tableName, column.getColumnName());
            if (!StringUtil.isBlankOrNull((String)groupFieldKey)) {
                Column groupColumn = new Column(null, groupFieldKey);
                mapGroupColumns.put(index, groupColumn);
            }
            ++index;
        }
        Parenthesis result = null;
        for (List<Expression> expList : inExpression.getValuesList()) {
            int valueIndex = 0;
            AbstractSqlElement subExp = null;
            for (Expression exp : expList) {
                if (mapGroupColumns.containsKey(valueIndex)) {
                    Expression value = this.calcExpression(exp);
                    Column column = (Column)mapGroupColumns.get(valueIndex);
                    EqualsTo eq = new EqualsTo(column, value);
                    subExp = subExp == null ? eq : new AndExpression((Expression)((Object)subExp), eq);
                }
                ++valueIndex;
            }
            if (subExp == null) continue;
            subExp = new Parenthesis((Expression)((Object)subExp));
            AbstractSqlElement abstractSqlElement = result = result == null ? subExp : new OrExpression(result, (Expression)((Object)subExp));
        }
        if (result != null) {
            result = new Parenthesis(result);
        }
        this.stackValues.push(result);
    }

    @Override
    public void visit(IsNullExpression isNullExpression) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(LikeExpression likeExpression) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(CaseExpression caseExpression) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(WhenClause whenClause) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(ExistsExpression existsExpression) {
        throw new RuntimeException("Unsupport Expression:" + existsExpression.toString());
    }

    @Override
    public void visit(AllComparisonExpression allComparisonExpression) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(AnyComparisonExpression anyComparisonExpression) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Concat concat) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(Matches matches) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(BitwiseAnd bitwiseAnd) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(BitwiseOr bitwiseOr) {
        this.stackValues.push(null);
    }

    @Override
    public void visit(BitwiseXor bitwiseXor) {
        this.stackValues.push(null);
    }

    private ExpressionList calcExpressionListResults(ExpressionList expList) {
        if (expList == null || expList.getExpressions() == null || expList.getExpressions().isEmpty()) {
            return null;
        }
        ArrayList<Expression> newExpressions = new ArrayList<Expression>();
        for (Object obj : expList.getExpressions()) {
            newExpressions.add(this.calcExpression((Expression)obj));
        }
        return new ExpressionList(newExpressions);
    }

    private boolean containsNull(Object ... values) {
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value == null || value instanceof NullValue) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private BinaryExpression calcBinaryExpressionResult(BinaryExpression orgExpression, IBinaryExpressionCreator creator) {
        Expression result1 = this.calcExpression(orgExpression.getLeftExpression());
        Expression result2 = this.calcExpression(orgExpression.getRightExpression());
        BinaryExpression newExpression = null;
        if (result1 != null && result2 != null) {
            newExpression = creator.newBinaryExpression();
            newExpression.setLeftExpression(result1);
            newExpression.setRightExpression(result2);
        }
        return newExpression;
    }

    private static interface IBinaryExpressionCreator {
        public BinaryExpression newBinaryExpression();
    }
}

