/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.service.convert.group;

import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingGroup;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingTable;
import com.bokesoft.yes.mid.mysqls.route.meta.ShardingMetaConfig;
import com.bokesoft.yes.mid.mysqls.route.service.convert.group.IGroupConditionContext;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.base.AbstractSqlElement;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.NullValue;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;

public class GroupConditionContext
implements IGroupConditionContext {
    private final Parameters parameters;
    private final MetaShardingGroup metaShardingGroup;
    private String mainSharingTableName;
    private IDBManager dbm;

    public GroupConditionContext(String mainSharingTableName, MetaShardingGroup metaShardingGroup, Parameters parameters, IDBManager dbm) {
        this.mainSharingTableName = mainSharingTableName;
        this.metaShardingGroup = metaShardingGroup;
        this.parameters = parameters;
        this.dbm = dbm;
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public String getGroupFieldKey(String tableName, String columnName) {
        MetaShardingTable metaShardingTable = this.metaShardingGroup.getShardingTable(tableName);
        if (metaShardingTable == null) {
            tableName = this.mainSharingTableName;
            metaShardingTable = this.metaShardingGroup.getShardingTable(tableName);
        }
        if (metaShardingTable == null) {
            return null;
        }
        int index = metaShardingTable.getShardingColumnIndex(columnName);
        if (index > -1) {
            MetaShardingGroup group = ShardingMetaConfig.getInstance().getGroupByTableName(tableName);
            return group.getGroupFieldKey(index);
        }
        return null;
    }

    @Override
    public ExpressionList parseSubSelect2List(String sql, List<Object> arguments) throws Throwable {
        ArrayList<AbstractSqlElement> newExpressions = new ArrayList<AbstractSqlElement>();
        DataTable table = this.dbm.execPrepareQuery(sql, arguments);
        table.beforeFirst();
        while (table.next()) {
            newExpressions.add(new LongValue(TypeConvertor.toString((Object)table.getLong(0))));
        }
        if (newExpressions.isEmpty()) {
            newExpressions.add(new NullValue());
        }
        return new ExpressionList(newExpressions);
    }
}

