/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route.dsn;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.mysqls.route.dsn.DSNRouteTable;
import com.bokesoft.yes.mid.mysqls.route.dsn.DSNRouteTableManager;
import java.util.LinkedHashSet;

public class ShardingDSNPool {
    private static final ShardingDSNPool instance = new ShardingDSNPool();
    private String mainDSN;
    private HashMapIgnoreCase<String[]> mapGroupDSNs = new HashMapIgnoreCase();

    private ShardingDSNPool() {
    }

    public void initMainDSN(String mainDSN) {
        this.mainDSN = mainDSN;
    }

    public String[] getGroupAllDSNs(String groupKey) throws Throwable {
        if (this.mapGroupDSNs.containsKey(groupKey)) {
            return (String[])this.mapGroupDSNs.get(groupKey);
        }
        LinkedHashSet<String> dsnSet = new LinkedHashSet<String>();
        dsnSet.add(this.getMainDSN());
        DSNRouteTable dsnRouteTable = DSNRouteTableManager.getInstance().getRouteTable(groupKey);
        if (dsnRouteTable == null) {
            throw new Throwable("\u672a\u627e\u5230\u8def\u7531\u8868\uff1a" + groupKey);
        }
        dsnRouteTable.beforeFirst();
        while (dsnRouteTable.next()) {
            dsnSet.add(dsnRouteTable.getString("DSN"));
        }
        String[] result = dsnSet.toArray(new String[0]);
        this.mapGroupDSNs.put(groupKey, (Object)result);
        return result;
    }

    public void reset() {
        this.mapGroupDSNs.clear();
    }

    public String getMainDSN() {
        return this.mainDSN;
    }

    public static ShardingDSNPool getInstance() {
        return instance;
    }
}

