/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.route;

import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.connection.MdbDSNGroupValues;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.mysqls.group.DictGroupField;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.RelationTable;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.route.dsn.DSNRouteTable;
import com.bokesoft.yes.mid.mysqls.route.dsn.DSNRouteTableManager;
import com.bokesoft.yes.mid.mysqls.route.dsn.ShardingDSNPool;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingGroup;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingGroupField;
import com.bokesoft.yes.mid.mysqls.route.meta.MetaShardingTable;
import com.bokesoft.yes.mid.mysqls.route.meta.ShardingMetaConfig;
import com.bokesoft.yes.mid.mysqls.route.service.convert.finals.map.GroupValueMapManager;
import com.bokesoft.yes.mid.mysqls.route.util.ShardingUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ShardingRouteServer {
    private static final ShardingRouteServer instance = new ShardingRouteServer();

    private ShardingRouteServer() {
    }

    public static ShardingRouteServer getInstance() {
        return instance;
    }

    public void init(IMetaFactory metaFactory, IDBManager dbManager) throws Throwable {
        if (!ShardingUtil.isShardingDB()) {
            return;
        }
        if (GroupConfig.instance == null) {
            throw new Throwable("GroupConfig.instance \u672a\u521d\u59cb\u5316");
        }
        ShardingRouteServer.initShardingConfig();
        ShardingRouteServer.prepareShardingDSNPool();
        ShardingRouteServer.initDSNRouteTable();
        GroupValueMapManager.getInstance().init(ShardingMetaConfig.getInstance().getGroupFieldRelations(), dbManager);
    }

    public void clearAll() {
        ShardingMetaConfig.getInstance().clearAll();
        DSNRouteTableManager.getInstance().unregisterAll();
    }

    private static void initShardingConfig() throws Throwable {
        GroupConfig groupConfig = GroupConfig.instance;
        if (groupConfig == null || groupConfig.getGroups() == null) {
            throw new Throwable("GroupConfig.instance \u5f02\u5e38, \u8bf7\u68c0\u67e5 GroupConfig.xml\u6587\u4ef6\uff01");
        }
        ShardingMetaConfig shardingConfig = ShardingMetaConfig.getInstance();
        for (Group group : groupConfig.getGroups()) {
            if (group.getGroupFields() == null && group.getDefTableNams().isEmpty()) continue;
            for (GroupField groupField : group.getGroupFields()) {
                MetaShardingGroupField shardingGroupField = new MetaShardingGroupField(groupField.getKey(), groupField.getGroupType());
                shardingGroupField.setItemKey(ShardingRouteServer.getItemKey(groupField));
                shardingConfig.addGroupField(shardingGroupField);
            }
            for (RelationTable relationTable : group.getRelationTables()) {
                String key = relationTable.getKey();
                String[] fieldKeys = StringUtil.split((String)key, (String)"_");
                ShardingRouteServer.checkRelationFieldKeys(key, fieldKeys);
                MetaShardingGroupField groupField = shardingConfig.getGroupField(fieldKeys[0]);
                shardingConfig.addGroupFieldMapRelation(fieldKeys[0], groupField.getGroupType(), fieldKeys[1], relationTable.getSql());
                groupField.setFinalFieldKey(fieldKeys[1]);
                groupField.setRelation(relationTable.getSql());
                shardingConfig.addFinalGroupFieldKey(groupField.getFinalFieldKey());
            }
            MetaShardingGroup metaShardingGroup = ShardingRouteServer.buildMetaShardingGroup(group);
            shardingConfig.addGroupConfig(metaShardingGroup);
        }
    }

    private static void initDSNRouteTable() throws Throwable {
        ShardingMetaConfig shardingConfig = ShardingMetaConfig.getInstance();
        for (MetaShardingGroup groupConfig : shardingConfig.getGroupConfigs()) {
            DSNRouteTable dsnRouteTable = ShardingRouteServer.newRouteTable(groupConfig);
            DSNRouteTableManager.getInstance().register(dsnRouteTable);
        }
        ShardingRouteServer.loadDSNRouteTableData();
    }

    private static void loadDSNRouteTableData() throws Throwable {
        MdbDSNItems dsnItems = MdbDSNItems.instance;
        for (MultiDBDSNItem dsnItem : dsnItems) {
            for (MdbDSNGroupValues groupValues : dsnItem.getGroupValuesList()) {
                String groupKey = groupValues.getGroupkey();
                DSNRouteTable dsnRouteTable = DSNRouteTableManager.getInstance().getRouteTable(groupKey);
                dsnRouteTable.addRow(dsnItem.getName(), groupValues.getGroupValues());
            }
        }
    }

    private static void prepareShardingDSNPool() throws Throwable {
        ShardingDSNPool.getInstance().initMainDSN(MdbDSNItems.instance.getDefaultDSN().getName());
    }

    private static MetaShardingGroup buildMetaShardingGroup(Group group) throws Throwable {
        MetaShardingGroup metaShardingGroup = new MetaShardingGroup(group.getKey());
        for (GroupField groupField : group.getGroupFields()) {
            metaShardingGroup.addGroupField(groupField.getKey());
        }
        for (Map.Entry entry : group.getDefTableNams().entrySet()) {
            String[] columns = ((GroupTable)entry.getValue()).getGroupColumnNames();
            MetaShardingTable metaShardingTable = MetaShardingTable.of((String)entry.getKey(), columns.length);
            int i = 0;
            int size = columns.length;
            while (i < size) {
                ShardingRouteServer.checkTableColumn(metaShardingTable.getTableName(), columns[i]);
                metaShardingTable.setShardingColumn(i, columns[i]);
                ++i;
            }
            metaShardingGroup.addGroupTable(metaShardingTable);
        }
        return metaShardingGroup;
    }

    private static void checkTableColumn(String tableName, String columnName) throws Throwable {
        if (StringUtil.isBlankOrNull((String)columnName)) {
            return;
        }
        LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(tableName);
        if (columns != null) {
            columns.containsKey(columnName);
        }
    }

    private static DSNRouteTable newRouteTable(MetaShardingGroup groupConfig) throws Throwable {
        ShardingMetaConfig shardingConfig = ShardingMetaConfig.getInstance();
        Collection<String> groupFieldKeys = groupConfig.getGroupFieldKeys();
        ArrayList<ColumnInfo> finalColumns = new ArrayList<ColumnInfo>();
        for (String groupFieldKey : groupFieldKeys) {
            if (!shardingConfig.isFinalGroupColumn(groupFieldKey)) continue;
            MetaShardingGroupField groupField = shardingConfig.getGroupField(groupFieldKey);
            ColumnInfo columnInfo = new ColumnInfo(groupFieldKey, groupField.getDataType());
            finalColumns.add(columnInfo);
        }
        if (finalColumns.isEmpty()) {
            throw new Throwable("\u672a\u5b9a\u4e49\u5217\u4fe1\u606f");
        }
        return new DSNRouteTable(groupConfig.getKey(), finalColumns);
    }

    private static void checkRelationFieldKeys(String key, String[] fieldKeys) {
        if (fieldKeys == null || fieldKeys.length != 2) {
            throw new IllegalArgumentException("RelationTable\u8282\u70b9\u7684Name\u5c5e\u6027\u5b9a\u4e49\u683c\u5f0f\u9519\u8bef\uff1a" + key);
        }
        if (fieldKeys[0].equalsIgnoreCase(fieldKeys[1])) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u5bf9\u76f8\u540c\u7684\u5b57\u6bb5\u8fdb\u884c\u5173\u8054\uff1a" + key);
        }
    }

    private static String getItemKey(GroupField groupField) {
        if (groupField instanceof DictGroupField) {
            return ((DictGroupField)groupField).getItemKey();
        }
        return null;
    }
}

