/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.mid.mysqls.result.process.util.ResultProcessUtils;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.TypesStr;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.MidCoreException;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;

public class SimpleDocumentDBUtil {
    public static DataTable populate(ResultSet rs) throws SQLException {
        try {
            return SimpleDocumentDBUtil.impl_populate(rs);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static DataTable populateAllowNull(ResultSet rs) throws SQLException {
        try {
            return SimpleDocumentDBUtil.impl_populateAllowNull(rs);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static DataTable populate(ResultSetMetaData metaData) throws SQLException {
        return SimpleDocumentDBUtil.impl_populate(metaData);
    }

    private static DataTable impl_populate(ResultSetMetaData metaData) throws SQLException {
        DataTable table = new DataTable();
        ArrayList<Integer> sqlTypeList = new ArrayList<Integer>();
        ArrayList<Integer> dataTypeList = new ArrayList<Integer>();
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            int SQLType2 = metaData.getColumnType(i);
            String columnName = metaData.getColumnLabel(i);
            if (StringUtil.isBlankOrNull((String)columnName)) {
                columnName = ResultProcessUtils.genAutoColumnName(i);
            }
            int dataType = SimpleDocumentDBUtil.convertDataType(SQLType2);
            sqlTypeList.add(SQLType2);
            dataTypeList.add(dataType);
            ColumnInfo c = new ColumnInfo(columnName, dataType);
            table.addColumn(c);
            ++i;
        }
        return table;
    }

    private static DataTable impl_populate(ResultSet rs) throws Throwable {
        ResultSetMetaData metaData = rs.getMetaData();
        DataTable table = SimpleDocumentDBUtil.impl_populate(metaData);
        rs.beforeFirst();
        if (rs.next()) {
            do {
                table.append();
                int i = 1;
                while (i <= metaData.getColumnCount()) {
                    int SQLType2 = metaData.getColumnType(i);
                    int dataType = table.getMetaData().getColumnInfo(i - 1).getDataType();
                    Object value = rs.getObject(i);
                    table.setObject(i - 1, SimpleDocumentDBUtil.convert(value, dataType, SQLType2, i));
                    ++i;
                }
            } while (rs.next());
            rs.close();
        } else {
            rs.close();
        }
        table.batchUpdate();
        return table;
    }

    private static DataTable impl_populateAllowNull(ResultSet rs) throws Throwable {
        ResultSetMetaData metaData = rs.getMetaData();
        DataTable table = SimpleDocumentDBUtil.impl_populate(metaData);
        rs.beforeFirst();
        if (rs.next()) {
            do {
                table.append();
                int i = 1;
                while (i <= metaData.getColumnCount()) {
                    int SQLType2 = metaData.getColumnType(i);
                    int dataType = table.getMetaData().getColumnInfo(i - 1).getDataType();
                    Object value = rs.getObject(i);
                    if (value != null) {
                        table.setObject(i - 1, SimpleDocumentDBUtil.convert(value, dataType, SQLType2, i));
                    }
                    ++i;
                }
            } while (rs.next());
            rs.close();
        } else {
            rs.close();
        }
        table.batchUpdate();
        return table;
    }

    private static Object convert(Object value, int dataType, int JDBCDataType, int columnIndex) throws Throwable {
        if (value != null) {
            switch (dataType) {
                case 1008: {
                    switch (JDBCDataType) {
                        case -4: 
                        case -3: 
                        case -2: {
                            return (byte[])value;
                        }
                        case 2004: {
                            Blob blob = (Blob)value;
                            return blob.getBytes(1L, (int)blob.length());
                        }
                        case 2005: 
                        case 2011: {
                            Clob clob = (Clob)value;
                            return clob.getSubString(1L, (int)clob.length()).getBytes();
                        }
                    }
                    throw new MidCoreException(8, "\u7b2c" + columnIndex + "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1009: {
                    switch (JDBCDataType) {
                        case 4: {
                            if ((Integer)value == 1) {
                                return true;
                            }
                            return false;
                        }
                        case 2: {
                            if (((BigDecimal)value).intValue() == 1) {
                                return true;
                            }
                            return false;
                        }
                    }
                    throw new MidCoreException(8, "\u7b2c" + columnIndex + "\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1003: 
                case 1004: 
                case 1101: {
                    switch (JDBCDataType) {
                        case 91: {
                            return TypeConvertor.toDate((Object)value);
                        }
                        case 92: 
                        case 2013: {
                            return new Date(((Time)value).getTime());
                        }
                        case 93: 
                        case 2014: {
                            if (value instanceof java.util.Date) {
                                return value;
                            }
                            if (value instanceof String) {
                                return TypeConvertor.toDate((Object)value);
                            }
                            return new Date(((Timestamp)value).getTime());
                        }
                    }
                    throw new MidCoreException(8, "\u7b2c" + columnIndex + "\u7684\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1005: 
                case 1006: 
                case 1007: {
                    switch (JDBCDataType) {
                        case 2: 
                        case 3: {
                            return TypeConvertor.toBigDecimal((Object)value);
                        }
                        case 8: {
                            return new BigDecimal((Double)value);
                        }
                        case 6: {
                            return new BigDecimal(((Float)value).floatValue());
                        }
                        case 4: {
                            return new BigDecimal((Integer)value);
                        }
                        case -5: {
                            return new BigDecimal((Long)value);
                        }
                    }
                    throw new MidCoreException(8, "\u7b2c" + columnIndex + "\u7684\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1001: {
                    switch (JDBCDataType) {
                        case 4: {
                            if (value instanceof Long) {
                                return ((Long)value).intValue();
                            }
                            if (value instanceof Integer) {
                                return (Integer)value;
                            }
                        }
                        case -5: {
                            return ((Long)value).intValue();
                        }
                        case 2: 
                        case 3: {
                            return ((BigDecimal)value).intValue();
                        }
                    }
                    throw new MidCoreException(8, "\u7b2c" + columnIndex + "\u7684\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1010: {
                    switch (JDBCDataType) {
                        case 4: {
                            return ((Integer)value).longValue();
                        }
                        case -5: {
                            if (value instanceof BigInteger) {
                                return ((BigInteger)value).longValue();
                            }
                            if (value instanceof Integer) {
                                return ((Integer)value).longValue();
                            }
                            return (Long)value;
                        }
                        case 2: 
                        case 3: {
                            return ((BigDecimal)value).longValue();
                        }
                        case -9: 
                        case 12: {
                            return Long.parseLong((String)value);
                        }
                    }
                    throw new MidCoreException(8, "\u7b2c" + columnIndex + "\u7684\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
                case 1002: 
                case 1012: {
                    if ("  ".equals(value)) {
                        return "";
                    }
                    return value.toString();
                }
                case 1011: {
                    switch (JDBCDataType) {
                        case 2005: 
                        case 2011: {
                            if (value instanceof String) {
                                return value;
                            }
                            Clob clob = (Clob)value;
                            return SimpleDocumentDBUtil.ClobtoString(clob);
                        }
                        case 2004: {
                            Blob blob = (Blob)value;
                            return new String(blob.getBytes(1L, (int)blob.length()));
                        }
                        case -9: 
                        case -1: 
                        case 12: {
                            if ("  ".equals(value)) {
                                return "";
                            }
                            return (String)value;
                        }
                        case -4: {
                            return new String((byte[])value, "UTF-8");
                        }
                    }
                    throw new MidCoreException(8, "\u7b2c" + columnIndex + "\u7684\u503c " + value + " \u4e0d\u80fd\u4ece " + TypesStr.toString((int)JDBCDataType) + " \u8f6c\u5316\u4e3a " + DataType.toString((Integer)dataType));
                }
            }
            throw new MidCoreException(7, " \u4e0d\u652f\u6301\u7684JDBC\u6570\u636e\u7c7b\u578b");
        }
        return null;
    }

    private static String ClobtoString(Clob clob) throws Throwable {
        if (clob == null) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (Reader inStreamDoc = clob.getCharacterStream();){
                char[] resDoc = new char[(int)clob.length()];
                inStreamDoc.read(resDoc);
                return new String(resDoc);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LogSvr.getInstance().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static int convertDataType(int jdbcDataType) {
        switch (jdbcDataType) {
            case -5: {
                return 1010;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                return 1008;
            }
            case 0: 
            case 2005: 
            case 2011: {
                return 1011;
            }
            case -15: 
            case 1: 
            case 12: {
                return 1012;
            }
            case -16: 
            case -9: 
            case -1: {
                return 1002;
            }
            case 91: {
                return 1003;
            }
            case 92: 
            case 93: 
            case 2013: 
            case 2014: {
                return 1004;
            }
            case 2: 
            case 3: {
                return 1005;
            }
            case 8: {
                return 1006;
            }
            case 6: {
                return 1007;
            }
            case -6: 
            case 4: 
            case 5: {
                return 1001;
            }
        }
        return -1;
    }

    public static int convertJDBCDataType(int dataType) {
        switch (dataType) {
            case 1010: {
                return -5;
            }
            case 1008: {
                return -2;
            }
            case 1011: {
                return 2005;
            }
            case 1012: {
                return 12;
            }
            case 1002: {
                return -9;
            }
            case 1003: {
                return 91;
            }
            case 1004: {
                return 92;
            }
            case 1005: {
                return 3;
            }
            case 1006: {
                return 8;
            }
            case 1007: {
                return 6;
            }
            case 1001: {
                return 4;
            }
        }
        return -1;
    }
}

