/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.resultset;

import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetGetObjectByPos;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.sql.SQLException;
import java.util.List;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.AllTableColumns;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;
import net.boke.jsqlparser.statement.select.SelectItem;

public class RemoveRepeatOIDProcess {
    public static boolean process(List<ResultSetGetObjectByPos> rsList, SelectSqlInfo select) throws SQLException {
        if (rsList.size() <= 1) {
            return false;
        }
        DataTableResultSet result = DataTableResultSet.wrap(rsList.get(0));
        DataTable dataTable0 = result.getDataTable();
        List selectItems = ParsedSqlUtil.getPlainSelect(select.getSelect().getSelectBody()).getSelectItems();
        if (RemoveRepeatOIDProcess.isOnlyCountExp(selectItems)) {
            return false;
        }
        int oidIndex = 0;
        int selectItemSize = selectItems.size();
        while (oidIndex < selectItemSize) {
            SelectItem selectItem = (SelectItem)selectItems.get(oidIndex);
            if (selectItem instanceof SelectExpressionItem && ((SelectExpressionItem)selectItem).getExpression() instanceof Column && "OID".equalsIgnoreCase(((Column)((SelectExpressionItem)selectItem).getExpression()).getColumnName())) break;
            if (selectItem instanceof AllColumns || selectItem instanceof AllTableColumns) {
                if ("OID".equalsIgnoreCase(dataTable0.getMetaData().getColumnInfo(oidIndex).getColumnKey())) break;
                throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u53bb\u9664OID\u7684\u91cd\u590d\u503c\uff0c\u8981\u6c42\u6709OID\u5b57\u6bb5\u7684\u67e5\u8be2\u9879\uff0c\u76ee\u524d\u7684\u4ee3\u7801\u65e0\u6cd5\u5224\u65ad\u3002\n" + select.getSql());
            }
            ++oidIndex;
        }
        if (oidIndex >= selectItemSize) {
            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u53bb\u9664OID\u7684\u91cd\u590d\u503c\uff0c\u8981\u6c42\u6709OID\u5b57\u6bb5\u7684\u67e5\u8be2\u9879\u3002\n" + select.getSql());
        }
        int i = 1;
        int size = rsList.size();
        while (i < size) {
            DataTable dataTableI = DataTableResultSet.wrap(rsList.get(i)).getDataTable();
            int rowIndex = 0;
            int size1 = dataTableI.size();
            while (rowIndex < size1) {
                if (!RemoveRepeatOIDProcess.hasSameDataRow(dataTable0, dataTableI, rowIndex, oidIndex)) {
                    RemoveRepeatOIDProcess.insertRow(dataTable0, dataTableI, rowIndex);
                }
                ++rowIndex;
            }
            ++i;
        }
        rsList.clear();
        rsList.add(result);
        return true;
    }

    private static boolean isOnlyCountExp(List<?> selectItems) {
        SelectExpressionItem item;
        return selectItems.size() == 1 && selectItems.get(0) instanceof SelectExpressionItem && (item = (SelectExpressionItem)selectItems.get(0)).getExpression() != null && "count(*)".equalsIgnoreCase(item.getExpression().toString());
    }

    private static boolean hasSameDataRow(DataTable dataTable, DataTable otherDataTable, int row, int oidIndex) {
        Object value2 = otherDataTable.getObject(row, oidIndex);
        int i = 0;
        while (i < dataTable.size()) {
            boolean isEqual = false;
            Object value1 = dataTable.getObject(i, oidIndex);
            isEqual = value1 == null && value2 == null ? true : (value1 == null && value2 != null ? false : (value1 != null && value2 == null ? false : value1.equals(value2)));
            if (isEqual) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void insertRow(DataTable tgtDataTable, DataTable srcDataTable, int srcRowIndex) {
        Row newRow = DataTableExUtil.appendDataTable(tgtDataTable);
        newRow.setState(0);
        Object[] newDataList = newRow.getDataList();
        Object[] srcDataList = srcDataTable.getRowByIndex(srcRowIndex).getDataList();
        System.arraycopy(srcDataList, 0, newDataList, 0, srcDataList.length);
    }
}

