/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.regular.actions;

import com.bokesoft.yes.mid.mysqls.processselect.regular.AbstractRegularAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.InsertJoinAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.ResetJoinTypeAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.change.ChangedFromItems;
import com.bokesoft.yes.mid.mysqls.processselect.regular.util.SqlRegularUtil;
import com.bokesoft.yes.mid.mysqls.processselect.regular.visitor.ExpressionRemoveInExistVisitor;
import com.bokesoft.yes.mid.mysqls.processselect.regular.visitor.RegularPlainSelectVisitor;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;

public class RemoveInExistAction
extends AbstractRegularAction {
    public RemoveInExistAction(Select select) {
        super(select);
    }

    @Override
    public void doAction() {
        RegularPlainSelectVisitor masterPlainVisitor = new RegularPlainSelectVisitor(elem -> {
            if (elem instanceof PlainSelect) {
                PlainSelect plainSelect = (PlainSelect)elem;
                RemoveInExistAction.process(plainSelect);
            }
            return true;
        });
        this.select.getSelectBody().accept(masterPlainVisitor);
    }

    public static void process(PlainSelect plainSelect) {
        List joins = plainSelect.getJoins();
        int i = 0;
        int joinSize = joins != null ? joins.size() : 0;
        while (i < joinSize) {
            Join join = (Join)joins.get(i);
            Expression onExpression = join.getOnExpression();
            if (onExpression != null) {
                RemoveInExistAction.traversalCondition(onExpression);
            }
            ++i;
        }
        Expression whereExpression1 = plainSelect.getWhere();
        if (whereExpression1 != null) {
            RemoveInExistAction.traversalCondition(whereExpression1);
        }
        RemoveInExistAction.removeInExist(plainSelect);
    }

    private static void traversalCondition(Expression expression) {
        expression.traversal(elem -> {
            if (elem instanceof PlainSelect) {
                PlainSelect basePlainSelect = (PlainSelect)elem;
                RegularPlainSelectVisitor masterPlainVisitor = new RegularPlainSelectVisitor(elem1 -> {
                    if (elem instanceof PlainSelect) {
                        PlainSelect plainSelect = (PlainSelect)elem;
                        RemoveInExistAction.process(plainSelect);
                    }
                    return true;
                });
                basePlainSelect.accept(masterPlainVisitor);
                return false;
            }
            return true;
        });
    }

    private static void removeInExist(PlainSelect plainSelect) {
        ChangedFromItems changedFromItems = new ChangedFromItems();
        ExpressionRemoveInExistVisitor expressionRemoveInExistVisitor = new ExpressionRemoveInExistVisitor(changedFromItems);
        expressionRemoveInExistVisitor.setPlainSelect(plainSelect);
        List joins = plainSelect.getJoins();
        int i = 0;
        int joinSize = joins != null ? joins.size() : 0;
        while (i < joinSize) {
            Join join = (Join)joins.get(i);
            Expression onExpression = join.getOnExpression();
            if (onExpression != null) {
                Join oldNextJoin = expressionRemoveInExistVisitor.setNextJoin(i < joinSize - 1 ? (Join)joins.get(i + 1) : null);
                onExpression.accept(expressionRemoveInExistVisitor);
                join.setOnExpression(expressionRemoveInExistVisitor.getExpression());
                expressionRemoveInExistVisitor.restorePreFromItem(oldNextJoin);
            }
            ++i;
        }
        Expression whereExpression = plainSelect.getWhere();
        if (whereExpression != null) {
            whereExpression.accept(expressionRemoveInExistVisitor);
            plainSelect.setWhere(expressionRemoveInExistVisitor.getExpression());
        }
        SqlRegularUtil.doChangeFormItem(plainSelect, changedFromItems);
        ResetJoinTypeAction.process(plainSelect);
        InsertJoinAction.process(plainSelect);
    }

    @Override
    public String getName() {
        return "RemoveInExist";
    }
}

