/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect.regular.actions;

import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.regular.AbstractRegularAction;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class AddColumnTableNameAction
extends AbstractRegularAction {
    public AddColumnTableNameAction(Select select) {
        super(select);
    }

    @Override
    public void doAction() {
        this.select.traversal(elem -> {
            if (elem instanceof Column) {
                this.process((Column)elem);
            }
            return true;
        });
    }

    private void process(Column tableColumn) {
        Table table = tableColumn.getTable();
        if (table == null || table.getName() == null) {
            SelectExpressionItem selectItem = tableColumn.getExtendSelectItemInGroupByOrderByHaving();
            if (selectItem != null) {
                if (selectItem.getExpression() instanceof Column) {
                    Column columnInSelectItem = (Column)selectItem.getExpression();
                    tableColumn.setColumnName(columnInSelectItem.getColumnName());
                    tableColumn.setTable(columnInSelectItem.getTable());
                }
            } else {
                assert (tableColumn.getExtendFromItem() != null);
                tableColumn.setTable(new Table(null, ParsedSqlUtil.getFromItemShortName(tableColumn.getExtendFromItem())));
            }
        }
    }

    @Override
    public String getName() {
        return "AddColumnTableName";
    }
}

