/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.processselect;

import com.bokesoft.yes.mid.mysqls.debug.DebugService;
import com.bokesoft.yes.mid.mysqls.debug.EResultTextType;
import com.bokesoft.yes.mid.mysqls.processselect.AssignColumnToFromItem;
import com.bokesoft.yes.mid.mysqls.processselect.regular.IDebugOutput;
import com.bokesoft.yes.mid.mysqls.processselect.regular.IRegularAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.AddColumnTableNameAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.FlatSubSelectAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.InsertJoinAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.MarkPlainSelectNoSplitAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.ProcessSelectItemsSubSelectAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.RemoveInExistAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.RemoveSumInSumAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.RenameRepeatAliasAction;
import com.bokesoft.yes.mid.mysqls.processselect.regular.actions.ResetJoinTypeAction;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.statement.select.Select;

public class RegularSelectSQL {
    public static final RegularSelectSQL instance = new RegularSelectSQL();

    private RegularSelectSQL() {
    }

    public Select regularSelectSQL(Select select) throws SQLException {
        AssignColumnToFromItem.assign(select);
        List<IRegularAction> regularActions = this.createRegularActions(select);
        for (IRegularAction action : regularActions) {
            action.doAction();
            DebugService.getInstance().recordInfoIfNeed(action.getName(), select.toString(), EResultTextType.sql, new Object[0]);
        }
        return select;
    }

    public String getDebugInfo(Select select) {
        StringBuilder sb = new StringBuilder();
        instance.debugRegular(select, info -> sb.append(info).append("\n"));
        return sb.toString();
    }

    public void debugRegular(Select select, IDebugOutput out) {
        AssignColumnToFromItem.assign(select);
        List<IRegularAction> regularActions = this.createRegularActions(select);
        for (IRegularAction action : regularActions) {
            action.doAction();
            out.print("\u3010" + action.getName() + "\u3011: \n" + select.toString());
        }
    }

    private List<IRegularAction> createRegularActions(Select select) {
        ArrayList<IRegularAction> regularActions = new ArrayList<IRegularAction>();
        regularActions.add(new RenameRepeatAliasAction(select));
        regularActions.add(new MarkPlainSelectNoSplitAction(select));
        regularActions.add(new ProcessSelectItemsSubSelectAction(select));
        regularActions.add(new AddColumnTableNameAction(select));
        regularActions.add(new ResetJoinTypeAction(select));
        regularActions.add(new FlatSubSelectAction(select));
        regularActions.add(new InsertJoinAction(select));
        regularActions.add(new RemoveInExistAction(select));
        regularActions.add(new RemoveSumInSumAction(select));
        return regularActions;
    }
}

