/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.oidpool;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.oidpool.UnreliableOIDPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class OIDPool {
    MultiDBManager dbManager;
    private Map<Long, DSNTableName> loadedElements;
    private Map<Long, DSNTableName> newOrChangeElements;
    private UnreliableOIDPool unreliableOIDPool = UnreliableOIDPool.instance;

    public OIDPool(MultiDBManager dbManager) {
        this.dbManager = dbManager;
    }

    public DSNTableName getOneDSNTableName(Long oid) throws Throwable {
        if (oid.equals(0L) || oid.equals(-1L)) {
            return this.getDefaultDSN();
        }
        if (this.newOrChangeElements != null && this.newOrChangeElements.containsKey(oid)) {
            return this.newOrChangeElements.get(oid);
        }
        if (this.loadedElements != null && this.loadedElements.containsKey(oid)) {
            return this.loadedElements.get(oid);
        }
        DSNTableName newResult = this.unreliableOIDPool.getDSNTableName(oid);
        if (newResult != null) {
            if (this.loadedElements == null) {
                this.loadedElements = new HashMap<Long, DSNTableName>();
            }
            this.loadedElements.put(oid, newResult);
        }
        return newResult;
    }

    public DSNTableName getDSNTableName(Long oid, TableGroupProp tableGroupPropForDBCheck) throws Throwable {
        DSNTableName result = this.getOneDSNTableName(oid);
        if (result == null) {
            TableGroupType tableGroupType = tableGroupPropForDBCheck.getFixedType();
            if (Performance.RUN_IN_DEBUG) {
                if (tableGroupType != TableGroupType.HeadTableInGroupByHeadTable && tableGroupType != TableGroupType.HeadTableInGroupByDetailTable && tableGroupType != TableGroupType.DetailTableInGroupByDetailTable && tableGroupType != TableGroupType.DetailTableExtra) {
                    throw new RuntimeException("\u8c03\u7528\u9519\u8bef" + tableGroupPropForDBCheck.getTableName());
                }
                if (tableGroupType == TableGroupType.DetailTableInGroupByDetailTable && tableGroupPropForDBCheck.getHeadTableName() != null) {
                    throw new RuntimeException("\u660e\u7ec6\u5206\u7ec4\u8868\u8c03\u7528\u9519\u8bef" + tableGroupPropForDBCheck.getTableName());
                }
            }
            boolean isMayMulti = tableGroupType == TableGroupType.HeadTableInGroupByDetailTable;
            result = new DSNTableName();
            Group group = tableGroupPropForDBCheck.getGroup();
            if (isMayMulti) {
                group = tableGroupPropForDBCheck.getGroupDetailTable().getGroup();
            }
            String tableName = tableGroupPropForDBCheck.getTableName();
            if (!this.dbManager.getCacheDBRequest().isNewInsertSOID(tableName, oid)) {
                boolean isHeadTable = tableGroupType != TableGroupType.DetailTableInGroupByDetailTable && tableGroupType != TableGroupType.DetailTableExtra;
                String[] stringArray = group.getAllDSNNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String dsnName = stringArray[n2];
                    if (this.checkOIDDSName(oid, dsnName, tableName, isHeadTable)) {
                        result.addDSNName(dsnName);
                        if (!isMayMulti) break;
                    }
                    ++n2;
                }
            }
            if (!result.isDsnNameEmpty()) {
                if (this.newOrChangeElements == null) {
                    this.newOrChangeElements = new HashMap<Long, DSNTableName>();
                }
                this.newOrChangeElements.put(oid, result);
                this.unreliableOIDPool.setOIDDSNName(oid, result);
            }
        }
        return result;
    }

    private boolean checkOIDDSName(Long oid, String dsnName, String tableName, boolean isHeadTable) throws SQLException {
        if (!this.dbManager.getDBStruct().existTableOrViewName(dsnName, tableName)) {
            return false;
        }
        Connection connection = this.dbManager.getConnectionByDSNName(dsnName);
        String sql = isHeadTable ? new StringBuilder(128).append("SELECT oid FROM ").append(tableName).append(" WHERE OID = ?").toString() : new StringBuilder(128).append("SELECT soid FROM ").append(tableName).append(" WHERE SOID = ?").toString();
        try (PreparedStatement preparedStatement = null;){
            boolean result;
            preparedStatement = connection.prepareStatement(sql, 1004, 1007);
            preparedStatement.setLong(1, oid);
            Object[] actions = new Object[]{dsnName, ": ", sql, ";#0:", oid};
            int action = Performance.startAction((Object[])actions);
            ResultSet rs = preparedStatement.executeQuery();
            Performance.endActive((int)action, (Object[])actions);
            boolean bl = result = rs.first();
            return bl;
        }
    }

    private DSNTableName getDefaultDSN() {
        String defaultDsnName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
        DSNTableName dsnTableName = new DSNTableName(defaultDsnName);
        return dsnTableName;
    }

    public void setOIDDSNName(Long oid, DSNTableName dsnTableName) {
        if (this.newOrChangeElements == null) {
            this.newOrChangeElements = new HashMap<Long, DSNTableName>();
        }
        this.newOrChangeElements.put(oid, dsnTableName);
    }

    public void setOIDDSNName(Long oid, String dsnName, String tableNamePostFix) {
        this.setOIDDSNName(oid, new DSNTableName(dsnName, tableNamePostFix));
    }

    public void setOIDDSNName(Long oid, String dsnName, String tableNamePostFix, String newDSNName) {
        DSNTableName dsnTableName = new DSNTableName(dsnName, tableNamePostFix);
        dsnTableName.setNewDSNName(newDSNName);
        this.setOIDDSNName(oid, dsnTableName);
    }

    public void commit() throws Throwable {
        if (this.newOrChangeElements != null) {
            for (Map.Entry<Long, DSNTableName> entry : this.newOrChangeElements.entrySet()) {
                Long oid = entry.getKey();
                DSNTableName dsnTableName = entry.getValue();
                this.unreliableOIDPool.setOIDDSNName(oid, dsnTableName);
            }
            this.newOrChangeElements = null;
        }
        this.loadedElements = null;
    }

    public void rollback() {
        if (this.newOrChangeElements != null) {
            this.newOrChangeElements.clear();
            this.newOrChangeElements = null;
        }
        this.loadedElements = null;
    }
}

