/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.log;

import com.bokesoft.erp.sql.check.CheckSplitSql;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yes.mid.server.weight.WeightServiceCenter;
import com.bokesoft.yes.mid.server.weight.card.SqlTimeCard;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShardingWarnLogger {
    private static Logger logger = LoggerFactory.getLogger(ShardingWarnLogger.class);

    public static void warnAllDSN(String title, String groupKey, String[] dsnNames, Parameters parameters, SqlInfo sqlInfo) {
        if (!CheckSplitSql.isShardingWarnEnable()) {
            return;
        }
        SqlTimeCard card = WeightServiceCenter.getInstance().getCurSqlTimeCard();
        String text = ShardingWarnLogger.buildMultiString("##################################  " + title + "  #####################################", "\u3010\u7ebf\u7a0b\u3011:" + Thread.currentThread().getName(), "\u3010\u65f6\u95f4\u3011:" + LocalDateTime.now(), "\u3010\u8c03\u7528\u3011:" + (card == null ? "\u672a\u77e5" : card.getTicket()), "\u3010GroupKey\u3011: " + groupKey, "\u3010DSN\u3011: " + String.join((CharSequence)",", dsnNames), "\u3010Table\u3011:" + sqlInfo.getTableName(), "\u3010Parameters\u3011:" + (parameters == null ? "" : parameters.toString()), "\u3010SQL\u3011: " + sqlInfo.toString());
        logger.warn(text);
        ShardingWarnLogger.logStackTrack();
    }

    private static String buildMultiString(String ... strings) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            sb.append("\r\n").append(str);
            ++n2;
        }
        return sb.toString();
    }

    private static void logStackTrack() {
        int maxIndex;
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        int minIndex = 12;
        int n = maxIndex = stackTrace.length > 35 ? 35 : stackTrace.length;
        if (stackTrace != null && stackTrace.length > minIndex) {
            int i = minIndex;
            while (i < maxIndex) {
                if (stackTrace[i] != null) {
                    logger.warn(stackTrace[i].toString());
                }
                ++i;
            }
        }
    }
}

