/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group.meta;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.mysqls.group.DataObjectRelationTable;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class TableGroupProps {
    private HashMapIgnoreCase<TableGroupProp> elements = new HashMapIgnoreCase();

    private TableGroupProps() {
        try {
            GroupConfig groupConfig = GroupConfig.instance;
            if (groupConfig != null) {
                this.init(groupConfig);
                this.sortDetailTableInDetailGroup();
                this.processVariableTypes();
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("\u521d\u59cb\u5316\u8868\u5206\u5e93\u5206\u8868\u5c5e\u6027\u51fa\u9519\u3002", e);
        }
    }

    public static TableGroupProps getInstance() {
        return TableGroupPropsHolder.instance;
    }

    public HashMapIgnoreCase<TableGroupProp> getElements() {
        return this.elements;
    }

    private TableGroupProp getTableGroupPropEnsure(String tableName) {
        TableGroupProp tableGroupProp = (TableGroupProp)this.elements.get(tableName);
        if (tableGroupProp == null) {
            tableGroupProp = new TableGroupProp(tableName);
            this.elements.put(tableName, (Object)tableGroupProp);
        }
        return tableGroupProp;
    }

    public TableGroupProp getTableGroupProp(String tableName) {
        return (TableGroupProp)this.elements.get(tableName);
    }

    public Group getGroupForMigration(String tableName) {
        Group result = null;
        TableGroupProp tableGroupProp = (TableGroupProp)this.elements.get(tableName);
        if (tableGroupProp != null) {
            result = tableGroupProp.getGroup();
            if (result == null) {
                throw new RuntimeException("\u5206\u5e93\u8bbe\u7f6e\u9519\u8bef\uff0c\u8fc1\u79fb\u8868" + tableName + "\u6ca1\u6709\u76f4\u63a5\u6307\u5b9a\u5206\u5e93\u89c4\u5219\u3002");
            }
        } else {
            result = GroupConfig.instance.getGroups().getDefaultGroup();
        }
        return result;
    }

    public Group getFixedGroup(String tableName) {
        Group result = null;
        TableGroupProp tableGroupProp = (TableGroupProp)this.elements.get(tableName);
        if (tableGroupProp != null) {
            result = tableGroupProp.getGroup();
            if (result == null) {
                TableGroupType type = tableGroupProp.getFixedType();
                if (type == TableGroupType.HeadTableInGroupByDetailTable) {
                    result = tableGroupProp.getGroupDetailTable().getGroup();
                } else if (type == TableGroupType.DetailTableExtra) {
                    String headTableName = tableGroupProp.getHeadTableForDetailTableExtra().headTableName;
                    result = ((TableGroupProp)this.elements.get(headTableName)).getGroup();
                }
            }
        } else {
            result = GroupConfig.instance.getGroups().getDefaultGroup();
        }
        return result;
    }

    private void init(GroupConfig groupConfig) throws Throwable {
        for (Group group : groupConfig.getGroups()) {
            HashMap<String, GroupTable> newGroupTables = null;
            for (Map.Entry<String, GroupTable> entry : group.getDefTableNams().entrySet()) {
                String tableName = entry.getKey();
                GroupTable groupTable = entry.getValue();
                TableGroupProp tableGroupProp = this.getTableGroupPropEnsure(tableName);
                tableGroupProp.setGroup(group);
                List<MetaDataObject> dataObjects = DataObjects.getInstance().getDataObjectsByTableName(tableName);
                if (dataObjects != null) {
                    for (MetaDataObject dataObject : dataObjects) {
                        if (TableGroupProps.isDataObjectValidForInitGroup(dataObject)) {
                            String headTableKey = dataObject.getMainTableKey();
                            if ((headTableKey == null || headTableKey.length() == 0) && dataObject.getTableCollection().size() > 1) {
                                headTableKey = ((MetaTable)dataObject.getTableCollection().get(0)).getKey();
                            }
                            if (headTableKey.equalsIgnoreCase(tableName)) {
                                tableGroupProp.setFixedType(TableGroupType.HeadTableInGroupByHeadTable);
                            } else {
                                tableGroupProp.setFixedType(TableGroupType.DetailTableInGroupByDetailTable);
                                tableGroupProp.setHeadTableName(headTableKey);
                                TableGroupProp tableGroupPropMain = this.getTableGroupPropEnsure(headTableKey);
                                tableGroupPropMain.setFixedType(TableGroupType.HeadTableInGroupByDetailTable);
                                tableGroupPropMain.setGroupDetailTable(tableGroupProp);
                            }
                            MetaTable groupMetaTable = DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, tableName);
                            List<String> sortTableKeys = this.getSortTableKeys(dataObject);
                            int index = 0;
                            while (index < sortTableKeys.size()) {
                                String tableNameOther;
                                MetaTable metaTableOther = (MetaTable)dataObject.getTableCollection().get(sortTableKeys.get(index));
                                if (metaTableOther.isPersist().booleanValue() && !(tableNameOther = metaTableOther.getKey()).equalsIgnoreCase(tableName)) {
                                    TableGroupProp tableGroupPropOther = this.getTableGroupPropEnsure(tableNameOther);
                                    if (tableNameOther.equalsIgnoreCase(headTableKey)) {
                                        String groupTableParent = groupMetaTable.getParentKey();
                                        if (groupTableParent != null && groupTableParent.length() > 0 && !groupTableParent.equals(tableNameOther)) {
                                            throw new RuntimeException("\u5206\u5e93\u8bbe\u7f6e\u9519\u8bef\uff0c\u53ea\u652f\u6301\u4e00\u7ea7\u660e\u7ec6\u8868\u5206\u5e93\uff0c\u4e0d\u652f\u6301\u660e\u7ec6\u8868\u7684\u660e\u7ec6\u8868" + tableName + "\u5206\u7ec4\u3002");
                                        }
                                        tableGroupPropOther.setFixedType(TableGroupType.HeadTableInGroupByDetailTable);
                                        tableGroupPropOther.setGroupDetailTable(tableGroupProp);
                                    } else {
                                        String tableNameParent = metaTableOther.getParentKey();
                                        if (tableNameParent == null || tableNameParent.length() == 0) {
                                            tableNameParent = headTableKey;
                                        }
                                        if (!dataObject.getTable(tableNameParent).isPersist().booleanValue()) {
                                            tableNameParent = headTableKey;
                                        }
                                        TableGroupProp tableGroupPropParent = this.getTableGroupPropEnsure(tableNameParent);
                                        tableGroupPropOther.addParentTable(tableGroupPropParent);
                                        TableGroupType parentType = tableGroupPropParent.getType(headTableKey);
                                        if (parentType == TableGroupType.HeadTableInGroupByHeadTable || parentType == TableGroupType.DetailTableInGroupByHeadTable) {
                                            tableGroupPropOther.setType(headTableKey, TableGroupType.DetailTableInGroupByHeadTable);
                                            tableGroupProp.addDetailTable(new HeadDetailTable(tableName, tableNameOther, "SOID"));
                                        } else if (parentType == TableGroupType.DetailTableInGroupByDetailTable || parentType == TableGroupType.SonDetailTableInGroupByDetailTable) {
                                            tableGroupPropOther.setType(headTableKey, TableGroupType.SonDetailTableInGroupByDetailTable);
                                            tableGroupProp.addDetailTable(new HeadDetailTable(metaTableOther.getParentKey(), tableNameOther, "POID"));
                                        } else if (parentType == TableGroupType.HeadTableInGroupByDetailTable || parentType == TableGroupType.OtherDetailTableInGroupByDetailTable) {
                                            tableGroupPropOther.setType(headTableKey, TableGroupType.OtherDetailTableInGroupByDetailTable);
                                            this.getTableGroupPropEnsure(headTableKey).addDetailTable(new HeadDetailTable(headTableKey, tableNameOther, "SOID"));
                                        } else {
                                            throw new RuntimeException("\u5206\u5e93\u8bbe\u7f6e\u9519\u8bef\uff0c\u6570\u636e\u5bf9\u8c61" + dataObject.getKey() + "\u8868" + tableNameOther + "\u65e0\u6cd5\u786e\u5b9a\u5206\u5e93\u7c7b\u578b\u3002");
                                        }
                                    }
                                }
                                ++index;
                            }
                        }
                        if (dataObject.getSecondaryType() != 6 || dataObject.getMigrationUpdateStrategy() != 5) continue;
                        tableGroupProp.setFixedType(TableGroupType.SimpleTable);
                        String incrTableName = dataObject.getErpMigrationIncrTable().getKey();
                        tableGroupProp = this.getTableGroupPropEnsure(incrTableName);
                        tableGroupProp.setGroup(group);
                        tableGroupProp.setFixedType(TableGroupType.SimpleTable);
                        if (newGroupTables == null) {
                            newGroupTables = new HashMap<String, GroupTable>();
                        }
                        newGroupTables.put(incrTableName, new GroupTable(groupTable.getGroupColumnNames()));
                        String newTableName = dataObject.getErpMigrationNewTable().getKey();
                        tableGroupProp = this.getTableGroupPropEnsure(newTableName);
                        tableGroupProp.setGroup(group);
                        tableGroupProp.setFixedType(TableGroupType.SimpleTable);
                        newGroupTables.put(newTableName, new GroupTable(groupTable.getGroupColumnNames()));
                    }
                    if (tableGroupProp.getFixedType() == null && dataObjects != null) {
                        for (MetaDataObject dataObject : dataObjects) {
                            MetaTable groupMetaTable = DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, tableName);
                            if (tableName.equalsIgnoreCase(dataObject.getMainTableKey())) {
                                tableGroupProp.setFixedType(TableGroupType.HeadTableInGroupByHeadTable);
                                continue;
                            }
                            if (!groupMetaTable.containsKey("OID") || !groupMetaTable.containsKey("SOID")) continue;
                            tableGroupProp.setFixedType(TableGroupType.SimpleTable);
                        }
                    }
                }
                if (!Performance.RUN_IN_DEBUG || tableGroupProp.getFixedType() != null) continue;
                throw new RuntimeException("\u8c03\u7528\u9519\u8bef\uff0c\u8ba1\u7b97\u8868" + tableName + "\u7684\u5206\u7ec4\u7c7b\u578b\u9519\u8bef\u3002");
            }
            if (newGroupTables != null) {
                for (Map.Entry entry : newGroupTables.entrySet()) {
                    group.addTable((String)entry.getKey(), (GroupTable)entry.getValue());
                }
            }
            for (HeadDetailTable headDetailTable : group.getDetailTableExtras()) {
                TableGroupProp tableGroupPropOther = this.getTableGroupPropEnsure(headDetailTable.detailTableName);
                tableGroupPropOther.setGroup(group);
                tableGroupPropOther.setFixedType(TableGroupType.DetailTableExtra);
                tableGroupPropOther.setHeadTableForDetailTableExtra(headDetailTable);
                TableGroupProp shardingGroupTable = this.getTableGroupPropEnsure(headDetailTable.headTableName);
                shardingGroupTable.addDetailTable(headDetailTable);
            }
        }
        DataObjectRelationTable[] dataObjectRelationTableArray = groupConfig.getDataObjectRelationTables();
        int n = dataObjectRelationTableArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjectRelationTable relationTable = dataObjectRelationTableArray[n2];
            String tableName = relationTable.name;
            TableGroupProp tableGroupProp = this.getTableGroupPropEnsure(tableName);
            tableGroupProp.setFixedType(TableGroupType.DataObjectRelationTable);
            ++n2;
        }
    }

    private List<String> getSortTableKeys(final MetaDataObject dataObject) throws Throwable {
        ArrayList<MetaTable> result = new ArrayList<MetaTable>();
        MetaTableCollection tableCollection = dataObject.getTableCollection();
        for (MetaTable table : tableCollection) {
            if (!table.isPersist().booleanValue()) continue;
            result.add(table);
        }
        result.sort(new Comparator<MetaTable>(){

            @Override
            public int compare(MetaTable o1, MetaTable o2) {
                if (dataObject.getMainTable() == o1) {
                    return -1;
                }
                if (dataObject.getMainTable() == o2) {
                    return 1;
                }
                int tmp = Integer.compare(o1.getLevelID(), o2.getLevelID());
                if (tmp == 0) {
                    tmp = o1.getKey().compareTo(o2.getKey());
                }
                return tmp;
            }
        });
        ArrayList<String> tableKeyList = new ArrayList<String>(result.size());
        for (MetaTable metaTable : result) {
            tableKeyList.add(metaTable.getKey());
        }
        return tableKeyList;
    }

    public static boolean isDataObjectValidForInitGroup(MetaDataObject dataObject) {
        MetaTableCollection metaTables = dataObject.getTableCollection();
        if (metaTables == null) {
            return false;
        }
        int presistTableCount = 0;
        for (MetaTable metaTable : metaTables) {
            if (!metaTable.isPersist().booleanValue()) continue;
            ++presistTableCount;
        }
        return presistTableCount > 1;
    }

    private void sortDetailTableInDetailGroup() {
        for (TableGroupProp tableGroupProp : this.elements.values()) {
            int size;
            if (tableGroupProp.getFixedType() != TableGroupType.DetailTableInGroupByDetailTable) continue;
            List<HeadDetailTable> detailTables = tableGroupProp.getDetailTables();
            int n = size = detailTables == null ? 0 : detailTables.size();
            if (size <= 1) continue;
            HashMap<String, Node> tree = new HashMap<String, Node>();
            for (HeadDetailTable detailTable : detailTables) {
                String headTableName = detailTable.headTableName;
                Node node = (Node)tree.get(headTableName);
                if (node == null) {
                    node = new Node();
                    node.headHeadName = headTableName;
                    tree.put(headTableName, node);
                }
                node.details.add(detailTable);
            }
            Node root = (Node)tree.get(tableGroupProp.getTableName());
            ArrayList<HeadDetailTable> sortedResult = new ArrayList<HeadDetailTable>(size);
            this.sortDetailTableInDetailGroup_fromNode(tree, root, sortedResult);
            if (sortedResult.size() != size) {
                throw new RuntimeException("\u5206\u5e93\u8bbe\u7f6e\u9519\u8bef\uff0c\u8868" + tableGroupProp.getTableName() + "\u7684\u5b50\u8868\u7684\u6392\u5e8f\u9519\u8bef\u3002");
            }
            int i = 0;
            while (i < size) {
                detailTables.set(i, (HeadDetailTable)sortedResult.get(i));
                ++i;
            }
        }
    }

    private void sortDetailTableInDetailGroup_fromNode(Map<String, Node> tree, Node node, List<HeadDetailTable> sortedResult) {
        for (HeadDetailTable detailTable : node.details) {
            if (sortedResult.contains(detailTable)) continue;
            sortedResult.add(detailTable);
            String detailTableName = detailTable.detailTableName;
            Node detailNode = tree.get(detailTableName);
            if (detailNode == null) continue;
            this.sortDetailTableInDetailGroup_fromNode(tree, detailNode, sortedResult);
        }
    }

    private void processVariableTypes() throws Throwable {
        for (TableGroupProp tableGroupProp : this.elements.values()) {
            if (tableGroupProp.getFixedType() != null) continue;
            String tableName = tableGroupProp.getTableName();
            List<MetaDataObject> dataObjects = DataObjects.getInstance().getDataObjectsByTableName(tableName);
            if (dataObjects == null) continue;
            for (MetaDataObject dataObject : dataObjects) {
                TableGroupProp tmp;
                String mainTableKey;
                if (dataObject.getTableCollection().size() <= 1 || (mainTableKey = dataObject.getMainTableKey()) == null || mainTableKey.length() == 0 || dataObject.getMainTable() != null && !dataObject.getMainTable().isPersist().booleanValue() || (tmp = (TableGroupProp)this.elements.get(mainTableKey)) != null) continue;
                tableGroupProp.setType(mainTableKey, TableGroupType.NotGroup);
            }
        }
    }

    public String getOneDSNName(String tableName) throws Throwable {
        TableGroupProp tableGroupProp = (TableGroupProp)this.elements.get(tableName);
        if (tableGroupProp == null) {
            String defaultDSNName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
            return defaultDSNName;
        }
        return tableGroupProp.getOneDSNName(tableName);
    }

    public String[] getPreSubmitHeadTableNames(String tableName) {
        if (MdbDSNItems.instance.isEmpty()) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        TableGroupProp tableGroupProp = (TableGroupProp)this.elements.get(tableName);
        if (tableGroupProp != null) {
            return tableGroupProp.getPreSubmitHeadTableNames();
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        for (Map.Entry entry : this.elements.entrySet()) {
            TableGroupProp tableGroup = (TableGroupProp)entry.getValue();
            sb.append(tableGroup).append("\n");
        }
        return sb.toString();
    }

    /* synthetic */ TableGroupProps(TableGroupProps tableGroupProps) {
        this();
    }

    class Node {
        String headHeadName;
        List<HeadDetailTable> details = new ArrayList<HeadDetailTable>();

        Node() {
        }
    }

    private static class TableGroupPropsHolder {
        private static final TableGroupProps instance = new TableGroupProps(null);

        private TableGroupPropsHolder() {
        }
    }
}

