/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.group.FieldInfo;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.ObjectArrayKey;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.sql.SelectSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yes.util.VarUtil;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RelationTable {
    public final String key;
    private String sql;
    private List<FieldInfo> fieldInfos = new ArrayList<FieldInfo>();
    private DataTable dataTable;
    private Map<ObjectArrayKey, OneOrMultiValue<Object>> cache = new HashMap<ObjectArrayKey, OneOrMultiValue<Object>>();

    public RelationTable(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
        SelectSqlInfo sqlInfo = (SelectSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        try {
            int columnCount = sqlInfo.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                String fieldKey;
                String columnNameInResultSet = sqlInfo.getColumnNameInResultSet(i);
                if (columnNameInResultSet.toUpperCase().endsWith("_START")) {
                    fieldKey = columnNameInResultSet.substring(0, columnNameInResultSet.length() - "_START".length());
                    this.getFieldInfo((String)fieldKey).columnStartIndex = i;
                } else if (columnNameInResultSet.toUpperCase().endsWith("_END")) {
                    fieldKey = columnNameInResultSet.substring(0, columnNameInResultSet.length() - "_END".length());
                    this.getFieldInfo((String)fieldKey).columnEndIndex = i;
                } else {
                    this.getFieldInfo((String)columnNameInResultSet).columnIndex = i;
                }
                ++i;
            }
        }
        catch (Throwable e) {
            throw new RuntimeException("\u89e3\u6790\u5173\u7cfb\u8868SQL" + sql + "\u51fa\u9519\u3002", e);
        }
    }

    private FieldInfo getFieldInfo(String columnName) {
        for (FieldInfo fieldInfo : this.fieldInfos) {
            if (!fieldInfo.columnName.equalsIgnoreCase(columnName)) continue;
            return fieldInfo;
        }
        FieldInfo result = new FieldInfo(columnName);
        this.fieldInfos.add(result);
        return result;
    }

    private void ensureLoadDataTable() throws Throwable {
        if (this.dataTable == null) {
            IDBManager dbManager = MultiDBManager.createDBManager(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
            this.dataTable = dbManager.execPrepareQuery(this.sql, new Object[0]);
            dbManager.close();
        }
    }

    public void checkColumnName(Group group) {
        for (FieldInfo fieldInfo : this.fieldInfos) {
            if (group.getGroupField(fieldInfo.columnName) != null) continue;
            throw new RuntimeException("\u89e3\u6790\u5173\u7cfb\u8868SQL " + this.sql + "\u51fa\u9519\uff0c\u5176\u4e2d\u7684\u5b57\u6bb5" + fieldInfo.columnName + "\u5728\u5206\u7ec4\u5b57\u6bb5\u4e2d\u4e0d\u5b58\u5728\u3002");
        }
    }

    public boolean isLastField(String groupFieldKey) {
        return this.fieldInfos.get((int)(this.fieldInfos.size() - 1)).columnName.equals(groupFieldKey);
    }

    public boolean isFirstField(String groupFieldKey) {
        return this.fieldInfos.get((int)0).columnName.equals(groupFieldKey);
    }

    public OneOrMultiValue<Object> getGroupValues(Group group, GroupField groupField, OneGroupValue parentGroupValue, String tableName, SqlInfo sqlInfo, Parameters parameters, boolean isNewValue) throws Throwable {
        if (!this.isLastField(groupField.getKey())) {
            throw new RuntimeException("\u8ba1\u7b97\u5206\u5e93\u5206\u8868\u503c\u51fa\u9519\uff0c\u5173\u7cfb\u8868\u53ea\u652f\u6301\u8ba1\u7b97\u6700\u540e\u4e00\u4e2a\u5b57\u6bb5\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        this.ensureLoadDataTable();
        int compareFieldCount = this.fieldInfos.size();
        Object[] compareValues = new Object[compareFieldCount];
        int j = 0;
        while (j < compareFieldCount - 1) {
            FieldInfo fieldInfo = this.fieldInfos.get(j);
            String columnKey = group.getColumnNameInTable(group.getGroupField(fieldInfo.columnName), tableName);
            if (columnKey != null) {
                if (parentGroupValue.getGroupValue(fieldInfo.columnName) != null) {
                    compareValues[j] = parentGroupValue.getGroupValue(fieldInfo.columnName);
                } else if (sqlInfo != null) {
                    compareValues[j] = isNewValue ? sqlInfo.getGroupNewValue(columnKey, parameters) : sqlInfo.getGroupOriginalValue(group.getGroupField(fieldInfo.columnName), columnKey, parameters);
                }
            }
            if (compareValues[j] == null) {
                return null;
            }
            if (compareValues[j] == GroupField.UndefinedGroupValue) {
                return new OneOrMultiValue<Object>(GroupField.UndefinedGroupValue);
            }
            ++j;
        }
        ObjectArrayKey key = new ObjectArrayKey(compareValues);
        OneOrMultiValue tmp = this.cache.getOrDefault(key, null);
        if (tmp != null) {
            return tmp;
        }
        int iStart = 0;
        int iEnd = compareFieldCount - 1;
        OneOrMultiValue<Object> result = new OneOrMultiValue<Object>();
        int pos = 0;
        int count = this.dataTable.size();
        while (pos < count) {
            boolean isFit = true;
            int j2 = iStart;
            while (j2 < iEnd && isFit) {
                FieldInfo fieldInfo = this.fieldInfos.get(j2);
                if (fieldInfo.columnIndex > -1) {
                    Object value = this.dataTable.getObject(pos, fieldInfo.columnIndex);
                    if (!this.isFit(value, compareValues[j2])) {
                        isFit = false;
                        break;
                    }
                } else {
                    Integer endValue;
                    Integer startValue = this.dataTable.getInt(pos, fieldInfo.columnStartIndex);
                    if (!this.isInRange(startValue, endValue = this.dataTable.getInt(pos, fieldInfo.columnEndIndex), compareValues[j2])) {
                        isFit = false;
                        break;
                    }
                }
                ++j2;
            }
            if (isFit) {
                FieldInfo fieldInfo = this.getFieldInfo(groupField.key);
                Object value = null;
                if (fieldInfo.columnIndex > -1) {
                    value = this.dataTable.getObject(pos, fieldInfo.columnIndex);
                }
                if (!result.hasValue(value)) {
                    result.addValue(value);
                }
            }
            ++pos;
        }
        this.cache.put(key, result);
        return result;
    }

    private boolean isFit(Object valueNoNull, Object value2) {
        if (value2 == null) {
            return false;
        }
        if (value2 instanceof OneOrMultiValue) {
            return ((OneOrMultiValue)value2).hasValue(valueNoNull);
        }
        return VarUtil.compare(valueNoNull, value2) == 0;
    }

    private boolean isInRange(Integer startValue, Integer endValue, Object value3) {
        if (value3 == null) {
            return false;
        }
        if (value3 instanceof Long) {
            int tmp = ((Long)value3).intValue();
            return startValue.compareTo(tmp) <= 0 && endValue.compareTo(tmp) >= 0;
        }
        if (value3 instanceof Integer) {
            return startValue.compareTo((Integer)value3) <= 0 && endValue.compareTo((Integer)value3) >= 0;
        }
        if (value3 instanceof OneOrMultiValue) {
            for (Object tmp : (OneOrMultiValue)value3) {
                Integer tmpInt = (Integer)tmp;
                if (startValue.compareTo(tmpInt) > 0 || endValue.compareTo(tmpInt) < 0) continue;
                return true;
            }
        } else {
            throw new RuntimeException("\u8ba1\u7b97\u5206\u5e93\u5206\u8868\u503c\u51fa\u9519\uff0c\u7c7b\u578b\u51fa\u9519\u3002");
        }
        return false;
    }
}

