/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class OneOrMultiValue<T>
implements Iterable<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    T singleValue;
    List<T> multiValues;

    public OneOrMultiValue(T value) {
        this.singleValue = value;
    }

    public OneOrMultiValue(T[] values) {
        int count = values.length;
        if (count == 1) {
            this.singleValue = values[0];
        } else if (count > 1) {
            this.multiValues = new ArrayList<T>(Arrays.asList(values));
        }
    }

    public OneOrMultiValue(List<T> values) {
        int count = values.size();
        if (count == 1) {
            this.singleValue = values.get(0);
        } else if (count > 1) {
            this.multiValues = new ArrayList<T>(values);
        }
    }

    public OneOrMultiValue() {
    }

    public void addValue(T value) {
        if (this.multiValues != null) {
            if (!this.multiValues.contains(value)) {
                this.multiValues.add(value);
            }
        } else if (this.singleValue == null) {
            this.singleValue = value;
        } else if (!this.singleValue.equals(value)) {
            this.multiValues = new ArrayList<T>();
            this.multiValues.add(this.singleValue);
            this.multiValues.add(value);
            this.singleValue = null;
        }
    }

    public void addAllValue(int[] values) {
        int count = values.length;
        if (count == 1) {
            this.addValue(values[0]);
        } else if (count > 1) {
            if (this.multiValues == null) {
                this.multiValues = new ArrayList<T>(values.length);
            }
            int[] nArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Integer tmp = nArray[n2];
                this.multiValues.add(tmp);
                ++n2;
            }
        }
    }

    public void addAllValue(T[] values) {
        int count = values.length;
        if (count == 1) {
            this.addValue(values[0]);
        } else if (count > 1) {
            if (this.multiValues == null) {
                this.multiValues = new ArrayList<T>(Arrays.asList(values));
            } else {
                this.multiValues.addAll(Arrays.asList(values));
            }
        }
    }

    public void addAllValue(OneOrMultiValue<T> values) {
        for (T value : values) {
            this.addValue(value);
        }
    }

    public boolean removeValue(T value) {
        if (this.multiValues != null) {
            boolean result = this.multiValues.remove(value);
            if (result && this.multiValues.size() == 1) {
                this.singleValue = this.multiValues.get(0);
                this.multiValues = null;
            }
            return result;
        }
        if (this.singleValue != null && this.singleValue.equals(value)) {
            this.singleValue = null;
            return true;
        }
        return false;
    }

    public boolean isSingleValue() {
        return this.multiValues == null;
    }

    public int getValueCount() {
        int result = this.multiValues != null ? this.multiValues.size() : (this.singleValue != null ? 1 : 0);
        return result;
    }

    public T getValue(int index) {
        T result = null;
        if (this.isSingleValue()) {
            if (index == 0) {
                result = this.singleValue;
            }
        } else {
            result = this.multiValues.get(index);
        }
        if (result == null) {
            throw new RuntimeException("\u503c\u672a\u53d6\u5230\u3002");
        }
        return result;
    }

    public boolean isEmpty() {
        return this.singleValue == null && this.multiValues == null;
    }

    public static OneOrMultiValue<Long> getLongs(Object value) {
        if (value instanceof OneOrMultiValue) {
            OneOrMultiValue<Long> result = new OneOrMultiValue<Long>();
            for (Object tmp : (OneOrMultiValue)value) {
                result.addValue(TypeConvertor.toLong(tmp));
            }
            return result;
        }
        if (value instanceof Object[]) {
            OneOrMultiValue<Long> result = new OneOrMultiValue<Long>();
            Object[] objectArray = (Object[])value;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object tmp = objectArray[n2];
                result.addValue((Long)tmp);
                ++n2;
            }
            return result;
        }
        OneOrMultiValue<Long> result = new OneOrMultiValue<Long>();
        if (value != null && StringUtil.isNumeric((Object)value)) {
            result.addValue(TypeConvertor.toLong((Object)value));
        }
        return result;
    }

    public T getSingleValue() {
        return this.singleValue;
    }

    public List<T> asList() {
        if (this.multiValues != null) {
            return this.multiValues;
        }
        if (this.singleValue != null) {
            ArrayList<T> result = new ArrayList<T>();
            result.add(this.singleValue);
            return result;
        }
        return null;
    }

    public String toString() {
        if (this.singleValue != null) {
            return this.singleValue.toString();
        }
        if (this.multiValues != null) {
            return this.multiValues.toString();
        }
        return "null";
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < OneOrMultiValue.this.getValueCount();
            }

            @Override
            public T next() {
                Object result = OneOrMultiValue.this.getValue(this.pos);
                ++this.pos;
                return result;
            }
        };
    }

    public boolean hasValue(Object valueNoNull) {
        if (this.singleValue != null) {
            return this.singleValue.equals(valueNoNull);
        }
        if (this.multiValues != null) {
            return this.multiValues.contains(valueNoNull);
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OneOrMultiValue)) {
            return false;
        }
        OneOrMultiValue other = (OneOrMultiValue)obj;
        if (this.getValueCount() != other.getValueCount()) {
            return false;
        }
        for (T t : this) {
            if (other.hasValue(t)) continue;
            return false;
        }
        return true;
    }
}

