/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.group;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yes.mid.mysqls.group.DataObjectRelationTable;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.Groups;
import com.bokesoft.yes.mid.mysqls.group.RefDataObject;
import com.bokesoft.yes.mid.util.PropertyUtil;
import com.bokesoft.yigo.common.dom.DomHelper;
import java.io.InputStream;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GroupConfig {
    private Groups groups;
    private DataObjectRelationTable[] dataObjectRelationTables;
    public static final GroupConfig instance = GroupConfig.initGroupConfig();

    public static GroupConfig initGroupConfig() {
        try {
            return GroupConfig.GroupConfigXml();
        }
        catch (Throwable throwable) {
            LogSvr.getInstance().error("GroupConfig.xml \u5bfc\u5165\u5f02\u5e38", throwable);
            return null;
        }
    }

    private static GroupConfig GroupConfigXml() throws Throwable {
        GroupConfig groupConfig = new GroupConfig();
        InputStream fis = PropertyUtil.readProperties((String)"GroupConfig.xml");
        if (fis != null) {
            Document document = DomHelper.createDocument((InputStream)fis);
            Element root = document.getDocumentElement();
            List childList = DomHelper.getChildList((Element)root);
            for (Element element : childList) {
                if (element.getTagName().equals("Groups")) {
                    groupConfig.groups = GroupConfig.loadGroups(element);
                    continue;
                }
                if (!element.getTagName().equals("DataObjectRelationTables")) continue;
                groupConfig.dataObjectRelationTables = GroupConfig.loadDataObjectRelationTables(element);
            }
            fis.close();
            return groupConfig;
        }
        return null;
    }

    private static Groups loadGroups(Element groupsElement) {
        Groups groups = new Groups();
        for (Element element : DomHelper.getChildList((Element)groupsElement)) {
            Group group = Groups.loadGroupValue(element);
            groups.addGroup(group);
        }
        return groups;
    }

    private static DataObjectRelationTable[] loadDataObjectRelationTables(Element parentElement) {
        List childList = DomHelper.getChildList((Element)parentElement);
        int size = childList.size();
        DataObjectRelationTable[] result = new DataObjectRelationTable[size];
        int i = 0;
        while (i < size) {
            Element element = (Element)childList.get(i);
            String name = element.getAttribute("name");
            DataObjectRelationTable dataObjectRelationTable = new DataObjectRelationTable(name);
            for (Element refDataObjectElement : DomHelper.getChildList((Element)element)) {
                String refKey = refDataObjectElement.getAttribute("RefKey");
                String refKeyColumnName = refDataObjectElement.getAttribute("RefKeyColumnName");
                String refSOIDColumnName = refDataObjectElement.getAttribute("RefSOIDColumnName");
                dataObjectRelationTable.addRefDataObject(new RefDataObject(refKey, refKeyColumnName, refSOIDColumnName));
            }
            result[i] = dataObjectRelationTable;
            ++i;
        }
        return result;
    }

    public Groups getGroups() {
        return this.groups;
    }

    public DataObjectRelationTable[] getDataObjectRelationTables() {
        return this.dataObjectRelationTables;
    }

    public DataObjectRelationTable getDataObjectRelationTable(String tableName) {
        DataObjectRelationTable[] dataObjectRelationTableArray = this.dataObjectRelationTables;
        int n = this.dataObjectRelationTables.length;
        int n2 = 0;
        while (n2 < n) {
            DataObjectRelationTable result = dataObjectRelationTableArray[n2];
            if (result.name.equalsIgnoreCase(tableName)) {
                return result;
            }
            ++n2;
        }
        return null;
    }
}

