/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.yes.mid.mysqls.execute.OneQuery;
import com.bokesoft.yes.mid.mysqls.group.DictGroupField;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yes.mid.mysqls.processselect.RelationBetweenSubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuery;
import com.bokesoft.yes.mid.mysqls.processselect.SubQuerys;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class QueryPlan {
    final SubQuerys subQuerys;
    List<OneQuery> queries = new ArrayList<OneQuery>();
    Set<SubQuery> notShowInResult = null;
    Set<SubQuery> hasInOther = null;

    public QueryPlan(SubQuerys subQuery) {
        this.subQuerys = subQuery;
    }

    public SubQuerys getQuerys() {
        return this.subQuerys;
    }

    public List<OneQuery> getQueryList() {
        return this.queries;
    }

    public boolean onlyOneQuery() {
        int result = 0;
        for (SubQuery subQuery : this.subQuerys.getSubQuerys()) {
            if (this.notShowInResult != null && this.notShowInResult.contains(subQuery) || this.hasInOther != null && this.hasInOther.contains(subQuery)) continue;
            ++result;
        }
        return result == 1;
    }

    public SubQuery getMainQuery() {
        for (SubQuery subQuery : this.subQuerys.getSubQuerys()) {
            if (!subQuery.isMainSelect()) continue;
            return subQuery;
        }
        return null;
    }

    public void addHasInOtherQuery(SubQuery subSelect) {
        if (this.hasInOther == null) {
            this.hasInOther = new HashSet<SubQuery>();
        }
        if (!this.hasInOther.contains(subSelect)) {
            this.hasInOther.add(subSelect);
        }
    }

    public void addNotShowInResultQuery(SubQuery subSelect) {
        if (this.notShowInResult == null) {
            this.notShowInResult = new HashSet<SubQuery>();
        }
        if (!this.notShowInResult.contains(subSelect)) {
            this.notShowInResult.add(subSelect);
        }
    }

    public static SubQuerys addDictGroupRelationBetweenSubQuery(SubQuerys subQuerys) {
        List<RelationBetweenSubQuery> relations = subQuerys.getRelations();
        if (relations != null) {
            ArrayList<RelationBetweenSubQuery> addRelations = null;
            for (RelationBetweenSubQuery relation : relations) {
                Group group;
                SubQuery rightSubQuery;
                String rightTableName;
                SubQuery leftSubQuery;
                String leftTableName;
                boolean isRightOIDOrSOID;
                String leftColumn = relation.getLeftColumn().getColumnName();
                String rightColumn = relation.getRightColumn().getColumnName();
                boolean isLeftOIDOrSOID = leftColumn.equalsIgnoreCase("OID") || leftColumn.equalsIgnoreCase("SOID");
                boolean bl = isRightOIDOrSOID = rightColumn.equalsIgnoreCase("OID") || rightColumn.equalsIgnoreCase("SOID");
                if ((!isLeftOIDOrSOID || isRightOIDOrSOID) && (isLeftOIDOrSOID || !isRightOIDOrSOID) || (leftTableName = (leftSubQuery = relation.getLeftSubQuery()).getOnlyTableName()) == null || (rightTableName = (rightSubQuery = relation.getRightSubQuery()).getOnlyTableName()) == null) continue;
                TableGroupProp leftTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(leftTableName);
                TableGroupProp rightTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(rightTableName);
                if (leftTableGroupProp == null || leftTableGroupProp.getFixedType() == null || rightTableGroupProp == null || rightTableGroupProp.getFixedType() == null || (group = leftTableGroupProp.getGroup()) != rightTableGroupProp.getGroup()) continue;
                List<GroupField> groupFields = group.getGroupFields();
                int i = 0;
                int size = groupFields.size();
                while (i < size) {
                    GroupField groupField = groupFields.get(i);
                    if (groupField instanceof DictGroupField) {
                        String leftDictGroupColumn = group.getGroupTable(leftTableName).getGroupColumnNames()[i];
                        String rightDictGroupColumn = group.getGroupTable(rightTableName).getGroupColumnNames()[i];
                        if (leftDictGroupColumn != null && rightDictGroupColumn != null) {
                            if (addRelations == null) {
                                addRelations = new ArrayList<RelationBetweenSubQuery>();
                            }
                            RelationBetweenSubQuery tmp = new RelationBetweenSubQuery();
                            tmp.setEqual(true);
                            tmp.setLeftSubQuery(leftSubQuery);
                            String leftTableAliasName = ((Table)leftSubQuery.getPlainSelect().getFromItem()).getAliasName();
                            tmp.setLeftColumn(new Column(new Table(null, leftTableAliasName), leftDictGroupColumn).setExtendTable((Table)leftSubQuery.getPlainSelect().getFromItem(), leftDictGroupColumn));
                            tmp.setRightSubQuery(rightSubQuery);
                            String rightTableAliasName = ((Table)rightSubQuery.getPlainSelect().getFromItem()).getAliasName();
                            tmp.setRightColumn(new Column(new Table(null, rightTableAliasName), rightDictGroupColumn).setExtendTable((Table)rightSubQuery.getPlainSelect().getFromItem(), rightDictGroupColumn));
                            addRelations.add(tmp);
                        }
                    }
                    ++i;
                }
            }
            if (addRelations != null) {
                relations.addAll(addRelations);
            }
        }
        return subQuerys;
    }

    public static SubQuerys preProcessSubQuery(SubQuerys subQuerys) {
        QueryPlan.sortSubQuery(subQuerys);
        List<SubQuery> subSelectList = subQuerys.getQueryOrder();
        List<RelationBetweenSubQuery> relations = subQuerys.getRelations();
        if (relations != null) {
            for (RelationBetweenSubQuery relation : relations) {
                int leftIndex = subSelectList.indexOf(relation.getLeftSubQuery());
                int rightIndex = subSelectList.indexOf(relation.getRightSubQuery());
                if (rightIndex > leftIndex) {
                    relation = relation.exchangeLeftRight();
                }
                SubQuery rightSubSelect = relation.getRightSubQuery();
                SubQuery leftSubSelect = relation.getLeftSubQuery();
                SelectExpressionItem rightSelectItem = rightSubSelect.addColumn(relation.getRightColumn(), true, null, false);
                relation.setRightSelectItem(rightSelectItem);
                if ((leftSubSelect.isMainSelect() || leftSubSelect.isInSelect()) && rightSubSelect.isInSelect()) continue;
                SelectExpressionItem leftSelectItem = leftSubSelect.addColumn(relation.getLeftColumn(), true, null, false);
                relation.setLeftSelectItem(leftSelectItem);
            }
        }
        return subQuerys;
    }

    private static void sortSubQuery(SubQuerys subQuerys) {
        SubQuery subQuery;
        List<SubQuery> subSelectList = subQuerys.getSubQuerys();
        int size = subSelectList.size();
        ArrayList<SubQuery> unsortedSubQuery = new ArrayList<SubQuery>(size);
        unsortedSubQuery.addAll(subSelectList);
        boolean[] isSort = new boolean[size];
        ArrayList<SubQuery> sortedSubQuery = new ArrayList<SubQuery>(size);
        int i = 0;
        while (i < size) {
            if (!isSort[i] && (subQuery = (SubQuery)unsortedSubQuery.get(i)).isInSelect() && subQuery.isDefaultGroup()) {
                QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, i);
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (!isSort[i] && (subQuery = (SubQuery)unsortedSubQuery.get(i)).isInSelect() && subQuery.isSingleGroup()) {
                QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, i);
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            if (!isSort[i] && (subQuery = (SubQuery)unsortedSubQuery.get(i)).isInSelect()) {
                QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, i);
            }
            ++i;
        }
        if (sortedSubQuery.size() < size) {
            List<RelationBetweenSubQuery> relations;
            SubQuery subQuery2;
            Expression where;
            ArrayList<SubQuery> hasWhereSubQuerys = new ArrayList<SubQuery>(size);
            int i2 = 0;
            while (i2 < size) {
                if (!isSort[i2] && ParsedSqlUtil.hasOIDOrSOIDInWhereExpression(where = (subQuery2 = (SubQuery)unsortedSubQuery.get(i2)).getPlainSelect().getWhere())) {
                    QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, i2);
                    hasWhereSubQuerys.add(subQuery2);
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < size) {
                if (!isSort[i2] && ParsedSqlUtil.hasRefOIDInWhereExpression(where = (subQuery2 = (SubQuery)unsortedSubQuery.get(i2)).getPlainSelect().getWhere())) {
                    QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, i2);
                    hasWhereSubQuerys.add(subQuery2);
                }
                ++i2;
            }
            if (sortedSubQuery.size() < size && (relations = subQuerys.getRelations()) != null) {
                boolean needNextLoop = true;
                while (needNextLoop && unsortedSubQuery.size() > 0) {
                    needNextLoop = false;
                    for (RelationBetweenSubQuery relation : relations) {
                        SubQuery rightSubSelect = relation.getRightSubQuery();
                        SubQuery leftSubSelect = relation.getLeftSubQuery();
                        if (unsortedSubQuery.contains(leftSubSelect) && !isSort[unsortedSubQuery.indexOf(leftSubSelect)] && hasWhereSubQuerys.contains(rightSubSelect)) {
                            QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, unsortedSubQuery.indexOf(leftSubSelect));
                            hasWhereSubQuerys.add(leftSubSelect);
                            needNextLoop = true;
                            continue;
                        }
                        if (!unsortedSubQuery.contains(rightSubSelect) || isSort[unsortedSubQuery.indexOf(rightSubSelect)] || !hasWhereSubQuerys.contains(leftSubSelect)) continue;
                        QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, unsortedSubQuery.indexOf(rightSubSelect));
                        hasWhereSubQuerys.add(rightSubSelect);
                        needNextLoop = true;
                    }
                }
            }
            if (sortedSubQuery.size() < size) {
                i = 0;
                while (i < size) {
                    if (!isSort[i]) {
                        QueryPlan.moveUnsortedToSorted(unsortedSubQuery, isSort, sortedSubQuery, i);
                    }
                    ++i;
                }
            }
        }
        int mainQueryIndex = -1;
        int firstLeftJoinIndex = -1;
        int i3 = 0;
        while (i3 < size) {
            SubQuery subQuery3 = (SubQuery)sortedSubQuery.get(i3);
            if (subQuery3.isMainSelect()) {
                mainQueryIndex = i3;
            } else if (firstLeftJoinIndex == -1 && subQuery3.getFirstJoinIsLeft()) {
                firstLeftJoinIndex = i3;
            }
            ++i3;
        }
        assert (mainQueryIndex >= 0 || size == 0);
        if (firstLeftJoinIndex != -1 && mainQueryIndex > firstLeftJoinIndex) {
            SubQuery mainQuery = (SubQuery)sortedSubQuery.remove(mainQueryIndex);
            sortedSubQuery.add(firstLeftJoinIndex, mainQuery);
        }
        subQuerys.setQueryOrder(sortedSubQuery);
    }

    private static void moveUnsortedToSorted(List<SubQuery> unsortedSubQuery, boolean[] isSort, List<SubQuery> sortedSubQuery, int index) {
        isSort[index] = true;
        SubQuery subQuery = unsortedSubQuery.get(index);
        sortedSubQuery.add(subQuery);
        int insertPos = sortedSubQuery.size() - 1;
        SubQuery leftJoinPreSubQuery = subQuery.getLeftJoinPerSubQuery();
        while (leftJoinPreSubQuery != null) {
            int leftJoinPreSubQueryIndex = unsortedSubQuery.indexOf(leftJoinPreSubQuery);
            if (isSort[leftJoinPreSubQueryIndex]) break;
            isSort[leftJoinPreSubQueryIndex] = true;
            sortedSubQuery.add(insertPos, leftJoinPreSubQuery);
            leftJoinPreSubQuery = leftJoinPreSubQuery.getLeftJoinPerSubQuery();
        }
        insertPos = sortedSubQuery.size() - 1;
        int i = 0;
        int size = unsortedSubQuery.size();
        while (i < size) {
            if (!isSort[i] && unsortedSubQuery.get((int)i).inValuesForSubQuery == subQuery) {
                isSort[i] = true;
                sortedSubQuery.add(insertPos, unsortedSubQuery.get(i));
            }
            ++i;
        }
    }

    public static QueryPlan getQueryPlan(SubQuerys subQuerys) {
        QueryPlan result = new QueryPlan(subQuerys);
        List<SubQuery> subSelectList = subQuerys.getQueryOrder();
        for (SubQuery subSelect : subSelectList) {
            OneQuery oneQuery = new OneQuery();
            oneQuery.subQuery = subSelect;
            result.queries.add(oneQuery);
            List<RelationBetweenSubQuery> relations = subQuerys.getRelations();
            if (relations == null || relations.size() == 0) continue;
            for (RelationBetweenSubQuery relationBetweenSubQuery : relations) {
                RelationBetweenSubQuery relationAdd = null;
                if (relationBetweenSubQuery.getLeftSubQuery() == subSelect) {
                    relationAdd = relationBetweenSubQuery;
                }
                if (relationAdd == null) continue;
                oneQuery.addRelation(relationAdd);
                if (relationAdd.isEqual()) continue;
                result.addNotShowInResultQuery(relationAdd.getRightSubQuery());
            }
        }
        for (OneQuery oneQuery : result.queries) {
            SubQuery subSelect = oneQuery.subQuery;
            if (oneQuery.relations == null) continue;
            for (RelationBetweenSubQuery relation : oneQuery.relations) {
                SubQuery rightSubSelect = relation.getRightSubQuery();
                if (rightSubSelect.isInSelect()) continue;
                subSelect.addColumn(relation.getLeftColumn(), false, null, false);
            }
        }
        for (OneQuery oneQuery : result.queries) {
            PlainSelect plainSelect = oneQuery.subQuery.getPlainSelect();
            ArrayList<SelectExpressionItem> selectItems = plainSelect.getSelectItems();
            if (selectItems == null) {
                selectItems = new ArrayList<SelectExpressionItem>();
                plainSelect.setSelectItems(selectItems);
            }
            if (selectItems.size() != 0) continue;
            SelectExpressionItem selectExpressionItem = new SelectExpressionItem();
            selectExpressionItem.setExpression(new LongValue("0"));
            selectExpressionItem.setAlias("AutoAddColumn");
            selectItems.add(selectExpressionItem);
        }
        return result;
    }

    public boolean isShowInResult(SubQuery subQuery) {
        if (this.notShowInResult == null || this.notShowInResult.size() == 0) {
            return true;
        }
        return !this.notShowInResult.contains(subQuery);
    }

    public int getQueryIndexByTable(Table table) {
        int i = 0;
        int len = this.queries.size();
        while (i < len) {
            SubQuery subSelect = this.subQuerys.getSubQuerys().get(i);
            if (subSelect.hasFromItem(table)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getQueryIndexByAliasName(String aliasName) {
        int i = 0;
        int len = this.queries.size();
        while (i < len) {
            SubQuery subSelect = this.subQuerys.getSubQuerys().get(i);
            if (subSelect.hasAliasName(aliasName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String toAssertString() {
        StringBuilder sb = new StringBuilder(1024);
        int i = 0;
        int size = this.queries.size();
        while (i < size) {
            OneQuery oneQuery = this.queries.get(i);
            String sql = oneQuery.getSubQuery().getPlainSelect().toString();
            if (sql.indexOf(" FROM ") > 100) {
                sql = sql.replaceAll(" FROM ", " \n    FROM ");
            }
            if (sql.indexOf(" WHERE ") > 100) {
                sql = sql.replaceAll(" WHERE ", " \n    WHERE ");
            }
            sb.append(i).append(". ").append(sql).append("\n");
            if (oneQuery.getRelations() != null) {
                sb.append(oneQuery.getRelations().toString()).append("\n");
            }
            if (oneQuery.getSubQuery().getLeftJoinCondition() != null) {
                sb.append("    LeftJoinCondition: ").append(oneQuery.getSubQuery().getLeftJoinCondition()).append("\n");
            }
            ++i;
        }
        if (this.subQuerys.getCalcItemsBeforeGroup() != null) {
            sb.append("CalcItemsBeforeGroup:").append(this.subQuerys.getCalcItemsBeforeGroup()).append("\n");
        }
        if (this.subQuerys.getCalcItems() != null) {
            sb.append("CalcItems:").append(this.subQuerys.getCalcItems()).append("\n");
        }
        if (this.subQuerys.getExtendHavingExpression() != null) {
            sb.append("ExtendHaving:").append(this.subQuerys.getExtendHavingExpression()).append("\n");
        }
        return sb.toString();
    }

    public String toString() {
        return this.toAssertString();
    }
}

