/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.execute.ExecuteUtil;
import com.bokesoft.yes.mid.mysqls.execute.MoveHeadDataAfterGroupDetailChangeDSN;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.sql.InsertSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class InsertExecute {
    public static int[] execute(MultiDBManager dbManager, MultiDBPreparedStatement mdbPreparedStatement) throws SQLException {
        int[] result = null;
        String sql = mdbPreparedStatement.getSql();
        InsertSqlInfo sqlInfo = (InsertSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        if (Performance.RUN_IN_DEBUG && !sqlInfo.isNoGroup()) {
            sqlInfo.checkSupportMultiDBs();
        }
        String tableName = sqlInfo.getTableName();
        TableGroupProp tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(tableName);
        boolean isMoveHead = tableGroupProp != null && tableGroupProp.getFixedType() == TableGroupType.DetailTableInGroupByDetailTable && tableGroupProp.getHeadTableName() != null;
        Map<DSNTableName, List<Parameters>> dsnNameToParametersList = mdbPreparedStatement.getDSNNameToParametersList();
        for (Map.Entry<DSNTableName, List<Parameters>> entry : dsnNameToParametersList.entrySet()) {
            OneOrMultiValue<String> dsnNames = entry.getKey().getDsnNames();
            for (String dsnName : dsnNames) {
                Connection connection = dbManager.getConnectionByDSNName(dsnName);
                String newSql = sql;
                try (PreparedStatement preparedStatement = null;){
                    Long soid;
                    Parameters parameters2;
                    preparedStatement = connection.prepareStatement(newSql);
                    List<Parameters> parametersList = entry.getValue();
                    if (parametersList != null && parametersList.size() > 1) {
                        for (Parameters parameters2 : parametersList) {
                            Long soid2;
                            ExecuteUtil.setParameters(preparedStatement, parameters2);
                            preparedStatement.addBatch();
                            if (!isMoveHead || dbManager.isNewInsertSOID(tableName, soid2 = sqlInfo.getPrimaryKeyLongNewValue("SOID", parameters2))) continue;
                            MoveHeadDataAfterGroupDetailChangeDSN delayMove = dbManager.getMoveHeadDataAfterGroupDetailChangeDSN();
                            String headTableName = tableGroupProp.getHeadTableName();
                            delayMove.addInsertDSNTableName(headTableName, soid2, dsnName);
                        }
                        Object[] actions = new Object[]{dsnName, ": ", sql, parametersList};
                        int action = Performance.startAction((Object[])actions);
                        int[] is = preparedStatement.executeBatch();
                        Performance.endActive((int)action, (Object[])actions);
                        result = ExecuteUtil.mergeExecuteBatchResult(mdbPreparedStatement, result, parametersList, is);
                        continue;
                    }
                    parameters2 = parametersList == null ? null : parametersList.get(0);
                    ExecuteUtil.setParameters(preparedStatement, parameters2);
                    if (isMoveHead && !dbManager.isNewInsertSOID(tableName, soid = sqlInfo.getPrimaryKeyLongNewValue("SOID", parameters2))) {
                        MoveHeadDataAfterGroupDetailChangeDSN delayMove = dbManager.getMoveHeadDataAfterGroupDetailChangeDSN();
                        String headTableName = tableGroupProp.getHeadTableName();
                        delayMove.addInsertDSNTableName(headTableName, soid, dsnName);
                    }
                    Object[] actions = new Object[]{dsnName, ": ", sql, parameters2};
                    int action = Performance.startAction((Object[])actions);
                    preparedStatement.execute();
                    Performance.endActive((int)action, (Object[])actions);
                    int tmp = preparedStatement.getUpdateCount();
                    result = ExecuteUtil.mergeExecuteBatchResult(mdbPreparedStatement, result, parameters2, tmp);
                }
            }
        }
        mdbPreparedStatement.setExecuted();
        mdbPreparedStatement.clearDsnNameParaList();
        return result;
    }
}

