/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.execute;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBPreparedStatement;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.execute.ExecuteUtil;
import com.bokesoft.yes.mid.mysqls.execute.MoveHeadDataAfterGroupDetailChangeDSN;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.sql.DeleteSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class DeleteExecute {
    public static int[] execute(MultiDBManager dbManager, MultiDBPreparedStatement mdbPreparedStatement) throws SQLException {
        int[] result = null;
        String sql = mdbPreparedStatement.getSql();
        DeleteSqlInfo sqlInfo = (DeleteSqlInfo)SqlInfos.instance.getSqlInfo(sql);
        if (Performance.RUN_IN_DEBUG && !sqlInfo.isNoGroup()) {
            sqlInfo.checkSupportMultiDBs();
        }
        String tableName = sqlInfo.getTableName();
        TableGroupProp tableGroupProp = TableGroupProps.getInstance().getTableGroupProp(tableName);
        boolean isMoveHead = tableGroupProp != null && tableGroupProp.getFixedType() == TableGroupType.DetailTableInGroupByDetailTable && tableGroupProp.getHeadTableName() != null;
        boolean isRemoveMoveHead = tableGroupProp != null && tableGroupProp.getFixedType() == TableGroupType.HeadTableInGroupByDetailTable;
        Map<DSNTableName, List<Parameters>> dsnNameToParametersList = mdbPreparedStatement.getDSNNameToParametersList();
        for (Map.Entry<DSNTableName, List<Parameters>> entry : dsnNameToParametersList.entrySet()) {
            OneOrMultiValue<String> dsnNames = entry.getKey().getDsnNames();
            if (dsnNames == null) continue;
            for (String dsnName : dsnNames) {
                Connection connection = dbManager.getConnectionByDSNName(dsnName);
                List<Parameters> parametersList = entry.getValue();
                try (PreparedStatement preparedStatement = null;){
                    Parameters parameters2;
                    preparedStatement = connection.prepareStatement(sql);
                    if (parametersList != null && parametersList.size() > 1) {
                        for (Parameters parameters2 : parametersList) {
                            MoveHeadDataAfterGroupDetailChangeDSN delayMove;
                            OneOrMultiValue<Long> soids;
                            ExecuteUtil.setParameters(preparedStatement, parameters2);
                            preparedStatement.addBatch();
                            if (isMoveHead) {
                                soids = sqlInfo.getPrimaryKeyLongOriginalValue("SOID", parameters2);
                                if (soids == null || soids.isEmpty()) {
                                    throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5220\u9664\u6309\u660e\u7ec6\u8868\u5206\u5e93\u7684\u660e\u7ec6\u8868" + tableName + "\u65f6\u9700\u8981\u80fd\u53d6\u5230SOID\u3002\n" + sql);
                                }
                                delayMove = dbManager.getMoveHeadDataAfterGroupDetailChangeDSN();
                                String headTableName = tableGroupProp.getHeadTableName();
                                for (Long soid : soids) {
                                    delayMove.addDeleteDSNTableName(headTableName, soid, dsnName);
                                }
                            }
                            if (!isRemoveMoveHead) continue;
                            soids = sqlInfo.getPrimaryKeyLongOriginalValue("OID", parameters2);
                            if (soids == null || soids.isEmpty()) {
                                soids = sqlInfo.getPrimaryKeyLongOriginalValue("SOID", parameters2);
                            }
                            if (soids == null || soids.isEmpty()) {
                                throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5220\u9664\u6309\u660e\u7ec6\u8868\u5206\u5e93\u7684\u5934\u8868" + tableName + "\u65f6\u9700\u8981\u80fd\u53d6\u5230OID\u6216SOID\u3002\n" + sql);
                            }
                            delayMove = dbManager.getMoveHeadDataAfterGroupDetailChangeDSN();
                            for (Long soid : soids) {
                                delayMove.removeMoveHead(tableName, soid);
                            }
                        }
                        Object[] actions = new Object[]{dsnName, ": ", sql, parametersList};
                        int action = Performance.startAction((Object[])new Object[]{dsnName, ": ", sql, parametersList});
                        int[] is = preparedStatement.executeBatch();
                        Performance.endActive((int)action, (Object[])actions);
                        result = ExecuteUtil.mergeExecuteBatchResult(mdbPreparedStatement, result, parametersList, is);
                        continue;
                    }
                    parameters2 = parametersList == null ? null : parametersList.get(0);
                    ExecuteUtil.setParameters(preparedStatement, parameters2);
                    if (isMoveHead) {
                        OneOrMultiValue<Long> soids = sqlInfo.getPrimaryKeyLongOriginalValue("SOID", parameters2);
                        if (soids == null || soids.isEmpty()) {
                            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5220\u9664\u6309\u660e\u7ec6\u8868\u5206\u5e93\u7684\u660e\u7ec6\u8868" + tableName + "\u65f6\u9700\u8981\u80fd\u53d6\u5230SOID\u3002\n" + sql);
                        }
                        MoveHeadDataAfterGroupDetailChangeDSN delayMove = dbManager.getMoveHeadDataAfterGroupDetailChangeDSN();
                        String headTableName = tableGroupProp.getHeadTableName();
                        for (Long soid : soids) {
                            delayMove.addDeleteDSNTableName(headTableName, soid, dsnName);
                        }
                    }
                    if (isRemoveMoveHead) {
                        OneOrMultiValue<Long> soids = sqlInfo.getPrimaryKeyLongOriginalValue("OID", parameters2);
                        if (soids == null || soids.isEmpty()) {
                            soids = sqlInfo.getPrimaryKeyLongOriginalValue("SOID", parameters2);
                        }
                        if (soids == null || soids.isEmpty()) {
                            throw new RuntimeException("\u5206\u5e93\u51fa\u9519\uff0c\u5220\u9664\u6309\u660e\u7ec6\u8868\u5206\u5e93\u7684\u5934\u8868" + tableName + "\u65f6\u9700\u8981\u80fd\u53d6\u5230OID\u6216SOID\u3002\n" + sql);
                        }
                        MoveHeadDataAfterGroupDetailChangeDSN delayMove = dbManager.getMoveHeadDataAfterGroupDetailChangeDSN();
                        for (Long soid : soids) {
                            delayMove.removeMoveHead(tableName, soid);
                        }
                    }
                    Object[] actions = new Object[]{dsnName, ": ", sql, parameters2};
                    int action = Performance.startAction((Object[])actions);
                    preparedStatement.execute();
                    Performance.endActive((int)action, (Object[])actions);
                    int tmp = preparedStatement.getUpdateCount();
                    result = ExecuteUtil.mergeExecuteBatchResult(mdbPreparedStatement, result, parameters2, tmp);
                }
            }
        }
        mdbPreparedStatement.setExecuted();
        return result;
    }
}

