/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dsntablename;

import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.Parameters;
import com.bokesoft.yes.mid.mysqls.dsntablename.DeleteDSNTableNameCalc;
import com.bokesoft.yes.mid.mysqls.group.DataObjectRelationTable;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.GroupField;
import com.bokesoft.yes.mid.mysqls.group.GroupTable;
import com.bokesoft.yes.mid.mysqls.group.HeadDetailTable;
import com.bokesoft.yes.mid.mysqls.group.OneGroupValue;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.RefDataObject;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.oidpool.DSNTableName;
import com.bokesoft.yes.mid.mysqls.oidpool.OIDPool;
import com.bokesoft.yes.mid.mysqls.sql.InsertSqlInfo;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfo;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.List;
import java.util.Map;

public class InsertDSNTableNameCalc {
    public static OneOrMultiValue<DSNTableName> calcDSNTableName(TableGroupProp tableGroupProp, InsertSqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, IDBManager dbm) throws Throwable {
        String tableName = tableGroupProp.getTableName();
        TableGroupType type = tableGroupProp.getFixedType();
        OneOrMultiValue<DSNTableName> result = new OneOrMultiValue<DSNTableName>();
        if (type == TableGroupType.HeadTableInGroupByHeadTable) {
            Long oid = sqlInfo.getPrimaryKeyLongNewValue("OID", parameters);
            Group group = tableGroupProp.getGroup();
            OneGroupValue newGroupValue = InsertDSNTableNameCalc.getDSNNameOneGroupValue(group, sqlInfo, parameters);
            String newDSNName = group.getDSNName(tableName, newGroupValue);
            oidPool.setOIDDSNName(oid, newDSNName, tableName);
            result.addValue(new DSNTableName(newDSNName));
        } else if (type == TableGroupType.DetailTableExtra) {
            TableGroupProp headGroupProp;
            HeadDetailTable headTableForDetailTableExtra = tableGroupProp.getHeadTableForDetailTableExtra();
            Long soid = sqlInfo.getPrimaryKeyLongNewValue(headTableForDetailTableExtra.columnNameRefHeadOID, parameters);
            DSNTableName dsnTableName = oidPool.getDSNTableName(soid, headGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableForDetailTableExtra.headTableName));
            if (dsnTableName == null || dsnTableName.getSingleDSNName() == null) {
                throw new Throwable("\u672a\u627e\u5230\u5339\u914d\u7684\u5206\u5e93\u6570\u636e\u5e93!");
            }
            result.addValue(DSNTableName.getDSNTableNameNewValue(dsnTableName));
            if (tableGroupProp.hasExtraChild()) {
                Long oid = sqlInfo.getPrimaryKeyLongNewValue("SOID", parameters);
                oidPool.setOIDDSNName(oid, dsnTableName.getSingleDSNName(), tableName);
            }
        } else if (type == TableGroupType.DetailTableInGroupByDetailTable) {
            Group group = tableGroupProp.getGroup();
            OneGroupValue newGroupValue = InsertDSNTableNameCalc.getDSNNameOneGroupValue(group, sqlInfo, parameters);
            String newDSNName = group.getDSNName(tableName, newGroupValue);
            result.addValue(new DSNTableName(newDSNName));
        } else if (type == TableGroupType.HeadTableInGroupByDetailTable) {
            DSNTableName dsnTableName;
            Long oid = sqlInfo.getPrimaryKeyLongNewValue("OID", parameters);
            if (!dbm.getCacheDBRequest().hasSOIDLoadAllInCacheTable(tableGroupProp.getGroupDetailTable().getTableName(), oid)) {
                dsnTableName = new DSNTableName(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
            } else {
                dsnTableName = InsertDSNTableNameCalc.calcDSNTableNameDetailTableBySOID(oid, dbm, tableGroupProp.getGroupDetailTable());
                oidPool.setOIDDSNName(oid, dsnTableName);
            }
            result.addValue(dsnTableName);
        } else if (type == TableGroupType.SimpleTable) {
            Group group = tableGroupProp.getGroup();
            OneGroupValue newGroupValue = InsertDSNTableNameCalc.getDSNNameOneGroupValue(group, sqlInfo, parameters);
            String newDSNName = group.getDSNName(tableName, newGroupValue);
            result.addValue(new DSNTableName(newDSNName));
        } else if (type == TableGroupType.DataObjectRelationTable) {
            DSNTableName dsnTableName = InsertDSNTableNameCalc.calcDSNTableNameDataObjectRelationTable(sqlInfo, parameters, tableName, oidPool, dbm);
            result.addValue(dsnTableName);
        } else {
            DSNTableName dsnTableName = InsertDSNTableNameCalc.calcDSNTableNameDetailTableOrNotGroup(tableGroupProp, sqlInfo, parameters, oidPool, dbm, false);
            if (dsnTableName == null) {
                dsnTableName = InsertDSNTableNameCalc.calcDSNTableNameDetailTableOrNotGroup(tableGroupProp, sqlInfo, parameters, oidPool, dbm, true);
            }
            if (dsnTableName == null) {
                dsnTableName = new DSNTableName(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
            }
            result.addValue(dsnTableName);
        }
        return result;
    }

    private static OneGroupValue getDSNNameOneGroupValue(Group group, SqlInfo sqlInfo, Parameters parameters) throws Throwable {
        OneGroupValue result = new OneGroupValue();
        List<GroupField> groupFields = group.getGroupFields();
        for (GroupField groupField : groupFields) {
            Object value = group.getGroupFieldValue(sqlInfo.getTableName(), groupField, result, sqlInfo, parameters);
            result.setGroupValue(groupField.getKey(), value);
        }
        return result;
    }

    private static DSNTableName calcDSNTableNameDetailTableBySOID(Long soid, IDBManager dbm, TableGroupProp detailTableGroupProp) throws Throwable {
        String tableName = detailTableGroupProp.getTableName();
        Group group = detailTableGroupProp.getGroup();
        GroupTable groupTable = group.getDefTableNams().get(tableName);
        String[] columnNames = groupTable.getGroupColumnNames();
        List<GroupField> groupFields = group.getGroupFields();
        DSNTableName result = new DSNTableName();
        Long[] oids = dbm.getCacheDBRequest().getOIDsbySOID(tableName, soid);
        if (oids == null) {
            String defaultDSNName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
            result.addDSNName(defaultDSNName);
            return result;
        }
        Long[] longArray = oids;
        int n = oids.length;
        int n2 = 0;
        while (n2 < n) {
            Long oid = longArray[n2];
            OneGroupValue groupValue = new OneGroupValue();
            int i = 0;
            int size = groupFields.size();
            while (i < size) {
                Object value = columnNames[i] != null ? dbm.getCacheDBRequest().getValueFromCacheTableByOID(tableName, oid, columnNames[i]) : group.getGroupFieldValueByRelationTables(tableName, groupFields.get(i), groupValue);
                groupValue.setGroupValue(groupFields.get(i).getKey(), value);
                ++i;
            }
            String dsnName = group.getDSNName(tableName, groupValue);
            result.addDSNName(dsnName);
            ++n2;
        }
        return result;
    }

    private static DSNTableName calcDSNTableNameHeadTableBySOID(Long soid, IDBManager dbm, TableGroupProp headTableGroupProp) throws Throwable {
        DSNTableName result = new DSNTableName();
        if (headTableGroupProp != null) {
            if (headTableGroupProp.getGroup() == null && headTableGroupProp.getGroupDetailTable() != null) {
                headTableGroupProp = headTableGroupProp.getGroupDetailTable();
            }
            String tableName = headTableGroupProp.getTableName();
            Group group = headTableGroupProp.getGroup();
            GroupTable groupTable = group.getDefTableNams().get(tableName);
            String[] columnNames = groupTable.getGroupColumnNames();
            List<GroupField> groupFields = group.getGroupFields();
            Long[] oids = dbm.getCacheDBRequest().getOIDsbySOID(tableName, soid);
            if (oids == null || oids.length == 0) {
                String defaultDSNName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
                result.addDSNName(defaultDSNName);
                return result;
            }
            Long[] longArray = oids;
            int n = oids.length;
            int n2 = 0;
            while (n2 < n) {
                Long oid = longArray[n2];
                OneGroupValue groupValue = new OneGroupValue();
                int i = 0;
                int size = groupFields.size();
                while (i < size) {
                    Object value = columnNames[i] != null ? dbm.getCacheDBRequest().getValueFromCacheTableByOID(tableName, oid, columnNames[i]) : group.getGroupFieldValueByRelationTables(tableName, groupFields.get(i), groupValue);
                    groupValue.setGroupValue(groupFields.get(i).getKey(), value);
                    ++i;
                }
                String dsnName = group.getDSNName(tableName, groupValue);
                result.addDSNName(dsnName);
                ++n2;
            }
        }
        return result;
    }

    private static DSNTableName calcDSNTableNameDetailTableOrNotGroup(TableGroupProp tableGroupProp, InsertSqlInfo sqlInfo, Parameters parameters, OIDPool oidPool, IDBManager dbm, boolean check) throws Throwable {
        Long soid = sqlInfo.getPrimaryKeyLongNewValue("SOID", parameters);
        Map<String, TableGroupType> types = tableGroupProp.getVariableTypes();
        DSNTableName result = null;
        for (Map.Entry<String, TableGroupType> entry : types.entrySet()) {
            TableGroupProp headTableGroupProp;
            boolean hasOID;
            String headTableName = entry.getKey();
            boolean bl = hasOID = check ? InsertDSNTableNameCalc.checkOIDInTable(dbm, headTableName, soid) : dbm.getCacheDBRequest().hasOIDInCacheTable(headTableName, soid);
            if (!hasOID) continue;
            TableGroupType type = entry.getValue();
            if (type == TableGroupType.NotGroup) {
                result = new DSNTableName(CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName());
                break;
            }
            if (type == TableGroupType.DetailTableInGroupByHeadTable) {
                TableGroupProp headTableGroupProp2 = TableGroupProps.getInstance().getTableGroupProp(headTableName);
                result = DSNTableName.getDSNTableNameNewValue(oidPool.getDSNTableName(soid, headTableGroupProp2));
                if (!result.isDsnNameEmpty()) break;
                result = InsertDSNTableNameCalc.calcDSNTableNameHeadTableBySOID(soid, dbm, headTableGroupProp2);
                break;
            }
            if (type == TableGroupType.SonDetailTableInGroupByDetailTable) {
                TableGroupProp headTableGroupProp3 = TableGroupProps.getInstance().getTableGroupProp(headTableName);
                DSNTableName tmp = DSNTableName.getDSNTableNameNewValue(oidPool.getDSNTableName(soid, headTableGroupProp3));
                if (tmp.isSingleDsnName()) {
                    result = tmp;
                    break;
                }
                String tableName = tableGroupProp.getTableName();
                MetaDataObject dataObject = DataObjects.getDataObject(headTableName, tableName);
                Long poid = sqlInfo.getPrimaryKeyLongNewValue("POID", parameters);
                MetaTable metaTable = DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, tableName);
                String parentTableKey = metaTable.getParentKey();
                TableGroupProp parentTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(parentTableKey);
                if (parentTableGroupProp != null) {
                    TableGroupType parentType = parentTableGroupProp.getFixedType();
                    while (parentType != TableGroupType.DetailTableInGroupByDetailTable) {
                        poid = (Long)dbm.getCacheDBRequest().getValueFromCacheTableByOID(parentTableKey, poid, "POID");
                        MetaTable parentMetaTable = DataObjects.getMetaTableByTableNameIgnoreCase(dataObject, parentTableKey);
                        parentTableKey = parentMetaTable.getParentKey();
                        parentTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(parentTableKey);
                        parentType = parentTableGroupProp.getFixedType();
                    }
                }
                Group group = parentTableGroupProp.getGroup();
                OneGroupValue groupValue = InsertDSNTableNameCalc.getOneGroupValue(poid, dbm, group, parentTableKey);
                result = new DSNTableName(group.getDSNName(parentTableKey, groupValue));
                break;
            }
            if (type != TableGroupType.OtherDetailTableInGroupByDetailTable || !(result = DSNTableName.getDSNTableNameNewValue(oidPool.getDSNTableName(soid, headTableGroupProp = TableGroupProps.getInstance().getTableGroupProp(headTableName)))).isDsnNameEmpty()) break;
            result = InsertDSNTableNameCalc.calcDSNTableNameHeadTableBySOID(soid, dbm, headTableGroupProp);
            break;
        }
        return result;
    }

    public static boolean checkOIDInTable(IDBManager dbManager, String tableName, Long oid) throws Throwable {
        String sql = "SELECT OID FROM " + tableName + " WHERE " + "OID" + "=?";
        DataTable dataTable = dbManager.execPrepareQuery(sql, new Object[]{oid});
        return dataTable != null && dataTable.size() > 0;
    }

    private static OneGroupValue getOneGroupValue(Long oid, IDBManager dbm, Group group, String groupTableName) throws Throwable {
        GroupTable groupTable = group.getDefTableNams().get(groupTableName);
        String[] columnNames = groupTable.getGroupColumnNames();
        List<GroupField> groupFields = group.getGroupFields();
        OneGroupValue result = new OneGroupValue();
        int i = 0;
        int size = groupFields.size();
        while (i < size) {
            Object value = columnNames[i] != null ? dbm.getCacheDBRequest().getValueFromCacheTableByOID(groupTableName, oid, columnNames[i]) : group.getGroupFieldValueByRelationTables(groupTableName, groupFields.get(i), result);
            result.setGroupValue(groupFields.get(i).getKey(), value);
            ++i;
        }
        return result;
    }

    private static DSNTableName calcDSNTableNameDataObjectRelationTable(SqlInfo sqlInfo, Parameters parameters, String tableName, OIDPool oidPool, IDBManager dbm) throws Throwable {
        DataObjectRelationTable dataObjectRelationTable = GroupConfig.instance.getDataObjectRelationTable(tableName);
        DSNTableName dsnTableName = new DSNTableName();
        for (RefDataObject refDataObject : dataObjectRelationTable.getRefDataObjects()) {
            Long soid;
            String refSOIDColumnName = refDataObject.refSOIDColumnName;
            String refKeyColumnName = refDataObject.refKeyColumnName;
            if (!sqlInfo.hasGroupNewValue(refSOIDColumnName) || (soid = TypeConvertor.toLong((Object)sqlInfo.getPrimaryKeyNewValue(refSOIDColumnName, parameters))) <= 0L) continue;
            String dataObjectKey = refDataObject.refKey;
            if (dataObjectKey == null || dataObjectKey.length() == 0) {
                if (!sqlInfo.hasGroupNewValue(refKeyColumnName)) continue;
                dataObjectKey = (String)sqlInfo.getPrimaryKeyNewValue(refKeyColumnName, parameters);
            }
            if (dataObjectKey == null || dataObjectKey.length() == 0) {
                throw new RuntimeException("\u5206\u5e93\u9519\u8bef\uff0c\u6570\u636e\u5bf9\u8c61\u5173\u7cfb\u8868\u7684\u67e5\u8be2\u8bed\u53e5\u6709SOID\u503c\uff0c\u4f46\u6ca1\u6709\u6307\u5b9a\u6570\u636e\u5bf9\u8c61\u6807\u8bc6\u3002" + sqlInfo);
            }
            DeleteDSNTableNameCalc.calcDSNTableNameDataObjectRelationTable(oidPool, dsnTableName, dataObjectKey, soid, dbm);
            if (!dsnTableName.isDsnNameEmpty()) continue;
            dsnTableName = InsertDSNTableNameCalc.calcDSNTableNameHeadTableBySOID(soid, dbm, DeleteDSNTableNameCalc.getHeadTableGroupProp(dataObjectKey));
        }
        return dsnTableName;
    }
}

