/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.debug;

import com.bokesoft.yes.mid.mysqls.debug.DebugEntity;
import com.bokesoft.yes.mid.mysqls.debug.DebugRow;
import com.bokesoft.yes.mid.mysqls.debug.EResultTextType;
import java.util.HashMap;

public class DebugService {
    private static DebugService instance = new DebugService();
    private HashMap<Long, DebugEntity> debugEntities = new HashMap();

    private DebugService() {
    }

    public Long begin() {
        Long id = this.getCurrentID();
        this.debugEntities.put(id, new DebugEntity());
        return id;
    }

    public void recordInfoIfNeed(String key, Object result, EResultTextType resultTextType, Object ... paras) {
        if (this.isDebuging()) {
            StringBuilder sb = new StringBuilder();
            if (result instanceof Object[]) {
                Object[] tmps;
                Object[] objectArray = tmps = (Object[])result;
                int n = tmps.length;
                int n2 = 0;
                while (n2 < n) {
                    Object tmp = objectArray[n2];
                    sb.append(tmp.toString());
                    ++n2;
                }
            } else {
                sb.append(result.toString());
            }
            this.getCurrentDebugEntity().addDebugRow(new DebugRow(key, sb.toString(), paras, resultTextType));
        }
    }

    public String getCurrentDebugText() {
        return this.getCurrentDebugEntity().toDebugText();
    }

    public void end(Long id) {
        this.debugEntities.remove(id);
    }

    private DebugEntity getCurrentDebugEntity() {
        return this.debugEntities.get(this.getCurrentID());
    }

    private boolean isDebuging() {
        return this.debugEntities.containsKey(this.getCurrentID());
    }

    private Long getCurrentID() {
        return Thread.currentThread().getId();
    }

    public static DebugService getInstance() {
        return instance;
    }
}

