/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.mysqls.dbstruct;

import com.bokesoft.erp.mid.schema.ERPSchemaProcess;
import com.bokesoft.erp.mid.schema.ERPSchemaViewDependSchemaTable;
import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.mid.base.CoreSetting;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.dbmanager.mysqls.MultiDBManager;
import com.bokesoft.yes.mid.connection.util.SystemTables;
import com.bokesoft.yes.mid.mysqls.dbstruct.RuntimeDDL;
import com.bokesoft.yes.mid.mysqls.group.OneOrMultiValue;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.resultset.ResultSetUtil;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.mid.connection.IDBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.NotImplementedException;

public class DBStruct {
    private static Map<String, HashMapIgnoreCase<HashMapIgnoreCase<String>>> confirmedDatas;
    private static Map<String, HashMapIgnoreCase<String>> confirmedViews;
    private static Map<String, HashMapIgnoreCase<HashMapIgnoreCase<String>>> confirmedIndexes;
    private Map<String, HashMapIgnoreCase<String>> reloadTablesInTransaction;
    private static Map<String, HashMapIgnoreCase<String>> ensureViewNames;
    private static Map<String, HashMapIgnoreCase<String>> ensureTableNames;
    private final MultiDBManager dbManager;

    public DBStruct(MultiDBManager dbManager) {
        this.dbManager = dbManager;
    }

    private static void ensureLoadOneDSN(String dsnName) throws SQLException {
        HashMapIgnoreCase<HashMapIgnoreCase<String>> result;
        if (confirmedDatas == null) {
            confirmedDatas = Collections.synchronizedMap(new HashMap());
            confirmedViews = Collections.synchronizedMap(new HashMap());
            confirmedIndexes = Collections.synchronizedMap(new HashMap());
        }
        if ((result = confirmedDatas.get(dsnName)) != null) {
            return;
        }
        int dbType = MdbDSNItems.instance.getDSNItem(dsnName).getDBType();
        switch (dbType) {
            case 4: {
                DBStruct.ensureLoadOneDSNMySQL(dsnName);
                break;
            }
            case 8: {
                DBStruct.ensureLoadOneDSNDM(dsnName);
                break;
            }
            default: {
                throw new NotImplementedException("Code is not implemented");
            }
        }
    }

    private static void ensureLoadOneDSNMySQL(String dsnName) throws SQLException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        HashMapIgnoreCase result = new HashMapIgnoreCase();
        try {
            int action;
            connection = MultiDBManager.getJDBCConnection(dsnName);
            String catalog = connection.getCatalog();
            String sql = "select TABLE_NAME, COLUMN_NAME from information_schema.COLUMNS where TABLE_SCHEMA = ? and TABLE_NAME in (select TABLE_NAME from information_schema.TABLES where TABLE_SCHEMA = ? and table_type != 'VIEW') ORDER BY TABLE_NAME";
            try {
                statement = connection.prepareStatement(sql);
                statement.setString(1, catalog);
                statement.setString(2, catalog);
                Object[] actions = new Object[]{dsnName, ": ", sql, ";#0:", catalog, " #1:", catalog};
                action = Performance.startAction((Object[])actions);
                resultSet = statement.executeQuery();
                Performance.endActive((int)action, (Object[])actions);
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String columnName = resultSet.getString(2);
                    HashMapIgnoreCase table = (HashMapIgnoreCase)result.get(tableName);
                    if (table == null) {
                        table = new HashMapIgnoreCase();
                        result.put(tableName, (Object)table);
                    }
                    table.put(columnName, (Object)columnName);
                }
                confirmedDatas.put(dsnName, (HashMapIgnoreCase<HashMapIgnoreCase<String>>)result);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            HashMapIgnoreCase views = new HashMapIgnoreCase();
            sql = "select TABLE_NAME from information_schema.TABLES where TABLE_SCHEMA = ? and table_type = 'VIEW'";
            try {
                statement = connection.prepareStatement(sql);
                statement.setString(1, catalog);
                action = Performance.startAction((Object[])new Object[]{dsnName, ": ", sql, ";#0:", catalog});
                resultSet = statement.executeQuery();
                Performance.endActive((int)action, (Object[])new Object[0]);
                while (resultSet.next()) {
                    String viewName = resultSet.getString(1);
                    views.put(viewName, (Object)viewName);
                }
                confirmedViews.put(dsnName, (HashMapIgnoreCase<String>)views);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            HashMapIgnoreCase indexesOneDSN = new HashMapIgnoreCase();
            sql = "select TABLE_NAME, INDEX_NAME from information_schema.STATISTICS where TABLE_SCHEMA = ? ORDER BY TABLE_NAME";
            try {
                statement = connection.prepareStatement(sql);
                statement.setString(1, catalog);
                int action2 = Performance.startAction((Object[])new Object[]{dsnName, ": ", sql, ";#0:", catalog});
                resultSet = statement.executeQuery();
                Performance.endActive((int)action2, (Object[])new Object[0]);
                while (resultSet.next()) {
                    String tableNameTmp = resultSet.getString(1);
                    String indexName = resultSet.getString(2);
                    HashMapIgnoreCase table = (HashMapIgnoreCase)indexesOneDSN.get(tableNameTmp);
                    if (table == null) {
                        table = new HashMapIgnoreCase();
                        indexesOneDSN.put(tableNameTmp, (Object)table);
                    }
                    table.put(indexName, (Object)indexName);
                }
                confirmedIndexes.put(dsnName, (HashMapIgnoreCase<HashMapIgnoreCase<String>>)indexesOneDSN);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static void ensureLoadOneDSNDM(String dsnName) throws SQLException {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        HashMapIgnoreCase result = new HashMapIgnoreCase();
        try {
            int action;
            connection = MultiDBManager.getJDBCConnection(dsnName);
            String sql = "select user_tab_columns.table_name as table_name, user_tab_columns.column_name as column_name from user_tab_columns join user_tables on user_tables.table_Name = user_tab_columns.table_Name order by table_name";
            try {
                statement = connection.prepareStatement(sql);
                Object[] actions = new Object[]{dsnName, ": ", sql};
                action = Performance.startAction((Object[])actions);
                resultSet = statement.executeQuery();
                Performance.endActive((int)action, (Object[])actions);
                while (resultSet.next()) {
                    String tableName = resultSet.getString(1);
                    String columnName = resultSet.getString(2);
                    HashMapIgnoreCase table = (HashMapIgnoreCase)result.get(tableName);
                    if (table == null) {
                        table = new HashMapIgnoreCase();
                        result.put(tableName, (Object)table);
                    }
                    table.put(columnName, (Object)columnName);
                }
                confirmedDatas.put(dsnName, (HashMapIgnoreCase<HashMapIgnoreCase<String>>)result);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            HashMapIgnoreCase views = new HashMapIgnoreCase();
            sql = "select view_name from user_views";
            try {
                statement = connection.prepareStatement(sql);
                action = Performance.startAction((Object[])new Object[]{dsnName, ": ", sql});
                resultSet = statement.executeQuery();
                Performance.endActive((int)action, (Object[])new Object[0]);
                while (resultSet.next()) {
                    String viewName = resultSet.getString(1);
                    views.put(viewName, (Object)viewName);
                }
                confirmedViews.put(dsnName, (HashMapIgnoreCase<String>)views);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            HashMapIgnoreCase indexesOneDSN = new HashMapIgnoreCase();
            sql = "select table_name, index_name from user_indexes ORDER BY table_name";
            try {
                statement = connection.prepareStatement(sql);
                int action2 = Performance.startAction((Object[])new Object[]{dsnName, ": ", sql});
                resultSet = statement.executeQuery();
                Performance.endActive((int)action2, (Object[])new Object[0]);
                while (resultSet.next()) {
                    String tableNameTmp = resultSet.getString(1);
                    String indexName = resultSet.getString(2);
                    HashMapIgnoreCase table = (HashMapIgnoreCase)indexesOneDSN.get(tableNameTmp);
                    if (table == null) {
                        table = new HashMapIgnoreCase();
                        indexesOneDSN.put(tableNameTmp, (Object)table);
                    }
                    table.put(indexName, (Object)indexName);
                }
                confirmedIndexes.put(dsnName, (HashMapIgnoreCase<HashMapIgnoreCase<String>>)indexesOneDSN);
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private static HashMapIgnoreCase<HashMapIgnoreCase<String>> getComfirmedTables(String dsnName) throws SQLException {
        DBStruct.ensureLoadOneDSN(dsnName);
        HashMapIgnoreCase<HashMapIgnoreCase<String>> result = confirmedDatas.get(dsnName);
        return result;
    }

    public static HashMapIgnoreCase<String> getComfirmedColumns(String dsnName, String tableName) throws SQLException {
        return (HashMapIgnoreCase)DBStruct.getComfirmedTables(dsnName).get(tableName);
    }

    private boolean hasView(String dsnName, String ViewName) throws SQLException {
        DBStruct.ensureLoadOneDSN(dsnName);
        return confirmedViews.get(dsnName).containsKey(ViewName);
    }

    public static boolean existComfirmedColumn(String dsnName, String tableName, String columnName) throws SQLException {
        HashMapIgnoreCase<String> columnNames = DBStruct.getComfirmedColumns(dsnName, tableName);
        return columnNames != null ? columnNames.containsKey(columnName) : false;
    }

    public static boolean existComfirmedColumn(OneOrMultiValue<String> dsnNames, String tableName, String columnName) throws SQLException {
        for (String dsnName : dsnNames) {
            HashMapIgnoreCase<String> columnNames = DBStruct.getComfirmedColumns(dsnName, tableName);
            if (columnNames == null || !columnNames.containsKey(columnName)) continue;
            return true;
        }
        return false;
    }

    public static HashMapIgnoreCase<String> getConfirmedIndexes(String dsnName, String tableName) throws SQLException {
        DBStruct.ensureLoadOneDSN(dsnName);
        HashMapIgnoreCase<HashMapIgnoreCase<String>> indexesOneDSN = confirmedIndexes.get(dsnName);
        return (HashMapIgnoreCase)indexesOneDSN.get(tableName);
    }

    public boolean existTableName(String dsnName, String tableName) throws SQLException {
        if (SystemTables.isSystemTable(tableName)) {
            return true;
        }
        if (DBStruct.getComfirmedColumns(dsnName, tableName) != null) {
            return true;
        }
        this.reloadTableStruct(dsnName, tableName);
        return DBStruct.getComfirmedColumns(dsnName, tableName) != null;
    }

    public boolean existTableName(OneOrMultiValue<String> dsnNames, String tableName) throws SQLException {
        for (String dsnName : dsnNames) {
            if (!this.existTableName(dsnName, tableName)) continue;
            return true;
        }
        return false;
    }

    public boolean existTableOrViewName(String dsnName, String tableOrViewName) throws SQLException {
        if (SystemTables.isSystemTable(tableOrViewName)) {
            return true;
        }
        if (DBStruct.getComfirmedColumns(dsnName, tableOrViewName) != null || this.hasView(dsnName, tableOrViewName)) {
            return true;
        }
        this.reloadTableStruct(dsnName, tableOrViewName);
        return DBStruct.getComfirmedColumns(dsnName, tableOrViewName) != null || this.hasView(dsnName, tableOrViewName);
    }

    public boolean existTableName(String dsnName, List<String> tableNames) throws SQLException {
        int i = 0;
        while (i < tableNames.size()) {
            String tableName = tableNames.get(i);
            if (tableName != null && !this.existTableName(dsnName, tableName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean existTableOrViewName(String dsnName, List<String> tableOrViewNames) throws SQLException {
        int i = 0;
        while (i < tableOrViewNames.size()) {
            String tableOrViewName = tableOrViewNames.get(i);
            if (tableOrViewName != null && !this.existTableOrViewName(dsnName, tableOrViewName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean reloadTableStruct(String dsnName, String tableName) throws SQLException {
        HashMapIgnoreCase tables;
        if (this.reloadTablesInTransaction == null) {
            this.reloadTablesInTransaction = Collections.synchronizedMap(new HashMap());
        }
        if ((tables = this.reloadTablesInTransaction.get(dsnName)) != null && tables.containsKey(tableName)) {
            return false;
        }
        boolean result = this.reloadTableStructNoCache(dsnName, tableName);
        if (tables == null) {
            tables = new HashMapIgnoreCase();
            this.reloadTablesInTransaction.put(dsnName, (HashMapIgnoreCase<String>)tables);
        }
        tables.put(tableName, (Object)tableName);
        return result;
    }

    public boolean reloadTableStructNoCache(String dsnName, String tableName) throws SQLException {
        int dbType = MdbDSNItems.instance.getDSNItem(dsnName).getDBType();
        switch (dbType) {
            case 4: {
                this.reloadTableStructMySql(dsnName, tableName);
                break;
            }
            case 8: {
                this.reloadTableStructDM(dsnName, tableName);
                break;
            }
            default: {
                throw new NotImplementedException("Code is not implemented");
            }
        }
        return true;
    }

    private boolean reloadTableStructMySql(String dsnName, String tableName) throws SQLException {
        int action;
        Connection connection = this.dbManager.getConnectionByDSNName(dsnName);
        String catalog = connection.getCatalog();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String tableExistCheckSql = "select table_type from information_schema.TABLES where UPPER(TABLE_NAME) = ? and TABLE_SCHEMA = ?";
            statement = connection.prepareStatement(tableExistCheckSql, 1004, 1007);
            statement.setString(1, tableName.toUpperCase());
            statement.setString(2, catalog);
            Object[] actions = new Object[]{dsnName, ": ", tableExistCheckSql, ";#0:", tableName.toUpperCase(), " #1:", catalog};
            action = Performance.startAction((Object[])actions);
            resultSet = statement.executeQuery();
            Performance.endActive((int)action, (Object[])actions);
            if (!resultSet.first()) {
                return false;
            }
            if ("VIEW".equalsIgnoreCase(resultSet.getString(1))) {
                confirmedViews.get(dsnName).put(tableName, (Object)tableName);
                return true;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        String sqlCol = this.dbManager.getColumnCheckSql();
        String sqlIndex = this.dbManager.getIndexCheckSql();
        try {
            statement = connection.prepareStatement(sqlCol, 1004, 1007);
            statement.setString(1, tableName.toUpperCase());
            statement.setString(2, catalog);
            action = Performance.startAction((Object[])new Object[]{dsnName, ": ", sqlCol, ";#0:", tableName.toUpperCase(), " #1:", catalog});
            resultSet = statement.executeQuery();
            Performance.endActive((int)action, (Object[])new Object[0]);
            if (ResultSetUtil.getRowCount(resultSet) > 0) {
                HashMapIgnoreCase columns = new HashMapIgnoreCase();
                resultSet.beforeFirst();
                while (resultSet.next()) {
                    String columnName = resultSet.getString(1);
                    columns.put(columnName, (Object)columnName);
                }
                confirmedDatas.get(dsnName).put(tableName, (Object)columns);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        try {
            statement = connection.prepareStatement(sqlIndex, 1004, 1007);
            statement.setString(1, tableName.toUpperCase());
            statement.setString(2, catalog);
            action = Performance.startAction((Object[])new Object[]{dsnName, ": ", sqlIndex, ";#0:", tableName.toUpperCase(), " #1:", catalog});
            Performance.endActive((int)action, (Object[])new Object[0]);
            resultSet = statement.executeQuery();
            if (ResultSetUtil.getRowCount(resultSet) > 0) {
                HashMapIgnoreCase indexes = new HashMapIgnoreCase();
                resultSet.beforeFirst();
                while (resultSet.next()) {
                    String indexName = resultSet.getString(1);
                    indexes.put(indexName, (Object)indexName);
                }
                confirmedIndexes.get(dsnName).put(tableName, (Object)indexes);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return true;
    }

    private boolean reloadTableStructDM(String dsnName, String tableName) throws SQLException {
        int action;
        Connection connection = this.dbManager.getConnectionByDSNName(dsnName);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            String tableExistCheckSql = "select table_name from user_tables where table_name = ?;";
            statement = connection.prepareStatement(tableExistCheckSql, 1004, 1007);
            statement.setString(1, tableName);
            Object[] actions = new Object[]{dsnName, ": ", tableExistCheckSql, ";#0:", tableName};
            action = Performance.startAction((Object[])actions);
            resultSet = statement.executeQuery();
            Performance.endActive((int)action, (Object[])actions);
            if (!resultSet.first()) {
                return false;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        String sqlCol = this.dbManager.getColumnCheckSql();
        String sqlIndex = this.dbManager.getIndexCheckSql();
        try {
            statement = connection.prepareStatement(sqlCol, 1004, 1007);
            statement.setString(1, tableName.toUpperCase());
            action = Performance.startAction((Object[])new Object[]{dsnName, ": ", sqlCol, ";#0:", tableName.toUpperCase()});
            resultSet = statement.executeQuery();
            Performance.endActive((int)action, (Object[])new Object[0]);
            if (ResultSetUtil.getRowCount(resultSet) > 0) {
                HashMapIgnoreCase columns = new HashMapIgnoreCase();
                resultSet.beforeFirst();
                while (resultSet.next()) {
                    String columnName = resultSet.getString(1);
                    columns.put(columnName, (Object)columnName);
                }
                confirmedDatas.get(dsnName).put(tableName, (Object)columns);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        try {
            statement = connection.prepareStatement(sqlIndex, 1004, 1007);
            statement.setString(1, tableName.toUpperCase());
            action = Performance.startAction((Object[])new Object[]{dsnName, ": ", sqlIndex, ";#0:", tableName.toUpperCase()});
            resultSet = statement.executeQuery();
            Performance.endActive((int)action, (Object[])new Object[0]);
            if (ResultSetUtil.getRowCount(resultSet) > 0) {
                HashMapIgnoreCase indexes = new HashMapIgnoreCase();
                resultSet.beforeFirst();
                while (resultSet.next()) {
                    String indexName = resultSet.getString(1);
                    indexes.put(indexName, (Object)indexName);
                }
                confirmedIndexes.get(dsnName).put(tableName, (Object)indexes);
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
            if (resultSet != null) {
                resultSet.close();
            }
        }
        return true;
    }

    public void changeTableStruct(String dsnName, String tableName) throws SQLException {
        if (this.reloadTablesInTransaction == null) {
            return;
        }
        HashMapIgnoreCase<String> tables = this.reloadTablesInTransaction.get(dsnName);
        if (tables == null) {
            return;
        }
        tables.remove(tableName);
    }

    public boolean existColumnName(String dsnName, String tableName, String columnName) throws SQLException {
        if (DBStruct.existComfirmedColumn(dsnName, tableName, columnName)) {
            return true;
        }
        this.reloadTableStruct(dsnName, tableName);
        return DBStruct.existComfirmedColumn(dsnName, tableName, columnName);
    }

    public void ensureTableName(IDBManager dbManager, String dsnName, String tableName, ERPSchemaProcess schemaProcess) throws SQLException {
        HashMapIgnoreCase ensureTableNamesOneDSN;
        if (ensureTableNames == null) {
            ensureTableNames = Collections.synchronizedMap(new HashMap());
        }
        if ((ensureTableNamesOneDSN = ensureTableNames.get(dsnName)) == null) {
            ensureTableNamesOneDSN = new HashMapIgnoreCase();
            ensureTableNames.put(dsnName, (HashMapIgnoreCase<String>)ensureTableNamesOneDSN);
        }
        if (ensureTableNamesOneDSN.containsKey(tableName)) {
            return;
        }
        Object[] actions = new Object[]{"\u786e\u8ba4\u6570\u636e\u5e93\u8868\u7ed3\u6784:", dsnName, tableName};
        int action = Performance.startAction((Object[])actions);
        RuntimeDDL.checkTableStruct(dbManager, dsnName, tableName, this, schemaProcess);
        ensureTableNamesOneDSN.put(tableName, (Object)tableName);
        Performance.endActive((int)action, (Object[])new Object[0]);
    }

    public void ensureViewName(String dsnName, ERPSchemaViewDependSchemaTable views) throws Throwable {
        HashMapIgnoreCase ensureViewNameOneDSN;
        if (ensureViewNames == null) {
            ensureViewNames = Collections.synchronizedMap(new HashMap());
        }
        if ((ensureViewNameOneDSN = ensureViewNames.get(dsnName)) == null) {
            ensureViewNameOneDSN = new HashMapIgnoreCase();
            ensureViewNames.put(dsnName, (HashMapIgnoreCase<String>)ensureViewNameOneDSN);
        }
        RuntimeDDL.checkViewStruct(dsnName, views, (HashMapIgnoreCase<String>)ensureViewNameOneDSN, this);
    }

    public static boolean isExistColumnInTable(String columnName, String tableName) {
        try {
            LinkedHashMapIgnoreCase<MetaColumn> metaColumns = DataObjects.getInstance().getColumnsByTableName(tableName);
            if (metaColumns != null) {
                return metaColumns.containsKey(columnName);
            }
            String defaultDSNName = CoreSetting.getInstance().getDSNCollection().getDefaultDSN().getName();
            return DBStruct.existComfirmedColumn(defaultDSNName, tableName, columnName);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u5206\u5e93\u5206\u8868\uff0c\u5224\u65ad\u8868" + tableName + "\u4e2d\u662f\u5426\u5b58\u5728\u5b57\u6bb5" + columnName + "\u51fa\u9519\u3002", e);
        }
    }
}

