/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.materializedquery;

import com.bokesoft.yes.mid.materializedquery.AndExpression;
import com.bokesoft.yes.mid.materializedquery.WhereExpression;
import com.bokesoft.yes.mid.parameterizedsql.SqlString;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.HashMap;
import java.util.List;

class OrExpression
extends WhereExpression {
    private WhereExpression left = null;
    private WhereExpression right = null;

    public OrExpression(WhereExpression l, WhereExpression r) {
        this.left = l;
        this.right = r;
    }

    @Override
    public SqlString toSQL(boolean tableNamePrefix) throws Throwable {
        boolean isLeftCombination = this.left instanceof AndExpression || this.left instanceof OrExpression;
        boolean isRightCombination = this.right instanceof AndExpression || this.right instanceof OrExpression;
        return new SqlString(128).append(isLeftCombination ? "(" : "").append(this.left.toSQL(tableNamePrefix)).append(isLeftCombination ? ")" : "").append(" or ").append(isRightCombination ? "(" : "").append(this.right.toSQL(tableNamePrefix)).append(isRightCombination ? ")" : "");
    }

    @Override
    public SqlString toSQL(SqlString sqlString, boolean tableNamePrefix) throws Throwable {
        boolean isLeftCombination = this.left instanceof AndExpression || this.left instanceof OrExpression;
        boolean isRightCombination = this.right instanceof AndExpression || this.right instanceof OrExpression;
        sqlString.append(isLeftCombination ? "(" : "");
        this.left.toSQL(sqlString, tableNamePrefix).append(isLeftCombination ? ")" : "").append(" or ").append(isRightCombination ? "(" : "");
        this.right.toSQL(sqlString, tableNamePrefix).append(isRightCombination ? ")" : "");
        return sqlString;
    }

    @Override
    public List<MetaTable> getMetaTables() {
        List<MetaTable> leftTables = this.left.getMetaTables();
        List<MetaTable> rightTables = this.right.getMetaTables();
        if (rightTables.size() == 0) {
            return leftTables;
        }
        int i = 0;
        while (i < rightTables.size()) {
            if (!leftTables.contains(rightTables.get(i))) {
                leftTables.add(rightTables.get(i));
            }
            ++i;
        }
        return leftTables;
    }

    @Override
    boolean isMatch(DataTable dataTable, int rowIndex, boolean isOriginal) throws Throwable {
        return this.left.isMatch(dataTable, rowIndex, isOriginal) || this.right.isMatch(dataTable, rowIndex, isOriginal);
    }

    @Override
    boolean isSame(WhereExpression whereExpression) throws Throwable {
        if (whereExpression instanceof OrExpression) {
            OrExpression tmp = (OrExpression)whereExpression;
            return this.left.isSame(tmp.left) && this.right.isSame(tmp.right);
        }
        return false;
    }

    @Override
    public boolean hasMetaColumnWhereClause(MetaColumn metaColumn) {
        return this.left.hasMetaColumnWhereClause(metaColumn) || this.right.hasMetaColumnWhereClause(metaColumn);
    }

    @Override
    public HashMap<String, MetaColumn> getMetaColumns() throws Throwable {
        HashMap<String, MetaColumn> leftMetaColumns = this.left.getMetaColumns();
        HashMap<String, MetaColumn> rightMetaColumns = this.right.getMetaColumns();
        for (String key : rightMetaColumns.keySet()) {
            if (leftMetaColumns.containsKey(key)) continue;
            leftMetaColumns.put(key, rightMetaColumns.get(key));
        }
        return leftMetaColumns;
    }

    @Override
    public Object getMetaColumnValue(MetaColumn metaColumn) {
        if (this.left.hasMetaColumnWhereClause(metaColumn)) {
            return this.left.getMetaColumnValue(metaColumn);
        }
        return this.right.getMetaColumnValue(metaColumn);
    }

    @Override
    public MetaColumn getMetaColumn() throws Exception {
        throw new Exception("\u4e0d\u5e94\u8be5\u8dd1\u5230\u8fd9\u91cc");
    }
}

