/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.materializedquery;

import com.bokesoft.yes.common.struct.HashMapIgnoreCase;
import com.bokesoft.yes.common.struct.LinkedHashMapIgnoreCase;
import com.bokesoft.yes.common.struct.RefObject;
import com.bokesoft.yes.mid.materializedquery.InitMaterializedQuery;
import com.bokesoft.yes.mid.materializedquery.JoinType;
import com.bokesoft.yes.mid.materializedquery.MQJoinStruct;
import com.bokesoft.yes.mid.materializedquery.MQTableStruct;
import com.bokesoft.yes.mid.materializedquery.MetaMaterializedQuery;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumn;
import com.bokesoft.yigo.meta.schema.MetaSchemaColumnCollection;
import com.bokesoft.yigo.meta.schema.MetaSchemaTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.boke.jsqlparser.expression.BinaryExpression;
import net.boke.jsqlparser.expression.CaseExpression;
import net.boke.jsqlparser.expression.DoubleValue;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.InverseExpression;
import net.boke.jsqlparser.expression.LongValue;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.StringValue;
import net.boke.jsqlparser.expression.WhenClause;
import net.boke.jsqlparser.expression.operators.arithmetic.Addition;
import net.boke.jsqlparser.expression.operators.arithmetic.Division;
import net.boke.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.boke.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.GreaterThan;
import net.boke.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.boke.jsqlparser.expression.operators.relational.MinorThan;
import net.boke.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.boke.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.Join;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SelectExpressionItem;

public class MaterializedQueryStruct {
    private static HashMapIgnoreCase<List<MQTableStruct>> MQTableStructs;
    private static Map<MetaMaterializedQuery, MaterializedQueryStruct> cache;
    public final MetaMaterializedQuery mq;
    final MQTableStruct[] tables;
    public String[] columnNames;
    private MetaSchemaTable schemaTable;
    private MetaTable metaTable;
    private String loadSql;
    private Object[] emptyValues;

    static {
        cache = new HashMap<MetaMaterializedQuery, MaterializedQueryStruct>();
    }

    public static List<MQTableStruct> getMQTableStructs(String tableName) throws Throwable {
        if (MQTableStructs == null) {
            if (InitMaterializedQuery.mq == null) {
                return null;
            }
            HashMapIgnoreCase tmp = new HashMapIgnoreCase();
            MaterializedQueryStruct struct = MaterializedQueryStruct.getStruct(InitMaterializedQuery.mq);
            MQTableStruct[] mQTableStructArray = struct.tables;
            int n = struct.tables.length;
            int n2 = 0;
            while (n2 < n) {
                MQTableStruct tableStruct = mQTableStructArray[n2];
                String tableStructName = tableStruct.tableName;
                ArrayList<MQTableStruct> tableStructs = (ArrayList<MQTableStruct>)tmp.get(tableStructName);
                if (tableStructs == null) {
                    tableStructs = new ArrayList<MQTableStruct>();
                    tmp.put(tableStructName, tableStructs);
                }
                tableStructs.add(tableStruct);
                ++n2;
            }
            MQTableStructs = tmp;
        }
        List result = (List)MQTableStructs.get(tableName);
        return result;
    }

    public static MaterializedQueryStruct getStruct(MetaMaterializedQuery mq) throws Throwable {
        MaterializedQueryStruct result = cache.get((Object)mq);
        if (result == null) {
            result = new MaterializedQueryStruct(mq);
            cache.put(mq, result);
        }
        return result;
    }

    private MaterializedQueryStruct(MetaMaterializedQuery mq) throws Throwable {
        this.mq = mq;
        ArrayList<String> allColumnNamesInSelect = new ArrayList<String>();
        this.tables = MaterializedQueryStruct.parse(this, mq, allColumnNamesInSelect);
        this.columnNames = allColumnNamesInSelect.toArray(new String[allColumnNamesInSelect.size()]);
    }

    public MQTableStruct getTableStruct(String tableName) {
        MQTableStruct[] mQTableStructArray = this.tables;
        int n = this.tables.length;
        int n2 = 0;
        while (n2 < n) {
            MQTableStruct tableStruct = mQTableStructArray[n2];
            if (tableStruct.tableName.equalsIgnoreCase(tableName)) {
                return tableStruct;
            }
            ++n2;
        }
        return null;
    }

    public MQTableStruct[] getTableStructs() {
        return this.tables;
    }

    private static MQTableStruct[] parse(MaterializedQueryStruct mqStruct, MetaMaterializedQuery mq, List<String> allColumnNamesInSelect) throws Throwable {
        allColumnNamesInSelect.add("OID");
        allColumnNamesInSelect.add("VERID");
        String sql = mq.sql;
        Statement statement = SqlInfos.instance.parseSql(sql);
        if (!(statement instanceof Select)) {
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u4e0d\u662f\u67e5\u8be2\u8bed\u53e5\uff0c" + sql);
        }
        SelectBody selectBody = ((Select)statement).getSelectBody();
        if (!(selectBody instanceof PlainSelect)) {
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0cSql\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u53ef\u80fd\u6709Union\u3001Order\u7b49\uff0c" + sql);
        }
        PlainSelect select = (PlainSelect)selectBody;
        FromItem fromItem = select.getFromItem();
        if (!(fromItem instanceof Table)) {
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0cSql\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u4e0d\u652f\u6301\u5b50\u67e5\u8be2\uff0c" + sql);
        }
        Table firstTable = (Table)fromItem;
        List joins = select.getJoins();
        int joinSize = joins == null ? 0 : joins.size();
        MQTableStruct[] tables = new MQTableStruct[joinSize + 1];
        tables[0] = new MQTableStruct(mqStruct, firstTable.getName());
        int i = 0;
        while (i < joinSize) {
            MQTableStruct tableStruct;
            Join join = (Join)joins.get(i);
            FromItem rightItem = join.getRightItem();
            if (!(rightItem instanceof Table)) {
                throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0cSql\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u4e0d\u652f\u6301\u5b50\u67e5\u8be2\uff0c" + sql);
            }
            Table joinTable = (Table)rightItem;
            tables[i + 1] = tableStruct = new MQTableStruct(mqStruct, joinTable.getName());
            tableStruct.tableAliasName = joinTable.getAlias();
            tableStruct.joinType = JoinType.getJoinType(join);
            Expression onExpression = join.getOnExpression();
            MaterializedQueryStruct.parseConditionExpression(tableStruct, onExpression, tables, null);
            ++i;
        }
        Expression whereExpression = select.getWhere();
        MaterializedQueryStruct.parseConditionExpression(null, whereExpression, tables, null);
        List selectItems = select.getSelectItems();
        int i2 = 0;
        int size = selectItems.size();
        while (i2 < size) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItems.get(i2);
            String columnNameInSelect = selectExpressionItem.getAlias();
            Expression expression = selectExpressionItem.getExpression();
            if (expression instanceof Column) {
                MQTableStruct tableStruct = MaterializedQueryStruct.getTableStructByColumn(tables, (Column)expression);
                String columnName = ((Column)expression).getColumnName();
                tableStruct.addSelectColumn(columnName, allColumnNamesInSelect.size());
                if (columnNameInSelect == null) {
                    columnNameInSelect = String.valueOf(tableStruct.tableName) + "_" + columnName;
                }
            } else {
                RefObject tableStructRef = new RefObject(null);
                RefObject lastMetaColumnRef = new RefObject(null);
                String formula = MaterializedQueryStruct.parseSelectExpression((RefObject<MQTableStruct>)tableStructRef, expression, tables, (RefObject<MetaColumn>)lastMetaColumnRef);
                ((MQTableStruct)tableStructRef.getValue()).addSelectFormula(formula, allColumnNamesInSelect.size(), (MetaColumn)lastMetaColumnRef.getValue());
                if (columnNameInSelect == null) {
                    columnNameInSelect = String.valueOf(((MQTableStruct)tableStructRef.getValue()).tableName) + "_" + allColumnNamesInSelect.size();
                }
            }
            allColumnNamesInSelect.add(columnNameInSelect);
            ++i2;
        }
        MaterializedQueryStruct.processJoinColumnNotInSelect(tables, allColumnNamesInSelect);
        MaterializedQueryStruct.processOIDColumn(tables, allColumnNamesInSelect);
        return tables;
    }

    private static String parseSelectExpression(RefObject<MQTableStruct> tableStructRef, Expression exp, MQTableStruct[] tableStructs, RefObject<MetaColumn> lastMetaColumnRef) throws Throwable {
        StringBuilder sb = new StringBuilder(256);
        MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, exp, tableStructs, lastMetaColumnRef);
        if (tableStructRef.getValue() == null) {
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u67e5\u8be2\u8868\u8fbe\u5f0f\u4e0d\u652f\u6301\u7eaf\u5e38\u91cf\uff0c" + exp.toString());
        }
        return sb.toString();
    }

    private static void parseSelectExpression(StringBuilder sb, RefObject<MQTableStruct> tableStructRef, Expression exp, MQTableStruct[] tableStructs, RefObject<MetaColumn> lastMetaColumnRef) throws Throwable {
        if (exp instanceof Column) {
            MQTableStruct tableStruct = MaterializedQueryStruct.getTableStructByColumn(tableStructs, (Column)exp);
            if (tableStructRef.getValue() == null) {
                tableStructRef.setValue((Object)tableStruct);
            } else if (tableStructRef.getValue() != tableStruct) {
                throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u67e5\u8be2\u8868\u8fbe\u5f0f\u4e0d\u652f\u6301\u8de8\u8868\u67e5\u8be2\uff0c" + exp.toString());
            }
            String columnName = ((Column)exp).getColumnName();
            lastMetaColumnRef.setValue((Object)((MetaColumn)DataObjects.getInstance().getColumnsByTableName(tableStruct.tableName).get(columnName)));
            sb.append(columnName);
            tableStruct.addSelectColumnForFormula(columnName);
        } else if (exp instanceof LongValue) {
            sb.append(exp.toString());
        } else if (exp instanceof DoubleValue) {
            sb.append(exp.toString());
        } else if (exp instanceof StringValue) {
            sb.append(exp.toString());
        } else if (exp instanceof Addition) {
            Addition addition = (Addition)exp;
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, addition.getLeftExpression(), tableStructs, lastMetaColumnRef);
            sb.append("+");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, addition.getRightExpression(), tableStructs, lastMetaColumnRef);
        } else if (exp instanceof Subtraction) {
            Subtraction subtraction = (Subtraction)exp;
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, subtraction.getLeftExpression(), tableStructs, lastMetaColumnRef);
            sb.append("-");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, subtraction.getRightExpression(), tableStructs, lastMetaColumnRef);
        } else if (exp instanceof InverseExpression) {
            sb.append("-");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, ((InverseExpression)exp).getExpression(), tableStructs, lastMetaColumnRef);
        } else if (exp instanceof Multiplication) {
            Multiplication multiplication = (Multiplication)exp;
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, multiplication.getLeftExpression(), tableStructs, lastMetaColumnRef);
            sb.append("*");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, multiplication.getRightExpression(), tableStructs, lastMetaColumnRef);
        } else if (exp instanceof Division) {
            Division division = (Division)exp;
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, division.getLeftExpression(), tableStructs, lastMetaColumnRef);
            sb.append("/");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, division.getRightExpression(), tableStructs, lastMetaColumnRef);
        } else if (exp instanceof Parenthesis) {
            sb.append("(");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, ((Parenthesis)exp).getExpression(), tableStructs, lastMetaColumnRef);
            sb.append(")");
        } else if (exp instanceof CaseExpression) {
            CaseExpression caseExpression = (CaseExpression)exp;
            List whenClauses = caseExpression.getWhenClauses();
            if (whenClauses.size() != 1) {
                throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u67e5\u8be2\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c" + exp.toString());
            }
            WhenClause whenClause = (WhenClause)whenClauses.get(0);
            sb.append("IIF(");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, whenClause.getWhenExpression(), tableStructs, lastMetaColumnRef);
            sb.append(",");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, whenClause.getThenExpression(), tableStructs, lastMetaColumnRef);
            sb.append(",");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, caseExpression.getElseExpression(), tableStructs, lastMetaColumnRef);
            sb.append(")");
        } else if (exp instanceof EqualsTo) {
            EqualsTo equalsTo = (EqualsTo)exp;
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, equalsTo.getLeftExpression(), tableStructs, lastMetaColumnRef);
            sb.append("==");
            MaterializedQueryStruct.parseSelectExpression(sb, tableStructRef, equalsTo.getRightExpression(), tableStructs, lastMetaColumnRef);
        } else {
            throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u67e5\u8be2\u8868\u8fbe\u5f0f\u89e3\u6790\u5931\u8d25\uff0c" + exp.toString());
        }
    }

    private static void parseConditionExpression(MQTableStruct tableStruct, Expression expression, MQTableStruct[] tableStructs, Boolean isAndOr) throws Throwable {
        if (expression == null) {
            return;
        }
        if (expression instanceof Parenthesis) {
            MaterializedQueryStruct.parseConditionExpression(tableStruct, ((Parenthesis)expression).getExpression(), tableStructs, isAndOr);
            return;
        }
        if (expression instanceof BinaryExpression) {
            BinaryExpression binaryExp = (BinaryExpression)expression;
            Expression leftExp = binaryExp.getLeftExpression();
            Expression rightExp = binaryExp.getRightExpression();
            if (MaterializedQueryStruct.isConstant(leftExp) && rightExp instanceof Column) {
                Column column = (Column)rightExp;
                MQTableStruct processTableStruct = MaterializedQueryStruct.getTableStructByColumn(tableStructs, column);
                processTableStruct.addExpression(column.getColumnName(), MaterializedQueryStruct.getLeftRightExchangeBinaryOp(MaterializedQueryStruct.getBinaryOp(binaryExp)), MaterializedQueryStruct.getConstantValue(leftExp));
                return;
            }
            if (MaterializedQueryStruct.isConstant(rightExp) && leftExp instanceof Column) {
                Column column = (Column)leftExp;
                MQTableStruct processTableStruct = MaterializedQueryStruct.getTableStructByColumn(tableStructs, column);
                processTableStruct.addExpression(column.getColumnName(), MaterializedQueryStruct.getBinaryOp(binaryExp), MaterializedQueryStruct.getConstantValue(rightExp));
                return;
            }
            if (tableStruct != null && leftExp instanceof Column && rightExp instanceof Column && binaryExp instanceof EqualsTo) {
                Column leftColumn = (Column)leftExp;
                Table leftTable = leftColumn.getTable();
                MQTableStruct leftTableStruct = MaterializedQueryStruct.getTableStructByColumn(tableStructs, leftColumn);
                Column rightColumn = (Column)rightExp;
                Table rightTable = rightColumn.getTable();
                MQTableStruct rightTableStruct = MaterializedQueryStruct.getTableStructByColumn(tableStructs, rightColumn);
                if (leftTableStruct == tableStruct) {
                    MQJoinStruct joinStruct = new MQJoinStruct(leftColumn.getColumnName(), rightTable.getName(), rightColumn.getColumnName());
                    if (isAndOr == null || isAndOr.equals(Boolean.TRUE)) {
                        tableStruct.addAndJoinStruct(joinStruct);
                    } else {
                        tableStruct.addOrJoinStruct(joinStruct);
                    }
                    rightTableStruct.addRefJoinStruct(joinStruct);
                    return;
                }
                if (rightTableStruct == tableStruct) {
                    MQJoinStruct joinStruct = new MQJoinStruct(rightColumn.getColumnName(), leftTable.getName(), leftColumn.getColumnName());
                    if (isAndOr == null || isAndOr.equals(Boolean.TRUE)) {
                        tableStruct.addAndJoinStruct(joinStruct);
                    } else {
                        tableStruct.addOrJoinStruct(joinStruct);
                    }
                    leftTableStruct.addRefJoinStruct(joinStruct);
                    return;
                }
            } else {
                if (expression instanceof AndExpression && !isAndOr.equals(Boolean.FALSE)) {
                    AndExpression andExpression = (AndExpression)expression;
                    MaterializedQueryStruct.parseConditionExpression(tableStruct, andExpression.getLeftExpression(), tableStructs, Boolean.TRUE);
                    MaterializedQueryStruct.parseConditionExpression(tableStruct, andExpression.getRightExpression(), tableStructs, Boolean.TRUE);
                    return;
                }
                if (expression instanceof OrExpression) {
                    OrExpression orExpression = (OrExpression)expression;
                    MaterializedQueryStruct.parseConditionExpression(tableStruct, orExpression.getLeftExpression(), tableStructs, Boolean.FALSE);
                    MaterializedQueryStruct.parseConditionExpression(tableStruct, orExpression.getRightExpression(), tableStructs, Boolean.FALSE);
                    return;
                }
            }
        }
        throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f\uff0c" + expression.toString());
    }

    private static boolean isConstant(Expression exp) {
        return exp instanceof LongValue || exp instanceof DoubleValue || exp instanceof StringValue;
    }

    private static Object getConstantValue(Expression exp) {
        if (exp instanceof LongValue) {
            return ((LongValue)exp).getValue();
        }
        if (exp instanceof DoubleValue) {
            return TypeConvertor.toBigDecimal((Object)((DoubleValue)exp).getValue());
        }
        if (exp instanceof StringValue) {
            return ((StringValue)exp).getValue();
        }
        throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f\uff0c" + exp.toString());
    }

    private static int getBinaryOp(BinaryExpression exp) {
        if (exp instanceof EqualsTo) {
            return 2;
        }
        if (exp instanceof NotEqualsTo) {
            return 5;
        }
        if (exp instanceof GreaterThan) {
            return 4;
        }
        if (exp instanceof GreaterThanEquals) {
            return 1;
        }
        if (exp instanceof MinorThan) {
            return 6;
        }
        if (exp instanceof MinorThanEquals) {
            return 3;
        }
        throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f\uff0c" + exp.toString());
    }

    private static int getLeftRightExchangeBinaryOp(int binaryOp) {
        switch (binaryOp) {
            case 4: {
                return 6;
            }
            case 1: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 3: {
                return 1;
            }
        }
        return binaryOp;
    }

    private static void processJoinColumnNotInSelect(MQTableStruct[] tableStructs, List<String> allColumnNamesInSelect) {
        MQTableStruct[] mQTableStructArray = tableStructs;
        int n = tableStructs.length;
        int n2 = 0;
        while (n2 < n) {
            MQTableStruct tableStruct = mQTableStructArray[n2];
            if (tableStruct.refJoinStructs != null) {
                for (MQJoinStruct joinStruct : tableStruct.refJoinStructs) {
                    String refColumnName = joinStruct.joinColumnName;
                    int columnIndex = tableStruct.getColumnIndex(refColumnName);
                    if (columnIndex < 0) {
                        String columnNameInSelect = String.valueOf(tableStruct.tableName) + "_" + refColumnName;
                        allColumnNamesInSelect.add(columnNameInSelect);
                        columnIndex = allColumnNamesInSelect.size() - 1;
                        tableStruct.addJoinColumnsNotInSelectItem(refColumnName, columnIndex);
                    }
                    joinStruct.joinColumnIndexInSelect = columnIndex;
                }
            }
            ++n2;
        }
    }

    private static void processOIDColumn(MQTableStruct[] tableStructs, List<String> allColumnNamesInSelect) {
        MQTableStruct[] mQTableStructArray = tableStructs;
        int n = tableStructs.length;
        int n2 = 0;
        while (n2 < n) {
            MQTableStruct tableStruct = mQTableStructArray[n2];
            int columnIndex = tableStruct.getColumnIndex("OID");
            if (columnIndex < 0) {
                String columnNameInSelect = String.valueOf(tableStruct.tableName) + "_" + "OID";
                allColumnNamesInSelect.add(columnNameInSelect);
                columnIndex = allColumnNamesInSelect.size() - 1;
            }
            tableStruct.oidColumnIndexInQuery = columnIndex;
            ++n2;
        }
    }

    private static MQTableStruct getTableStructByColumn(MQTableStruct[] tableStructs, Column column) throws Throwable {
        Table table = column.getTable();
        MQTableStruct result = null;
        if (table != null) {
            result = MaterializedQueryStruct.getTableStructByTableName(tableStructs, table.toString());
        } else {
            String columnName = column.getColumnName();
            int i = 0;
            int size = tableStructs.length;
            while (i < size) {
                MQTableStruct tableStruct = tableStructs[i];
                if (tableStruct.hasColumn(columnName)) {
                    if (result == null) {
                        result = tableStruct;
                    } else {
                        throw new RuntimeException("\u7269\u5316\u67e5\u8be2\u8868\u89e3\u6790\u5931\u8d25\uff0c\u67e5\u8be2\u5b57\u6bb5" + columnName + "\u9700\u6307\u5b9a\u8868\u540d\u3002");
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private static MQTableStruct getTableStructByTableName(MQTableStruct[] tableStructs, String tableName) {
        int i = 0;
        int size = tableStructs.length;
        while (i < size) {
            MQTableStruct tableStruct = tableStructs[i];
            if (tableName.equalsIgnoreCase(tableStruct.tableName) || tableName.equalsIgnoreCase(tableStruct.tableAliasName)) {
                return tableStruct;
            }
            ++i;
        }
        return null;
    }

    public MetaSchemaTable getSchemaTable() throws Throwable {
        if (this.schemaTable == null) {
            int columnSize = this.columnNames.length;
            MetaColumn[] types = new MetaColumn[columnSize];
            MQTableStruct[] mQTableStructArray = this.tables;
            int n = this.tables.length;
            int n2 = 0;
            while (n2 < n) {
                int columnIndex;
                int size;
                int i;
                MQTableStruct tableStruct = mQTableStructArray[n2];
                LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(tableStruct.tableName);
                if (tableStruct.selectColumns != null) {
                    i = 0;
                    size = tableStruct.selectColumns.size();
                    while (i < size) {
                        columnIndex = tableStruct.selectColumnIndexes.get(i);
                        types[columnIndex] = (MetaColumn)columns.get(tableStruct.selectColumns.get(i));
                        ++i;
                    }
                }
                if (tableStruct.selectFormulas != null) {
                    i = 0;
                    size = tableStruct.selectFormulas.size();
                    while (i < size) {
                        columnIndex = tableStruct.selectFormulaColumnIndexes.get(i);
                        types[columnIndex] = tableStruct.selectFormulaColumnTypes.get(i);
                        ++i;
                    }
                }
                if (tableStruct.joinColumnsNotInSelectItem != null) {
                    i = 0;
                    size = tableStruct.joinColumnsNotInSelectItem.size();
                    while (i < size) {
                        columnIndex = tableStruct.joinColumnExtendColumnIndexes.get(i);
                        types[columnIndex] = (MetaColumn)columns.get(tableStruct.joinColumnsNotInSelectItem.get(i));
                        ++i;
                    }
                }
                types[tableStruct.oidColumnIndexInQuery] = (MetaColumn)columns.get("OID");
                ++n2;
            }
            MetaSchemaTable result = new MetaSchemaTable();
            result.setKey(this.mq.getKey());
            result.setAutoGen(true);
            MetaSchemaColumnCollection metaSchemaColumnCollection = result.getColumnCollection();
            MetaSchemaColumn column = new MetaSchemaColumn();
            column.setKey("OID");
            column.setDataType(1010);
            metaSchemaColumnCollection.add((KeyPairMetaObject)column);
            column = new MetaSchemaColumn();
            column.setKey("VERID");
            column.setDataType(1010);
            metaSchemaColumnCollection.add((KeyPairMetaObject)column);
            int i = 2;
            while (i < columnSize) {
                MetaColumn type = types[i];
                column = new MetaSchemaColumn();
                column.setKey(this.columnNames[i]);
                column.setDataType(type.getDataType().intValue());
                column.setLength(type.getLength());
                column.setPrecision(type.getPrecision());
                column.setScale(type.getScale());
                metaSchemaColumnCollection.add((KeyPairMetaObject)column);
                ++i;
            }
            column = new MetaSchemaColumn();
            column.setKey("Slock");
            column.setDataType(1010);
            metaSchemaColumnCollection.add((KeyPairMetaObject)column);
            this.schemaTable = result;
        }
        return this.schemaTable;
    }

    public MetaTable getMetaTable() throws Throwable {
        if (this.metaTable == null) {
            MetaTable tmp = new MetaTable();
            tmp.setKey(this.mq.getKey());
            tmp.setPersist(Boolean.valueOf(true));
            MetaSchemaTable schemaTable = this.getSchemaTable();
            for (MetaSchemaColumn metaSchemaColumn : schemaTable.getColumnCollection()) {
                MetaColumn metaColumn = new MetaColumn();
                metaColumn.setKey(metaSchemaColumn.getKey());
                metaColumn.setDataType(Integer.valueOf(metaSchemaColumn.getDataType()));
                metaColumn.setLength(Integer.valueOf(metaSchemaColumn.getLength()));
                metaColumn.setPrecision(Integer.valueOf(metaSchemaColumn.getPrecision()));
                metaColumn.setScale(Integer.valueOf(metaSchemaColumn.getScale()));
                metaColumn.setPersist(Boolean.valueOf(true));
                tmp.add((KeyPairMetaObject)metaColumn);
            }
            this.metaTable = tmp;
        }
        return this.metaTable;
    }

    public String getLoadSql() throws Throwable {
        if (this.loadSql == null) {
            StringBuilder sb = new StringBuilder(1024);
            sb.append("select ");
            MetaSchemaTable schemaTable = this.getSchemaTable();
            for (MetaSchemaColumn metaColumn : schemaTable.getColumnCollection()) {
                sb.append(metaColumn.getKey()).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(" from ").append(this.mq.getKey());
            this.loadSql = sb.toString();
        }
        return this.loadSql;
    }

    public Object[] getEmptyValues() throws Throwable {
        if (this.emptyValues == null) {
            Object[] tmp = new Object[this.columnNames.length];
            tmp[1] = 0;
            MQTableStruct[] mQTableStructArray = this.tables;
            int n = this.tables.length;
            int n2 = 0;
            while (n2 < n) {
                int columnIndex;
                int size;
                int i;
                MQTableStruct tableStruct = mQTableStructArray[n2];
                LinkedHashMapIgnoreCase<MetaColumn> columns = DataObjects.getInstance().getColumnsByTableName(tableStruct.tableName);
                if (tableStruct.selectColumns != null) {
                    i = 0;
                    size = tableStruct.selectColumns.size();
                    while (i < size) {
                        columnIndex = tableStruct.selectColumnIndexes.get(i);
                        tmp[columnIndex] = MQTableStruct.getEmptyValue((MetaColumn)columns.get(tableStruct.selectColumns.get(i)));
                        ++i;
                    }
                }
                if (tableStruct.selectFormulas != null) {
                    i = 0;
                    size = tableStruct.selectFormulas.size();
                    while (i < size) {
                        columnIndex = tableStruct.selectFormulaColumnIndexes.get(i);
                        tmp[columnIndex] = MQTableStruct.getEmptyValue(tableStruct.selectFormulaColumnTypes.get(i));
                        ++i;
                    }
                }
                if (tableStruct.joinColumnsNotInSelectItem != null) {
                    i = 0;
                    size = tableStruct.joinColumnsNotInSelectItem.size();
                    while (i < size) {
                        columnIndex = tableStruct.joinColumnExtendColumnIndexes.get(i);
                        tmp[columnIndex] = MQTableStruct.getEmptyValue((MetaColumn)columns.get(tableStruct.joinColumnsNotInSelectItem.get(i)));
                        ++i;
                    }
                }
                tmp[tableStruct.oidColumnIndexInQuery] = 0L;
                ++n2;
            }
            this.emptyValues = tmp;
        }
        return this.emptyValues;
    }
}

