/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.materializedquery;

import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.materializedquery.DataTableEvalContext;
import com.bokesoft.yes.mid.materializedquery.DataTableParse;
import com.bokesoft.yes.mid.materializedquery.DefaultContextWithDBM;
import com.bokesoft.yes.mid.materializedquery.MQData;
import com.bokesoft.yes.mid.materializedquery.MQTableStruct;
import com.bokesoft.yes.mid.materializedquery.MaterializedQueryStruct;
import com.bokesoft.yes.mid.materializedquery.WhereExpression;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.List;

public class MQGenData {
    private static DataTableParse parser = new DataTableParse();

    public static void genMQData(IDBManager dbManager, MQData mqData, DataTable rstData, String tableName) throws Throwable {
        List<MQTableStruct> tableStructs = MaterializedQueryStruct.getMQTableStructs(tableName);
        if (tableStructs == null || tableStructs.size() == 0) {
            return;
        }
        for (MQTableStruct tableStruct : tableStructs) {
            MQGenData.genMQData(dbManager, mqData, rstData, tableName, tableStruct);
        }
    }

    private static void genMQData(IDBManager dbManager, MQData mqData, DataTable dataTable, String tableName, MQTableStruct tableStruct) throws Throwable {
        int size = dataTable.size();
        if (size == 0) {
            return;
        }
        ArrayList<Integer> insertRowIndexes = new ArrayList<Integer>(size);
        ArrayList<Integer> deleteRowIndexes = new ArrayList<Integer>(size);
        ArrayList<Integer> updateRowIndexes = new ArrayList<Integer>(size);
        MQGenData.classifyInsertUpdateDelete(dataTable, tableStruct, insertRowIndexes, deleteRowIndexes, updateRowIndexes);
        MQGenData.loadMQData(dbManager, mqData, dataTable, tableStruct, insertRowIndexes, deleteRowIndexes, updateRowIndexes);
        if (insertRowIndexes.size() > 0) {
            MQGenData.genInsertData(dbManager, mqData, dataTable, tableStruct, insertRowIndexes);
        }
        if (deleteRowIndexes.size() > 0) {
            MQGenData.genDeleteData(mqData, dataTable, tableStruct, deleteRowIndexes);
        }
        if (updateRowIndexes.size() > 0) {
            MQGenData.genUpdateData(mqData, dataTable, tableStruct, updateRowIndexes);
        }
    }

    private static void genUpdateData(MQData mqData, DataTable dataTable, MQTableStruct tableStruct, List<Integer> updateRowIndexes) throws Throwable {
        String oidColumnNameInQuery = tableStruct.mqStruct.columnNames[tableStruct.oidColumnIndexInQuery];
        int oidColumnIndex = dataTable.getMetaData().findColumnIndexByKey("OID");
        for (int rowIndex : updateRowIndexes) {
            int[] mqDataRowIndexes;
            Long oid = (Long)dataTable.getOriginalObject(rowIndex, oidColumnIndex);
            int[] nArray = mqDataRowIndexes = mqData.data.fastFilter(oidColumnNameInQuery, (Object)oid);
            int n = mqDataRowIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int mqDataRowIndex = nArray[n2];
                Row row = mqData.data.getRowByIndex(mqDataRowIndex);
                DataTableExUtil.prepareUpdate(row);
                MQGenData.setNewRowData(dataTable, tableStruct, rowIndex, row.getDataList());
                ++n2;
            }
        }
    }

    private static void genDeleteData(MQData mqData, DataTable dataTable, MQTableStruct tableStruct, List<Integer> deleteRowIndexes) throws Throwable {
        int n;
        int n2;
        Object object;
        String oidColumnNameInQuery = tableStruct.mqStruct.columnNames[tableStruct.oidColumnIndexInQuery];
        int oidColumnIndex = dataTable.getMetaData().findColumnIndexByKey("OID");
        for (int rowIndex : deleteRowIndexes) {
            Long oid = (Long)dataTable.getOriginalObject(rowIndex, oidColumnIndex);
            int[] mqDataRowIndexes = mqData.data.fastFilter(oidColumnNameInQuery, (Object)oid);
            object = mqDataRowIndexes;
            n2 = mqDataRowIndexes.length;
            n = 0;
            while (n < n2) {
                int[] joinColumnIndexesInQuery;
                Object[] mqDataRowIndex = object[n];
                Object[] mqDataValues = mqData.data.getRowByIndex((int)mqDataRowIndex).getDataList();
                boolean isEmpty = true;
                int[] nArray = joinColumnIndexesInQuery = tableStruct.getParentJoinColumnIndexes();
                int n3 = joinColumnIndexesInQuery.length;
                int n4 = 0;
                while (n4 < n3) {
                    int joinColumnIndex = nArray[n4];
                    if (!mqDataValues[joinColumnIndex].equals(0L)) {
                        isEmpty = false;
                        break;
                    }
                    ++n4;
                }
                if (isEmpty) {
                    mqData.data.delete((int)mqDataRowIndex);
                } else {
                    Object[] emptyValues = tableStruct.getEmptyValues();
                    int i = 0;
                    int emptyValueSize = emptyValues.length;
                    while (i < emptyValueSize) {
                        if (emptyValues[i] != null) {
                            mqDataValues[i] = emptyValues[i];
                        }
                        ++i;
                    }
                }
                ++n;
            }
        }
        String[] columnNames = tableStruct.getJoinColumnNames();
        if (columnNames != null) {
            DataTable deleteDataTable = DataTableExUtil.subDataTable(dataTable, deleteRowIndexes);
            Object[][] groupValues = deleteDataTable.fastDistinctValues(columnNames);
            String[] columnNamesInQuery = tableStruct.getJoinRefColumnNamesInQuery();
            object = groupValues;
            n2 = groupValues.length;
            n = 0;
            while (n < n2) {
                Object[] groupValue = object[n];
                int[] mqDataRowIndexes = mqData.data.fastFilter(columnNamesInQuery, groupValue);
                int i = 1;
                int mqDataRowIndexSize = mqDataRowIndexes.length;
                while (i < mqDataRowIndexSize) {
                    mqData.data.delete(mqDataRowIndexes[i]);
                    ++i;
                }
                ++n;
            }
        }
    }

    private static void genInsertData(IDBManager dbManager, MQData mqData, DataTable dataTable, MQTableStruct tableStruct, List<Integer> insertRowIndexes) throws Throwable {
        String[] columnNames = tableStruct.getJoinColumnNames();
        if (columnNames.length == 0) {
            for (int rowIndex : insertRowIndexes) {
                Long newOID = new DefaultContextWithDBM(dbManager).applyNewOID();
                Object[] newRowData = mqData.newRow(tableStruct.mqStruct, newOID);
                MQGenData.setNewRowData(dataTable, tableStruct, rowIndex, newRowData);
            }
        } else {
            DataTable insertDataTable = DataTableExUtil.subDataTable(dataTable, insertRowIndexes);
            Object[][] groupValues = insertDataTable.fastDistinctValues(columnNames);
            String[] refColumnNamesInQuery = tableStruct.getJoinRefColumnNamesInQuery();
            Object[][] objectArray = groupValues;
            int n = groupValues.length;
            int n2 = 0;
            while (n2 < n) {
                Object[] groupValue = objectArray[n2];
                int[] mqDataRowIndexes = mqData.data.fastFilter(refColumnNamesInQuery, groupValue);
                int[] rowIndexes = insertDataTable.fastFilter(columnNames, groupValue);
                int[] nArray = mqDataRowIndexes;
                int n3 = mqDataRowIndexes.length;
                int n4 = 0;
                while (n4 < n3) {
                    int mqDataRowIndex = nArray[n4];
                    if (rowIndexes.length == 1) {
                        Row row = mqData.data.getRowByIndex(mqDataRowIndex);
                        DataTableExUtil.prepareUpdate(row);
                        MQGenData.setNewRowData(dataTable, tableStruct, rowIndexes[0], row.getDataList());
                    } else {
                        Long[] newOIDs = new DefaultContextWithDBM(dbManager).applyNewOID(rowIndexes.length - 1);
                        DataTableExUtil.prepareUpdate(mqData.data.getRowByIndex(mqDataRowIndex));
                        Object[][] copyNewRowDatas = mqData.copyRow(mqDataRowIndex, rowIndexes.length, newOIDs);
                        int i = 0;
                        int rowIndexSize = rowIndexes.length;
                        while (i < rowIndexSize) {
                            MQGenData.setNewRowData(dataTable, tableStruct, rowIndexes[i], copyNewRowDatas[i]);
                            ++i;
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private static void setNewRowData(DataTable dataTable, MQTableStruct tableStruct, int rowIndex, Object[] newRowData) throws Throwable {
        int columnSize;
        if (tableStruct.selectColumns != null) {
            int i = 0;
            columnSize = tableStruct.selectColumns.size();
            while (i < columnSize) {
                newRowData[tableStruct.selectColumnIndexes.get((int)i).intValue()] = dataTable.getObject(rowIndex, tableStruct.selectColumns.get(i));
                ++i;
            }
        }
        if (tableStruct.selectFormulas != null) {
            DataTableEvalContext evalContext = new DataTableEvalContext(dataTable, rowIndex);
            int i = 0;
            int columnSize2 = tableStruct.selectFormulas.size();
            while (i < columnSize2) {
                Object value;
                newRowData[tableStruct.selectFormulaColumnIndexes.get((int)i).intValue()] = value = parser.eval(tableStruct.selectFormulas.get(i), evalContext);
                ++i;
            }
        }
        if (tableStruct.joinColumnsNotInSelectItem != null) {
            int i = 0;
            columnSize = tableStruct.joinColumnsNotInSelectItem.size();
            while (i < columnSize) {
                newRowData[tableStruct.joinColumnExtendColumnIndexes.get((int)i).intValue()] = dataTable.getObject(rowIndex, tableStruct.joinColumnsNotInSelectItem.get(i));
                ++i;
            }
        }
    }

    private static void loadMQData(IDBManager dbManager, MQData mqData, DataTable dataTable, MQTableStruct tableStruct, List<Integer> insertRowIndexes, List<Integer> deleteRowIndexes, List<Integer> updateRowIndexes) throws Throwable {
        String[] columnNames;
        Long oid;
        Long soid;
        int oidColumnIndex = dataTable.getMetaData().findColumnIndexByKey("OID");
        int soidColumnIndex = dataTable.getMetaData().findColumnIndexByKey("SOID");
        if (insertRowIndexes.size() > 0 && tableStruct.andJoinStructs != null) {
            ArrayList<Integer> insertLoadRowIndexes = new ArrayList<Integer>(insertRowIndexes.size());
            for (int rowIndex : insertRowIndexes) {
                soid = dataTable.getLong(rowIndex, soidColumnIndex);
                if (mqData.hasLoadSOID(soid)) continue;
                oid = dataTable.getLong(rowIndex, oidColumnIndex);
                if (oid.equals(soid)) {
                    mqData.appendLoadSOID(soid);
                }
                insertLoadRowIndexes.add(rowIndex);
            }
            if (insertLoadRowIndexes.size() > 0) {
                DataTable insertDataTable = DataTableExUtil.subDataTable(dataTable, insertLoadRowIndexes);
                columnNames = tableStruct.getJoinColumnNames();
                Object[][] loadValues = insertDataTable.fastDistinctValues(columnNames);
                String sql = tableStruct.getLoadByJoinSql(loadValues.length);
                DataTable mqDataTable = dbManager.execPrepareQuery(sql, MQGenData.twoDimensionalArrayToOneDimensionalArray(loadValues));
                mqData.apppendData(mqDataTable);
            }
        }
        if (deleteRowIndexes.size() > 0 || updateRowIndexes.size() > 0) {
            int rowIndex;
            ArrayList<Long> oids = new ArrayList<Long>(deleteRowIndexes.size() + updateRowIndexes.size());
            columnNames = deleteRowIndexes.iterator();
            while (columnNames.hasNext()) {
                rowIndex = columnNames.next();
                soid = dataTable.getLong(rowIndex, soidColumnIndex);
                if (mqData.hasLoadSOID(soid)) continue;
                oid = dataTable.getLong(rowIndex, oidColumnIndex);
                if (oid.equals(soid)) {
                    mqData.appendLoadSOID(soid);
                }
                oids.add(oid);
            }
            columnNames = updateRowIndexes.iterator();
            while (columnNames.hasNext()) {
                rowIndex = (Integer)columnNames.next();
                soid = dataTable.getLong(rowIndex, soidColumnIndex);
                if (mqData.hasLoadSOID(soid)) continue;
                oid = dataTable.getLong(rowIndex, oidColumnIndex);
                if (oid.equals(soid)) {
                    mqData.appendLoadSOID(soid);
                }
                oids.add(oid);
            }
            if (oids.size() > 0) {
                String sql = tableStruct.getLoadByOIDSql(oids.size());
                DataTable mqDataTable = dbManager.execPrepareQuery(sql, oids.toArray());
                mqData.apppendData(mqDataTable);
            }
        }
    }

    private static Object[] twoDimensionalArrayToOneDimensionalArray(Object[][] tmp) {
        int length0 = tmp.length;
        int length1 = tmp[0].length;
        Object[] result = new Object[length0 * length1];
        int i = 0;
        while (i < length0) {
            System.arraycopy(tmp[i], 0, result, length1 * i, length1);
            ++i;
        }
        return result;
    }

    private static void classifyInsertUpdateDelete(DataTable dataTable, MQTableStruct tableStruct, List<Integer> insertRowIndexes, List<Integer> deleteRowIndexes, List<Integer> updateRowIndexes) throws Throwable {
        WhereExpression whereExpression = tableStruct.whereExpression;
        int rowIndex = 0;
        while (rowIndex < dataTable.size()) {
            int rowStatus = dataTable.getState(rowIndex);
            switch (rowStatus) {
                case 1: {
                    if (whereExpression != null && !whereExpression.isMatch(dataTable, rowIndex, false)) break;
                    insertRowIndexes.add(rowIndex);
                    break;
                }
                case 2: {
                    boolean curMatch;
                    boolean originalMatch = whereExpression == null || whereExpression.isMatch(dataTable, rowIndex, true);
                    boolean bl = curMatch = whereExpression == null || whereExpression.isMatch(dataTable, rowIndex, false);
                    if (!originalMatch && curMatch) {
                        insertRowIndexes.add(rowIndex);
                        break;
                    }
                    if (originalMatch && !curMatch) {
                        deleteRowIndexes.add(rowIndex);
                        break;
                    }
                    if (!originalMatch || !curMatch) break;
                    updateRowIndexes.add(rowIndex);
                    break;
                }
                case 3: {
                    if (whereExpression != null && !whereExpression.isMatch(dataTable, rowIndex, true)) break;
                    deleteRowIndexes.add(rowIndex);
                }
            }
            ++rowIndex;
        }
    }
}

