/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.materializedquery;

import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.mid.materializedquery.MaterializedQueryStruct;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.HashSet;

public class MQData {
    public DataTable data;
    HashSet<Long> hasLoadedSOIDSet;

    public void apppendData(DataTable data) throws Throwable {
        if (this.data == null) {
            this.data = data;
        } else {
            int oidColumnIndex = data.getMetaData().findColumnIndexByKey("OID");
            int columnSize = data.getMetaData().getColumnCount();
            int rowIndex = 0;
            int size = data.size();
            while (rowIndex < size) {
                Long oid = data.getLong(rowIndex, oidColumnIndex);
                int[] oidRowIndexes = this.data.fastFilter("OID", (Object)oid);
                if (oidRowIndexes.length <= 0) {
                    Row row = DataTableExUtil.appendDataTable(this.data);
                    System.arraycopy(data.getRowByIndex(rowIndex).getDataList(), 0, row.getDataList(), 0, columnSize);
                }
                ++rowIndex;
            }
        }
    }

    public boolean hasLoadSOID(Long soid) {
        return this.hasLoadedSOIDSet != null && this.hasLoadedSOIDSet.contains(soid);
    }

    public void appendLoadSOID(Long soid) {
        if (this.hasLoadedSOIDSet == null) {
            this.hasLoadedSOIDSet = new HashSet();
        }
        this.hasLoadedSOIDSet.add(soid);
    }

    public Object[][] copyRow(int rowIndex, int length, Long[] newOIDs) throws Throwable {
        Object[][] result = new Object[length][];
        result[0] = this.data.getRowByIndex(rowIndex).getDataList();
        int i = 1;
        while (i < length) {
            Row row = DataTableExUtil.appendDataTable(this.data);
            result[i] = row.getDataList();
            System.arraycopy(result[0], 1, result[i], 1, result[0].length - 1);
            result[i][0] = newOIDs[i - 1];
            ++i;
        }
        return result;
    }

    public Object[] newRow(MaterializedQueryStruct struct, Long newOID) throws Throwable {
        if (this.data == null) {
            this.data = MetaTableCache.newEmptyDataTable(struct.getMetaTable());
        }
        Row row = DataTableExUtil.appendDataTable(this.data);
        Object[] result = row.getDataList();
        result[0] = newOID;
        Object[] emtpyValues = struct.getEmptyValues();
        System.arraycopy(emtpyValues, 1, result, 1, emtpyValues.length - 1);
        return result;
    }
}

