/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.structure;

import com.bokesoft.yes.common.LRUCacheNew;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.dbcache.datatable.CacheDataTable;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.structure.Parameters;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.util.DocumentDBUtil;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import java.sql.ResultSet;

public class CacheQuery {
    final ParsedSelect select;
    LRUCacheNew<Parameters, DataTable> cache = new LRUCacheNew(16);
    private static int dataTableMetaDataCacheSize = 500;
    LRUCacheNew<ParsedSelect, DataTableMetaData> dataTableMetaDataCache = new LRUCacheNew(dataTableMetaDataCacheSize);

    public CacheQuery(ParsedSelect select) {
        this.select = select;
    }

    public DataTableResultSet getDataTable(QueryArguments arguments) throws Throwable {
        Parameters paras = Parameters.wrap(arguments);
        DataTable dataTable = (DataTable)this.cache.get((Object)paras);
        if (dataTable != null) {
            CacheDataTable cacheDataTable = CacheDataTable.newInstance(dataTable);
            DataTableResultSet dataTableResultSet = new DataTableResultSet(cacheDataTable, null);
            return dataTableResultSet;
        }
        return null;
    }

    public static void setDataTableMetaDataCacheSize(int size) {
        dataTableMetaDataCacheSize = size;
    }

    public ResultSet setDataTable(IDBManager dbManager, QueryArguments arguments, ResultSet resultSet) throws Throwable {
        DataTableMetaData cachedDataTableMetaData = (DataTableMetaData)this.dataTableMetaDataCache.get((Object)this.select);
        DataTable tmp = DocumentDBUtil.populate(dbManager, resultSet, cachedDataTableMetaData);
        tmp.batchUpdate();
        if (cachedDataTableMetaData == null) {
            this.dataTableMetaDataCache.put((Object)this.select, (Object)tmp.getMetaData());
        }
        Parameters paras = Parameters.wrap(arguments);
        this.cache.put((Object)paras, (Object)tmp);
        tmp.beforeFirst();
        CacheDataTable cacheDataTable = CacheDataTable.newInstance(tmp);
        DataTableResultSet dataTableResultSet = new DataTableResultSet(cacheDataTable, null);
        return dataTableResultSet;
    }

    public ResultSet setDataTable(IDBManager dbManager, QueryArguments arguments, DataTableResultSet resultSet) throws Throwable {
        DataTable tmp = resultSet.getDataTable();
        tmp.batchUpdate();
        this.dataTableMetaDataCache.put((Object)this.select, (Object)tmp.getMetaData());
        Parameters paras = Parameters.wrap(arguments);
        this.cache.put((Object)paras, (Object)tmp);
        tmp.beforeFirst();
        CacheDataTable cacheDataTable = CacheDataTable.newInstance(tmp);
        DataTableResultSet dataTableResultSet = new DataTableResultSet(cacheDataTable, resultSet.getMetaData());
        return dataTableResultSet;
    }

    public void clear() {
        this.cache.clear();
    }
}

