/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.structure;

import com.bokesoft.erp.metaobjectchange.MetaObjectChange;
import com.bokesoft.erp.metaobjectchange.MetaObjectChangeListener;
import com.bokesoft.erp.redis.RedisUtils;
import com.bokesoft.yes.common.LRUCacheNew;
import com.bokesoft.yes.common.struct.HashMapIgnoreCaseFastGet;
import com.bokesoft.yes.log.LogSvr;
import com.bokesoft.yes.mid.cache.ThreadVersionCacheMgr;
import com.bokesoft.yes.mid.connection.dbmanager.QueryArguments;
import com.bokesoft.yes.mid.dbcache.CacheDBRequest;
import com.bokesoft.yes.mid.dbcache.WhereExpressionForCache;
import com.bokesoft.yes.mid.dbcache.commit.SubmitDataTable;
import com.bokesoft.yes.mid.dbcache.config.GlobalSetting;
import com.bokesoft.yes.mid.dbcache.config.MetaTables;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedDelete;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedInsert;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedUpdate;
import com.bokesoft.yes.mid.dbcache.structure.CacheQuery;
import com.bokesoft.yes.mid.dbcache.structure.CacheTable;
import com.bokesoft.yes.mid.dbcache.structure.ICache;
import com.bokesoft.yes.mid.materializedquery.InitMaterializedQuery;
import com.bokesoft.yes.mid.materializedquery.MQData;
import com.bokesoft.yes.mid.mysqls.group.meta.DataObjects;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProp;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupProps;
import com.bokesoft.yes.mid.mysqls.group.meta.TableGroupType;
import com.bokesoft.yes.mid.mysqls.resultset.DataTableResultSet;
import com.bokesoft.yes.mid.mysqls.route.util.ShardingUtil;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yigo.cache.CacheFactory;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;
import com.bokesoft.yigo.meta.form.MetaForm;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.struct.datatable.DataTable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public class CacheDB
implements ICache {
    public final IDBManager dbManager;
    public static HashMapIgnoreCaseFastGet<CacheTable> globalCacheDB = new HashMapIgnoreCaseFastGet();
    private static HashMap<ParsedSelect, CacheQuery> globalCacheQueries = new HashMap();
    private HashMapIgnoreCaseFastGet<CacheTable> localCacheTables;
    private LRUCacheNew<ParsedSelect, CacheQuery> localCacheQueries;
    private HashMapIgnoreCaseFastGet<String> updatedGlobalCacheTableList;
    private static final AtomicLong _GlobalCacheVersion = new AtomicLong(0L);
    private static long curGlobalCacheVersion = -1L;
    private boolean hasCheckGlobalCacheVersion = false;
    private Map<Long, Object> hasCheckVerIDOID = null;
    private Map<Long, Map<String, Object>> cacheBillEntities;
    MQData mqData;
    private Object causeCacheObject;
    private static final String CACHE_GLOBAL_VERSION;
    private static final String GLOBAL_VERSION;

    static {
        MetaObjectChange.register((MetaObjectChangeListener)new MetaObjectChangeListener(){

            public void changeMetaAll() {
            }

            public void changeMetaForm(MetaForm metaForm) throws Throwable {
                if (metaForm.getDataSource() != null) {
                    CacheDB.clearCacheDB(metaForm.getDataSource().getDataObject());
                }
            }

            public void changeMetaDataObject(MetaDataObject metaDataObject) throws Throwable {
                CacheDB.clearCacheDB(metaDataObject);
            }
        }, (String)"DBCache");
        CACHE_GLOBAL_VERSION = "ERP_" + ThreadVersionCacheMgr.CacheGlobalVersion;
        GLOBAL_VERSION = ThreadVersionCacheMgr.GlobalVersion;
    }

    public CacheDB(IDBManager dbManager) {
        this.dbManager = dbManager;
        if (InitMaterializedQuery.mq != null) {
            this.mqData = new MQData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCacheDB(MetaDataObject metaDataObject) throws Throwable {
        if (metaDataObject == null) {
            return;
        }
        MetaTableCollection tableCollection = metaDataObject.getTableCollection();
        if (tableCollection != null) {
            for (MetaTable metaTable : tableCollection) {
                String dbTableName = metaTable.getBindingDBTableName();
                CacheTable cacheTable = (CacheTable)globalCacheDB.get(dbTableName);
                if (cacheTable != null) {
                    globalCacheDB.remove(dbTableName);
                    cacheTable.clearDataStruct();
                }
                HashMap<ParsedSelect, CacheQuery> hashMap = globalCacheQueries;
                synchronized (hashMap) {
                    CacheDB.clearGlobalCacheQuery(globalCacheQueries, dbTableName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public CacheTable getCacheTable(String tableName, boolean ensure) throws Throwable {
        Class<CacheDB> clazz;
        CacheTable result = null;
        if (GlobalSetting.isGlobalTable(tableName)) {
            this.ensureCheckGlobalCacheVersion();
            result = (CacheTable)globalCacheDB.get(tableName);
            if (result != null) return result;
            if (!ensure) return result;
            HashMapIgnoreCaseFastGet<CacheTable> hashMapIgnoreCaseFastGet = globalCacheDB;
            // MONITORENTER : hashMapIgnoreCaseFastGet
            result = (CacheTable)globalCacheDB.get(tableName);
            if (result == null) {
                result = new CacheTable(tableName);
                globalCacheDB.put(tableName, (Object)result);
            }
            // MONITOREXIT : hashMapIgnoreCaseFastGet
            return result;
        }
        if (this.localCacheTables == null) {
            if (!ensure) return null;
            clazz = CacheDB.class;
            // MONITORENTER : com.bokesoft.yes.mid.dbcache.structure.CacheDB.class
            this.localCacheTables = new HashMapIgnoreCaseFastGet();
            // MONITOREXIT : clazz
        }
        if ((result = (CacheTable)this.localCacheTables.get(tableName)) != null) return result;
        if (!ensure) return result;
        clazz = this.localCacheTables;
        // MONITORENTER : clazz
        result = (CacheTable)this.localCacheTables.get(tableName);
        if (result == null) {
            result = new CacheTable(tableName);
            this.localCacheTables.put(tableName, (Object)result);
        }
        // MONITOREXIT : clazz
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheQuery getCacheQuery(ParsedSelect select) throws Throwable {
        CacheQuery result = null;
        if (select.isGlobalQuery()) {
            this.ensureCheckGlobalCacheVersion();
            result = globalCacheQueries.get(select);
            if (result == null) {
                HashMap<ParsedSelect, CacheQuery> hashMap = globalCacheQueries;
                synchronized (hashMap) {
                    result = globalCacheQueries.get(select);
                    if (result == null) {
                        result = new CacheQuery(select);
                        globalCacheQueries.put(select, result);
                    }
                }
            }
        } else {
            if (this.localCacheQueries == null) {
                this.localCacheQueries = new LRUCacheNew(1024);
            }
            if ((result = (CacheQuery)this.localCacheQueries.get((Object)select)) == null) {
                LRUCacheNew<ParsedSelect, CacheQuery> lRUCacheNew = this.localCacheQueries;
                synchronized (lRUCacheNew) {
                    result = (CacheQuery)this.localCacheQueries.get((Object)select);
                    if (result == null) {
                        result = new CacheQuery(select);
                        this.localCacheQueries.put((Object)select, (Object)result);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public DataTableResultSet query(ParsedSelect select, QueryArguments paras) throws Throwable {
        if (!select.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        String tableName = select.getCacheTableName();
        if (this.isUpdatedGlobalTable(tableName)) {
            return null;
        }
        CacheTable cachedTable = this.getCacheTable(tableName, true);
        DataTableResultSet result = cachedTable.query(this.dbManager, select, paras);
        return result;
    }

    @Override
    public int update(ParsedUpdate update, List<? extends QueryArguments> parases, List<QueryArguments> notProcessParases) throws Throwable {
        if (!update.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        String tableName = update.getCacheTableName();
        if (GlobalSetting.isGlobalTable(tableName)) {
            this.addUpdatedGlobalTable2List(tableName);
            notProcessParases.addAll(parases);
            return -1;
        }
        CacheTable cachedTable = this.getCacheTable(tableName, false);
        if (cachedTable == null) {
            notProcessParases.addAll(parases);
            CacheDB.clearCacheQuery(this.localCacheQueries, tableName);
            return -1;
        }
        int result = cachedTable.update(this, update, parases, notProcessParases);
        CacheDB.clearCacheQuery(this.localCacheQueries, tableName);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearGlobalCacheQuery(String tableName) {
        HashMap<ParsedSelect, CacheQuery> hashMap = globalCacheQueries;
        synchronized (hashMap) {
            CacheDB.clearGlobalCacheQuery(globalCacheQueries, tableName);
        }
    }

    private static void clearCacheQuery(LRUCacheNew<ParsedSelect, CacheQuery> cacheQueries, String tableName) {
        if (cacheQueries != null) {
            Set entries = cacheQueries.getAll();
            Iterator iterator = entries.iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                ParsedSelect select = (ParsedSelect)next.getKey();
                List<String> tableNames = select.getTableNames();
                for (String name : tableNames) {
                    if (!name.equalsIgnoreCase(tableName)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    private static void clearGlobalCacheQuery(HashMap<ParsedSelect, CacheQuery> cacheQueries, String tableName) {
        if (cacheQueries != null) {
            Set<Map.Entry<ParsedSelect, CacheQuery>> entries = cacheQueries.entrySet();
            Iterator<Map.Entry<ParsedSelect, CacheQuery>> iterator = entries.iterator();
            block0: while (iterator.hasNext()) {
                Map.Entry<ParsedSelect, CacheQuery> next = iterator.next();
                ParsedSelect select = next.getKey();
                List<String> tableNames = select.getTableNames();
                for (String name : tableNames) {
                    if (!name.equalsIgnoreCase(tableName)) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }
    }

    public void addUpdatedGlobalTable2List(String tableName) {
        if (this.updatedGlobalCacheTableList == null) {
            this.updatedGlobalCacheTableList = new HashMapIgnoreCaseFastGet();
        }
        this.updatedGlobalCacheTableList.put(tableName, null);
    }

    @Override
    public int insert(ParsedInsert insert, List<? extends QueryArguments> parases, List<QueryArguments> notProcessParases) throws Throwable {
        if (!insert.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        String tableName = insert.getCacheTableName();
        if (GlobalSetting.isGlobalTable(tableName)) {
            this.addUpdatedGlobalTable2List(tableName);
            notProcessParases.addAll(parases);
            return -1;
        }
        CacheTable cachedTable = this.getCacheTable(tableName, true);
        int result = cachedTable.insert(this, insert, parases, notProcessParases);
        CacheDB.clearCacheQuery(this.localCacheQueries, tableName);
        return result;
    }

    @Override
    public int delete(ParsedDelete delete, List<? extends QueryArguments> parases, List<QueryArguments> notProcessParases) throws Throwable {
        if (!delete.isSupportCache()) {
            throw new RuntimeException("\u672c\u8bed\u53e5\u4e0d\u652f\u6301\u7f13\u5b58\u3002");
        }
        String tableName = delete.getCacheTableName();
        if (GlobalSetting.isGlobalTable(tableName)) {
            this.addUpdatedGlobalTable2List(tableName);
            notProcessParases.addAll(parases);
            return -1;
        }
        CacheTable cachedTable = this.getCacheTable(tableName, false);
        if (cachedTable == null) {
            notProcessParases.addAll(parases);
            CacheDB.clearCacheQuery(this.localCacheQueries, tableName);
            return -1;
        }
        int result = cachedTable.delete(this, delete, parases, notProcessParases);
        CacheDB.clearCacheQuery(this.localCacheQueries, tableName);
        return result;
    }

    public boolean saveDataTable(DataTable dataTable, String tableName, MetaTable metaTable, Object causeCacheObject) throws Throwable {
        if (GlobalSetting.isGlobalTable(tableName)) {
            CacheTable cachedTable = this.getCacheTable(tableName, true);
            cachedTable.saveDataTable(this, dataTable, metaTable, this.dbManager.getDBType(), true);
            return false;
        }
        CacheTable cachedTable = this.getCacheTable(tableName, true);
        this.causeCacheObject = causeCacheObject;
        boolean result = cachedTable.saveDataTable(this, dataTable, metaTable, this.dbManager.getDBType());
        this.causeCacheObject = null;
        CacheDB.clearCacheQuery(this.localCacheQueries, tableName);
        return result;
    }

    public void submit(CacheDBRequest cacheDBRequest) throws Throwable {
        if (this.localCacheTables != null) {
            ArrayList<CacheTable> arrayList = new ArrayList<CacheTable>();
            for (CacheTable cacheTable : this.localCacheTables.values()) {
                if (!cacheTable.isChanged()) continue;
                arrayList.add(cacheTable);
            }
            arrayList.sort(new Comparator<CacheTable>(){

                @Override
                public int compare(CacheTable o1, CacheTable o2) {
                    String tableName1 = o1.tableName;
                    String tableName2 = o2.tableName;
                    try {
                        boolean isGroup2;
                        TableGroupProp tableGroupProp1 = TableGroupProps.getInstance().getTableGroupProp(tableName1);
                        TableGroupType tableGroupType1 = tableGroupProp1 == null ? null : tableGroupProp1.getFixedType();
                        boolean isGroup1 = tableGroupType1 == TableGroupType.DetailTableInGroupByDetailTable || tableGroupType1 == TableGroupType.HeadTableInGroupByHeadTable;
                        TableGroupProp tableGroupProp2 = TableGroupProps.getInstance().getTableGroupProp(tableName2);
                        TableGroupType tableGroupType2 = tableGroupProp2 == null ? null : tableGroupProp2.getFixedType();
                        boolean bl = isGroup2 = tableGroupType2 == TableGroupType.DetailTableInGroupByDetailTable || tableGroupType2 == TableGroupType.HeadTableInGroupByHeadTable;
                        if (isGroup1 != isGroup2) {
                            return isGroup1 ? -1 : 1;
                        }
                        if (!isGroup1 && !isGroup2) {
                            boolean isMain2;
                            boolean isRelationTable2;
                            boolean isRelationTable1 = tableGroupType1 == TableGroupType.DataObjectRelationTable;
                            boolean bl2 = isRelationTable2 = tableGroupType2 == TableGroupType.DataObjectRelationTable;
                            if (isRelationTable1 != isRelationTable2) {
                                return isRelationTable1 ? 1 : -1;
                            }
                            boolean isMain1 = MetaTables.isMainTable(tableName1);
                            if (isMain1 != (isMain2 = MetaTables.isMainTable(tableName2))) {
                                return isMain1 ? -1 : 1;
                            }
                        }
                        return tableName1.compareToIgnoreCase(tableName2);
                    }
                    catch (Throwable e) {
                        return tableName1.compareToIgnoreCase(tableName2);
                    }
                }
            });
            this.sortByTableExtra(arrayList);
            for (CacheTable cacheTable : arrayList) {
                cacheTable.submit(cacheDBRequest, this.dbManager, true);
            }
            for (CacheTable cacheTable : arrayList) {
                cacheTable.clear();
            }
            this.localCacheTables.clear();
        }
        if (this.localCacheQueries != null) {
            Set set = this.localCacheQueries.getAll();
            for (Map.Entry next : set) {
                CacheQuery value = (CacheQuery)next.getValue();
                value.clear();
            }
            this.localCacheQueries.clear();
        }
        if (this.updatedGlobalCacheTableList != null) {
            for (String string : this.updatedGlobalCacheTableList.keySet()) {
                CacheTable cacheTable = (CacheTable)globalCacheDB.get(string);
                if (cacheTable != null) {
                    cacheTable.submit(cacheDBRequest, this.dbManager, true);
                    cacheTable.clear();
                    globalCacheDB.remove(string);
                }
                this.clearGlobalCacheQuery(string);
            }
            this.updatedGlobalCacheTableList.clear();
        }
        if (this.cacheBillEntities != null) {
            for (Map map : this.cacheBillEntities.values()) {
                map.clear();
            }
            this.cacheBillEntities.clear();
        }
        if (InitMaterializedQuery.mq != null && this.mqData != null && this.mqData.data != null) {
            SubmitDataTable.saveDataTableData(cacheDBRequest, this.dbManager, this.mqData.data, InitMaterializedQuery.mq.key, true);
        }
    }

    private void sortByTableExtra(List<CacheTable> submitCacheTables) {
        if (!ShardingUtil.isShardingDB()) {
            return;
        }
        int i = 0;
        while (i < submitCacheTables.size()) {
            CacheTable curTable = submitCacheTables.get(i);
            int j = i;
            while (j < submitCacheTables.size()) {
                CacheTable compareTable = submitCacheTables.get(j);
                if (curTable != compareTable && this.needSwapByTableExtra(curTable, compareTable)) {
                    submitCacheTables.set(i, compareTable);
                    submitCacheTables.set(j, curTable);
                    break;
                }
                ++j;
            }
            ++i;
        }
    }

    private boolean needSwapByTableExtra(CacheTable o1, CacheTable o2) {
        String tableName1 = o1.tableName;
        String tableName2 = o2.tableName;
        TableGroupProp tableGroupProp1 = TableGroupProps.getInstance().getTableGroupProp(tableName1);
        TableGroupProp tableGroupProp2 = TableGroupProps.getInstance().getTableGroupProp(tableName2);
        if (tableGroupProp1 == null || tableGroupProp2 == null) {
            return false;
        }
        if (tableGroupProp1 != null && tableGroupProp2 != null && tableGroupProp1.getFixedType() == TableGroupType.DetailTableExtra && tableGroupProp2.getFixedType() == TableGroupType.DetailTableExtra && tableGroupProp1.getHeadTableForDetailTableExtra().headTableName != null) {
            return tableGroupProp1.getHeadTableForDetailTableExtra().headTableName.equalsIgnoreCase(tableGroupProp2.getTableName());
        }
        return false;
    }

    public void rollback(CacheDBRequest cacheDBRequest) {
        if (this.localCacheTables != null) {
            for (CacheTable cacheTable : this.localCacheTables.values()) {
                cacheTable.rollback(cacheDBRequest, this.dbManager);
            }
            this.localCacheTables.clear();
        }
        if (this.localCacheQueries != null) {
            Set set = this.localCacheQueries.getAll();
            for (Map.Entry next : set) {
                CacheQuery value = (CacheQuery)next.getValue();
                value.clear();
            }
            this.localCacheQueries.clear();
        }
        if (this.updatedGlobalCacheTableList != null) {
            for (String string : this.updatedGlobalCacheTableList.keySet()) {
                CacheTable cacheTable = (CacheTable)globalCacheDB.get(string);
                if (cacheTable != null) {
                    cacheTable.rollback(cacheDBRequest, this.dbManager);
                    globalCacheDB.remove(string);
                }
                this.clearGlobalCacheQuery(string);
            }
            this.updatedGlobalCacheTableList.clear();
        }
        if (this.cacheBillEntities != null) {
            for (Map map : this.cacheBillEntities.values()) {
                map.clear();
            }
            this.cacheBillEntities.clear();
        }
    }

    public boolean isUpdatedGlobalTable(String tableName) {
        return this.updatedGlobalCacheTableList != null && this.updatedGlobalCacheTableList.containsKey(tableName);
    }

    public boolean isUpdatedTable(String tableName) throws Throwable {
        if (GlobalSetting.isGlobalTable(tableName)) {
            return this.isUpdatedGlobalTable(tableName);
        }
        CacheTable cacheTable = this.getCacheTable(tableName, false);
        return cacheTable == null ? false : cacheTable.isChanged();
    }

    public void submitByNotSuportCacheSql(CacheDBRequest cacheDBRequest, ParsedSql parsedSql, QueryArguments arguments, List<QueryArguments> argumentsList, boolean isChangeData) throws Throwable {
        List<String> tableNames = parsedSql.getTableNames();
        for (String tableName : tableNames) {
            CacheTable cachedTable;
            if (isChangeData) {
                if (GlobalSetting.isGlobalTable(tableName)) {
                    this.addUpdatedGlobalTable2List(tableName);
                } else {
                    CacheDB.clearCacheQuery(this.localCacheQueries, tableName);
                }
            }
            if ((cachedTable = this.getCacheTable(tableName, false)) == null || !cachedTable.isIntersect(parsedSql, arguments, argumentsList)) continue;
            if (cachedTable.isChanged()) {
                String[] stringArray = TableGroupProps.getInstance().getPreSubmitHeadTableNames(tableName);
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String preSubmitTableName = stringArray[n2];
                    CacheTable preSubmitCachedTable = this.getCacheTable(preSubmitTableName, false);
                    if (preSubmitCachedTable != null && preSubmitCachedTable.isChanged()) {
                        preSubmitCachedTable.submitAndRemoveDelete(cacheDBRequest, this.dbManager);
                    }
                    ++n2;
                }
            }
            if (isChangeData) {
                cachedTable.submit(cacheDBRequest, this.dbManager, false);
                cachedTable.clearBillEntity(this);
                cachedTable.clear();
                continue;
            }
            cachedTable.submitAndRemoveDelete(cacheDBRequest, this.dbManager);
        }
    }

    public static void updateGlobalEntityVersion(String formKey) throws Throwable {
        LogSvr.getInstance().debug("\u5f00\u59cb\u66f4\u65b0\u5168\u5c40\u7f13\u5b58\u7248\u672c\u53f7\uff0c\u5386\u53f2\u7248\u672c\u4e3a " + _GlobalCacheVersion.get());
        if (RedisUtils.isUseRedis()) {
            CacheFactory.getInstance().createCache(CACHE_GLOBAL_VERSION).incr(GLOBAL_VERSION, 1L, null);
        } else {
            _GlobalCacheVersion.getAndIncrement();
        }
    }

    private long getGlobalCacheVersion() {
        if (RedisUtils.isUseRedis()) {
            try {
                return CacheFactory.getInstance().createCache(CACHE_GLOBAL_VERSION).incr(GLOBAL_VERSION, 0L, null);
            }
            catch (Throwable throwable) {
                throw new RuntimeException("Redis\u83b7\u53d6\u7f13\u5b58\u7248\u672c\u5931\u8d25\uff01", throwable);
            }
        }
        return _GlobalCacheVersion.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureCheckGlobalCacheVersion() {
        if (!this.hasCheckGlobalCacheVersion) {
            long cacheVersion = this.getGlobalCacheVersion();
            if (cacheVersion != curGlobalCacheVersion) {
                globalCacheDB.clear();
                HashMap<ParsedSelect, CacheQuery> hashMap = globalCacheQueries;
                synchronized (hashMap) {
                    globalCacheQueries.clear();
                }
                curGlobalCacheVersion = cacheVersion;
            }
            this.hasCheckGlobalCacheVersion = true;
        }
    }

    public Object getCacheBillEntity(String formKey, Long oid) throws Throwable {
        if (this.cacheBillEntities == null) {
            return null;
        }
        Map<String, Object> billEntities = this.cacheBillEntities.get(oid);
        if (billEntities == null) {
            return null;
        }
        boolean globalForm = GlobalSetting.isGlobalForm(formKey);
        if (globalForm) {
            List<String> tableKeys = GlobalSetting.getGlobalTableByFormKey(formKey);
            for (String tableKey : tableKeys) {
                if (!this.isUpdatedGlobalTable(tableKey)) continue;
                return null;
            }
        }
        return billEntities.get(formKey);
    }

    public void cacheBillEntity(String formKey, Long oid, Object billEntity) {
        if (this.cacheBillEntities == null) {
            this.cacheBillEntities = new HashMap<Long, Map<String, Object>>();
        }
        Map billEntities = this.cacheBillEntities.getOrDefault(oid, new HashMap());
        this.cacheBillEntities.put(oid, billEntities);
        billEntities.put(formKey, billEntity);
    }

    public void clearBillEntity(Long oid) {
        if (this.cacheBillEntities != null) {
            if (this.causeCacheObject == null) {
                this.cacheBillEntities.remove(oid);
            } else {
                HashMap documents = (HashMap)this.cacheBillEntities.get(oid);
                if (documents != null) {
                    for (Object tmp : documents.values()) {
                        if (tmp == this.causeCacheObject) continue;
                        this.cacheBillEntities.remove(oid);
                        return;
                    }
                }
            }
        }
    }

    public void clearAllBillEntity() {
        this.cacheBillEntities.clear();
    }

    public DataTable queryByOID(String tableKey, Long oid) throws Throwable {
        if (this.isUpdatedGlobalTable(tableKey)) {
            return null;
        }
        CacheTable cacheTable = this.getCacheTable(tableKey, true);
        DataTable result = cacheTable.queryByOID(this.dbManager, oid);
        return result;
    }

    public DataTable queryByWhereExpression(String tableKey, WhereExpressionForCache whereExpression, SortCriteria[] sorts) throws Throwable {
        if (this.isUpdatedGlobalTable(tableKey)) {
            return null;
        }
        CacheTable cacheTable = this.getCacheTable(tableKey, true);
        DataTable result = cacheTable.queryByWhereExpression(this, this.dbManager, whereExpression, sorts);
        return result;
    }

    public boolean hasCheckVerID(Long oid, String tableName) {
        if (this.hasCheckVerIDOID == null) {
            return false;
        }
        Object tableNames = this.hasCheckVerIDOID.get(oid);
        if (tableNames == null) {
            return false;
        }
        if (tableNames instanceof String) {
            return tableName.equalsIgnoreCase((String)tableNames);
        }
        List tableNameList = (List)tableNames;
        for (String tmp : tableNameList) {
            if (!tmp.equalsIgnoreCase(tableName)) continue;
            return true;
        }
        return false;
    }

    public void setCheckVerID(Long oid, String tableName) {
        Object tableNames;
        if (this.hasCheckVerIDOID == null) {
            this.hasCheckVerIDOID = new HashMap<Long, Object>();
        }
        if ((tableNames = this.hasCheckVerIDOID.get(oid)) == null) {
            this.hasCheckVerIDOID.put(oid, tableName);
        } else if (tableNames instanceof String) {
            if (tableName.equalsIgnoreCase((String)tableNames)) {
                throw new RuntimeException("\u672c\u4e8b\u52a1\u4e2d\u5df2\u7ecf\u68c0\u67e5\u8fc7\u4e24\u6b21" + tableName + "\u7684oid\u503c" + oid + "\u7684\u7248\u672c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
            }
            ArrayList<String> tableNameList = new ArrayList<String>(5);
            tableNameList.add((String)tableNames);
            tableNameList.add(tableName);
            this.hasCheckVerIDOID.put(oid, tableNameList);
        } else {
            List tableNameList = (List)tableNames;
            for (String tmp : tableNameList) {
                if (!tmp.equalsIgnoreCase(tableName)) continue;
                throw new RuntimeException("\u672c\u4e8b\u52a1\u4e2d\u5df2\u7ecf\u68c0\u67e5\u8fc7\u4e24\u6b21" + tableName + "\u7684oid\u503c" + oid + "\u7684\u7248\u672c\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
            }
            tableNameList.add(tableName);
        }
    }

    public void addPreLoadingArgument(String tableName, WhereExpressionForCache whereExpressionForCache) throws Throwable {
        if (GlobalSetting.isGlobalTable(tableName)) {
            throw new RuntimeException("\u8868" + tableName + "\u662f\u5168\u5c40\u8868\uff0c\u4e0d\u652f\u6301\u9884\u52a0\u8f7d\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u3002");
        }
        CacheTable cachedTable = this.getCacheTable(tableName, true);
        cachedTable.addPreLoadingArgument(whereExpressionForCache);
    }

    public boolean isNewInsertSOID(String tableName, Long soid) throws Throwable {
        List<String> headTableNames = DataObjects.getHeadTableNames(tableName);
        for (String headTableName : headTableNames) {
            CacheTable cachedTable = this.getCacheTable(headTableName, false);
            if (cachedTable == null || cachedTable.newInsertSOIDs == null || !cachedTable.newInsertSOIDs.contains(soid)) continue;
            return true;
        }
        return false;
    }
}

