/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.parsedsql;

import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.dbcache.config.IgnoreSqlCacheSetting;
import com.bokesoft.yes.mid.dbcache.config.TablePrimarySetting;
import com.bokesoft.yes.mid.dbcache.parsedsql.DeParser;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.update.Update;
import net.boke.jsqlparser.util.deparser.UpdateDeParser;

public class ParsedUpdate
extends ParsedSql {
    final Update update;
    private Boolean isSupportCache;

    public ParsedUpdate(String sql, Update update) {
        super(sql);
        this.update = update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupportCache() throws Throwable {
        if (this.isSupportCache == null) {
            ParsedUpdate parsedUpdate = this;
            synchronized (parsedUpdate) {
                if (this.isSupportCache == null) {
                    this.isSupportCache = this.getTableNames().size() != 1 ? Boolean.valueOf(false) : (!this.isWhereClauseSupport() ? Boolean.valueOf(false) : Boolean.valueOf(MetaTableCache.getFullMetaTable(this.getCacheTableName()) != null && IgnoreSqlCacheSetting.isSupportCacheTables(this.getTableNames())));
                }
            }
        }
        return this.isSupportCache;
    }

    private boolean isWhereClauseSupport() {
        String tableName = this.getTableNames().get(0);
        String oidField = TablePrimarySetting.getOIDField(tableName);
        String soidField = TablePrimarySetting.getSOIDField(tableName);
        String secondField = TablePrimarySetting.hasGroupSOIDUniqueIndex(tableName) ? TablePrimarySetting.getGroupSOIDUniqueIndexSecondField(tableName) : null;
        Expression where = this.getWhereClause();
        boolean result = this.parseWhere(where, oidField, soidField, secondField);
        result = result && this.oidIndex != null && this.oidIndex.getValueArray() == null && this.isOnlyOidOrSoid;
        return result;
    }

    private boolean parseWhere(Expression expression, String oidField, String soidField, String secondField) {
        if (expression instanceof Parenthesis) {
            return this.parseWhere(((Parenthesis)expression).getExpression(), oidField, soidField, secondField);
        }
        if (expression instanceof EqualsTo) {
            String columnName;
            EqualsTo binaryExpression = (EqualsTo)expression;
            if (!binaryExpression.isNot() && binaryExpression.getLeftExpression() instanceof Column && oidField.equalsIgnoreCase(columnName = ((Column)binaryExpression.getLeftExpression()).getColumnName())) {
                Expression value = binaryExpression.getRightExpression();
                if (value instanceof JdbcParameter) {
                    JdbcParameter jdbcParameter = (JdbcParameter)value;
                    int oidIndex = jdbcParameter.getIndexInSql();
                    if (oidIndex == -1) {
                        oidIndex = this.getJdbcParameters().indexOf(jdbcParameter);
                        jdbcParameter.setIndexInSql(oidIndex);
                    }
                    this.setOIDIndex(oidIndex);
                }
                return true;
            }
        } else if (expression instanceof AndExpression || expression instanceof OrExpression) {
            this.isOnlyOidOrSoid = false;
        }
        return false;
    }

    @Override
    protected List<String> findTableNames() {
        ArrayList<String> tmp = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer(512);
        DeParser deParser = ParsedUpdate.getSelectDeParser(tmp, buffer);
        UpdateDeParser updateDeParser = new UpdateDeParser(deParser.getExpressionDeParser(), buffer);
        updateDeParser.deParse(this.update);
        tmp.add(this.update.getTable().getName());
        return tmp;
    }

    @Override
    public Statement getStatement() {
        return this.update;
    }

    @Override
    public Expression getWhereClause() {
        return this.update.getWhere();
    }
}

