/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.parsedsql;

import com.bokesoft.erp.performance.Performance;
import com.bokesoft.yes.common.LRUCacheNew;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedAlter;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedDelete;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedInsert;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedOther;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSelect;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedUpdate;
import com.bokesoft.yes.mid.mysqls.sql.SqlInfos;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import com.bokesoft.yigo.meta.factory.MetaFactory;
import com.bokesoft.yigo.meta.setting.MetaSimpleSetting;
import net.boke.jsqlparser.JSQLParserException;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.alter.Alter;
import net.boke.jsqlparser.statement.create.index.CreateIndex;
import net.boke.jsqlparser.statement.create.table.CreateTable;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.statement.drop.Drop;
import net.boke.jsqlparser.statement.insert.Insert;
import net.boke.jsqlparser.statement.replace.Replace;
import net.boke.jsqlparser.statement.select.AllColumns;
import net.boke.jsqlparser.statement.select.FromItem;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.Select;
import net.boke.jsqlparser.statement.select.SelectBody;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Union;
import net.boke.jsqlparser.statement.truncate.Truncate;
import net.boke.jsqlparser.statement.update.Update;

public class ParsedSqls {
    private int cacheSize = 500;
    private LRUCacheNew<String, ParsedSql> datas = null;
    private static boolean isInJunit = false;

    private ParsedSqls() {
    }

    public static void setIsInJunit(boolean isInJunit) {
        ParsedSqls.isInJunit = isInJunit;
    }

    private boolean init() {
        if (this.datas == null) {
            if (!isInJunit) {
                IMetaFactory factory = MetaFactory.getGlobalInstance();
                if (factory == null) {
                    return false;
                }
                MetaSimpleSetting cacheSettings = factory.getSetting().getSimpleSetting("ParsedSqlsCache");
                if (cacheSettings != null && cacheSettings.get("Size") != null) {
                    this.cacheSize = TypeConvertor.toInteger((Object)cacheSettings.get("Size"));
                }
            }
            this.datas = new LRUCacheNew(this.cacheSize);
        }
        return true;
    }

    public static ParsedSqls getInstance() {
        return ParsedSqlsHolder.instance;
    }

    public void clear() {
        if (this.datas == null) {
            return;
        }
        this.datas.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParsedSql getParsedSql(String sql) {
        if (!this.init()) {
            return null;
        }
        ParsedSql result = (ParsedSql)this.datas.get((Object)sql);
        if (result == null) {
            ParsedSqls parsedSqls = ParsedSqlsHolder.instance;
            synchronized (parsedSqls) {
                result = (ParsedSql)this.datas.get((Object)sql);
                if (result == null) {
                    Object[] actions = new Object[]{"createParsedSql"};
                    int action = Performance.startAction((Object[])new Object[]{"createParsedSql"});
                    result = this.createParsedSql(sql);
                    Performance.endActive((int)action, (Object[])actions);
                    this.datas.put((Object)sql, (Object)result);
                }
            }
        }
        return result;
    }

    public ParsedSql createParsedSql(String sql) {
        Statement statement = null;
        try {
            statement = SqlInfos.instance.parseSql(sql);
        }
        catch (JSQLParserException e) {
            return new ParsedOther(sql);
        }
        ParsedSql result = null;
        if (statement instanceof Select) {
            SelectBody selectBody = ((Select)statement).getSelectBody();
            if (selectBody instanceof PlainSelect) {
                FromItem fromItem;
                PlainSelect plainSelect = (PlainSelect)selectBody;
                if (plainSelect.getSelectItems().size() == 1 && plainSelect.getSelectItems().get(0) instanceof AllColumns && plainSelect.getWhere() == null && plainSelect.getOrderByElements() == null && plainSelect.getLimit() == null && (fromItem = plainSelect.getFromItem()) instanceof SubSelect) {
                    sql = ((SubSelect)fromItem).getSelectBody().toString();
                    return this.createParsedSql(sql);
                }
                result = new ParsedSelect(sql, (Select)statement);
            } else if (selectBody instanceof Union) {
                result = new ParsedOther(sql);
            }
        } else if (statement instanceof Insert) {
            result = new ParsedInsert(sql, (Insert)statement);
        } else if (statement instanceof Update) {
            result = new ParsedUpdate(sql, (Update)statement);
        } else if (statement instanceof Delete) {
            result = new ParsedDelete(sql, (Delete)statement);
        } else if (statement instanceof Alter) {
            result = new ParsedAlter(sql, (Alter)statement);
        } else if (statement instanceof CreateTable || statement instanceof Drop || statement instanceof Truncate || statement instanceof Replace || statement instanceof CreateIndex) {
            result = new ParsedOther(sql);
        } else {
            throw new RuntimeException("\u76ee\u524d\u53ea\u652f\u6301select/insert/update/delete\u8bed\u53e5\uff0c" + sql + "\u4e0d\u652f\u6301\u3002");
        }
        return result;
    }

    /* synthetic */ ParsedSqls(ParsedSqls parsedSqls) {
        this();
    }

    private static class ParsedSqlsHolder {
        private static final ParsedSqls instance = new ParsedSqls(null);

        private ParsedSqlsHolder() {
        }
    }
}

