/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.parsedsql;

import com.bokesoft.yes.erp.dev.MetaTableCache;
import com.bokesoft.yes.mid.dbcache.config.IgnoreSqlCacheSetting;
import com.bokesoft.yes.mid.dbcache.config.TablePrimarySetting;
import com.bokesoft.yes.mid.dbcache.parsedsql.DeParser;
import com.bokesoft.yes.mid.dbcache.parsedsql.ParsedSql;
import java.util.ArrayList;
import java.util.List;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.JdbcParameter;
import net.boke.jsqlparser.expression.Parenthesis;
import net.boke.jsqlparser.expression.operators.conditional.AndExpression;
import net.boke.jsqlparser.expression.operators.conditional.OrExpression;
import net.boke.jsqlparser.expression.operators.relational.EqualsTo;
import net.boke.jsqlparser.expression.operators.relational.ExpressionList;
import net.boke.jsqlparser.expression.operators.relational.InExpression;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.statement.Statement;
import net.boke.jsqlparser.statement.delete.Delete;
import net.boke.jsqlparser.util.deparser.DeleteDeParser;

public class ParsedDelete
extends ParsedSql {
    final Delete delete;
    private Boolean isSupportCache;

    public ParsedDelete(String sql, Delete delete) {
        super(sql);
        this.delete = delete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSupportCache() throws Throwable {
        if (this.isSupportCache == null) {
            ParsedDelete parsedDelete = this;
            synchronized (parsedDelete) {
                if (this.isSupportCache == null) {
                    this.isSupportCache = this.getTableNames().size() != 1 ? Boolean.valueOf(false) : (!this.isWhereClauseSupport() ? Boolean.valueOf(false) : Boolean.valueOf(MetaTableCache.getFullMetaTable(this.getCacheTableName()) != null && IgnoreSqlCacheSetting.isSupportCacheTables(this.getTableNames())));
                }
            }
        }
        return this.isSupportCache;
    }

    private boolean isWhereClauseSupport() {
        String tableName = this.getTableNames().get(0);
        String oidField = TablePrimarySetting.getOIDField(tableName);
        String soidField = TablePrimarySetting.getSOIDField(tableName);
        String secondField = TablePrimarySetting.hasGroupSOIDUniqueIndex(tableName) ? TablePrimarySetting.getGroupSOIDUniqueIndexSecondField(tableName) : null;
        Expression where = this.getWhereClause();
        boolean result = this.parseWhere(where, oidField, soidField, secondField);
        result = result && (this.hasOIDWhere() || this.soidIndex >= 0) && this.isOnlyOidOrSoid;
        return result;
    }

    private boolean parseWhere(Expression expression, String oidField, String soidField, String secondField) {
        if (expression instanceof Parenthesis) {
            return this.parseWhere(((Parenthesis)expression).getExpression(), oidField, soidField, secondField);
        }
        if (expression instanceof EqualsTo) {
            EqualsTo binaryExpression = (EqualsTo)expression;
            if (!binaryExpression.isNot() && binaryExpression.getLeftExpression() instanceof Column) {
                String columnName = ((Column)binaryExpression.getLeftExpression()).getColumnName();
                if (oidField.equalsIgnoreCase(columnName)) {
                    Expression value = binaryExpression.getRightExpression();
                    if (value instanceof JdbcParameter) {
                        JdbcParameter jdbcParameter = (JdbcParameter)value;
                        int oidIndex = jdbcParameter.getIndexInSql();
                        if (oidIndex == -1) {
                            oidIndex = this.getJdbcParameters().indexOf(jdbcParameter);
                            jdbcParameter.setIndexInSql(oidIndex);
                        }
                        return this.setOIDIndex(oidIndex);
                    }
                } else if (columnName.equalsIgnoreCase(soidField)) {
                    Expression value = binaryExpression.getRightExpression();
                    if (value instanceof JdbcParameter) {
                        JdbcParameter jdbcParameter = (JdbcParameter)value;
                        this.soidIndex = jdbcParameter.getIndexInSql();
                        if (this.soidIndex == -1) {
                            this.soidIndex = this.getJdbcParameters().indexOf(jdbcParameter);
                            jdbcParameter.setIndexInSql(this.soidIndex);
                        }
                    }
                    return true;
                }
            }
        } else if (expression instanceof InExpression) {
            InExpression inexp = (InExpression)expression;
            String columnName = ((Column)inexp.getLeftExpression()).getColumnName();
            if (oidField.equalsIgnoreCase(columnName) && inexp.getItemsList() instanceof ExpressionList) {
                List expressionList = ((ExpressionList)inexp.getItemsList()).getExpressions();
                int count = expressionList.size();
                int[] indexes = new int[count];
                int i = 0;
                while (i < count) {
                    int index;
                    Object tmp = expressionList.get(i);
                    if (tmp instanceof JdbcParameter) {
                        index = ((JdbcParameter)tmp).getIndexInSql();
                        if (index == -1) {
                            index = this.getJdbcParameters().indexOf(tmp);
                            ((JdbcParameter)tmp).setIndexInSql(index);
                        }
                    } else {
                        return false;
                    }
                    indexes[i] = index;
                    ++i;
                }
                return this.setOIDIndex(indexes);
            }
        } else if (expression instanceof AndExpression || expression instanceof OrExpression) {
            this.isOnlyOidOrSoid = false;
        }
        return false;
    }

    @Override
    protected List<String> findTableNames() {
        ArrayList<String> tmp = new ArrayList<String>();
        StringBuffer buffer = new StringBuffer(512);
        DeParser deParser = ParsedDelete.getSelectDeParser(tmp, buffer);
        DeleteDeParser deleteDeParser = new DeleteDeParser(deParser.getExpressionDeParser(), buffer);
        deleteDeParser.deParse(this.delete);
        tmp.add(this.delete.getTable().getName());
        return tmp;
    }

    @Override
    public Statement getStatement() {
        return this.delete;
    }

    @Override
    public Expression getWhereClause() {
        return this.delete.getWhere();
    }
}

