/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.dbcache.datatable;

import com.bokesoft.yes.common.json.SerializationException;
import com.bokesoft.yes.mid.dbcache.datatable.DataTableExUtil;
import com.bokesoft.yes.struct.abstractdatatable.SortCriteria;
import com.bokesoft.yes.struct.datatable.Row;
import com.bokesoft.yes.struct.datatable.filter.FilterEval;
import com.bokesoft.yes.struct.document.IJSONHandler;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.struct.datatable.ColumnInfo;
import com.bokesoft.yigo.struct.datatable.DataTable;
import com.bokesoft.yigo.struct.datatable.DataTableMetaData;
import com.bokesoft.yigo.struct.datatable.ICacheProvider;
import com.bokesoft.yigo.struct.datatable.Index;
import com.bokesoft.yigo.struct.exception.StructException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang3.ArrayUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class CacheDataTable
extends DataTable {
    private DataTableMetaData metaData;
    private int[] columnIndexes;
    private final DataTable readOnly;
    private Row[] readOnlyRows;
    private int readOnlyPos = -1;
    private HashMap<Integer, Integer> bookmarkMap;
    private DataTable writable;

    public static CacheDataTable newInstance(DataTable cache, DataTableMetaData metaData, int[] columnIndexes, int[] readOnlyRowIndexes) throws Throwable {
        CacheDataTable result = new CacheDataTable(cache, metaData, columnIndexes, readOnlyRowIndexes);
        return result;
    }

    public static CacheDataTable newInstance(DataTable cache, int[] readOnlyRowIndexes) throws Throwable {
        CacheDataTable result = new CacheDataTable(cache, cache.getMetaData(), null, readOnlyRowIndexes);
        return result;
    }

    public static CacheDataTable newInstance(DataTable cache) {
        return new CacheDataTable(cache, cache.getMetaData(), null, null);
    }

    public CacheDataTable(DataTable cache, DataTableMetaData metaData, int[] columnIndexes, int[] readOnlyRowIndexes) {
        super(metaData);
        this.readOnly = cache;
        super.setKey(cache.getKey());
        this.metaData = metaData;
        this.columnIndexes = columnIndexes;
        try {
            if (readOnlyRowIndexes != null) {
                this.bookmarkMap = DataTableExUtil.getBookmarkMap(this);
                int len = readOnlyRowIndexes.length;
                this.readOnlyRows = new Row[len];
                int i = 0;
                while (i < len) {
                    int rowIndex = readOnlyRowIndexes[i];
                    Row oldR = this.readOnly.getRowByIndex(rowIndex);
                    int oldBookmark = oldR.getBookmark();
                    Row r = new Row(this.readOnly, false);
                    r.impl_SetBookmarkSeed(oldBookmark);
                    Object[] oldDataList = oldR.getDataList();
                    System.arraycopy(oldDataList, 0, r.getDataList(), 0, oldDataList.length);
                    r.setState(0);
                    this.readOnlyRows[i] = r;
                    this.bookmarkMap.put(oldBookmark, i);
                    ++i;
                }
            } else {
                this.bookmarkMap = DataTableExUtil.getBookmarkMap(cache);
                this.readOnlyRows = null;
                DataTableExUtil.getFieldBookmarkMap().set((Object)this, this.bookmarkMap);
            }
        }
        catch (Throwable e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    public void setMetaData(DataTableMetaData metaData, MetaTable metaTable) {
        if (this.writable != null) {
            throw new RuntimeException("\u9519\u8bef\u7684\u7a0b\u5e8f\u8c03\u7528\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        this.metaData = metaData;
        if (this.columnIndexes == null) {
            int size = metaData.getColumnCount();
            DataTableMetaData readOnlyMetaData = this.readOnly.getMetaData();
            this.columnIndexes = new int[size];
            int i = 0;
            while (i < size) {
                String metaColumnKey = metaData.getColumnInfo(i).getColumnKey();
                String dbColumnName = ((MetaColumn)metaTable.get(metaColumnKey)).getBindingDBColumnName();
                this.columnIndexes[i] = readOnlyMetaData.findColumnIndexByKey(dbColumnName);
                ++i;
            }
        }
    }

    private DataTableMetaData getNewMetaData() {
        return this.metaData;
    }

    private DataTable getReadOnly() {
        return this.readOnly;
    }

    private DataTable getWritable() {
        return this.writable;
    }

    private DataTable getWritableNotNull() {
        if (this.writable == null) {
            try {
                int newRowIndex;
                int size;
                int bookmark = this.isValid() ? this.getBookmark() : -1;
                DataTable dt = new DataTable(this.metaData);
                dt.setKey(super.getKey());
                dt.setShowDeleted(this.isShowDeleted());
                int maxBookmark = -1;
                if (this.readOnlyRows == null) {
                    int rowIndex = 0;
                    size = this.readOnly.size();
                    while (rowIndex < size) {
                        newRowIndex = dt.append();
                        Row newRow = DataTableExUtil.getRowByIndex(dt, newRowIndex);
                        Row oldRow = DataTableExUtil.getRowByIndex(this.readOnly, rowIndex);
                        Object[] newDataList = newRow.getDataList();
                        Object[] oldDataList = oldRow.getDataList();
                        if (this.columnIndexes == null) {
                            System.arraycopy(oldDataList, 0, newDataList, 0, oldDataList.length);
                        } else {
                            int i = 0;
                            int columnSize = this.columnIndexes.length;
                            while (i < columnSize) {
                                int columnIndex = this.columnIndexes[i];
                                if (columnIndex != -1) {
                                    newDataList[i] = oldDataList[columnIndex];
                                }
                                ++i;
                            }
                        }
                        int oldBookmark = oldRow.getBookmark();
                        maxBookmark = oldBookmark > maxBookmark ? oldBookmark : maxBookmark;
                        newRow.impl_SetBookmarkSeed(oldBookmark);
                        newRow.setParentBookmark(oldRow.getParentBookmark());
                        newRow.stateUpdate();
                        ++rowIndex;
                    }
                } else {
                    Row[] rowArray = this.readOnlyRows;
                    newRowIndex = this.readOnlyRows.length;
                    size = 0;
                    while (size < newRowIndex) {
                        Row oldRow = rowArray[size];
                        int newRowIndex2 = dt.append();
                        Row newRow = DataTableExUtil.getRowByIndex(dt, newRowIndex2);
                        Object[] newDataList = newRow.getDataList();
                        Object[] oldDataList = oldRow.getDataList();
                        if (this.columnIndexes == null) {
                            System.arraycopy(oldDataList, 0, newDataList, 0, oldDataList.length);
                        } else {
                            int i = 0;
                            int columnSize = this.columnIndexes.length;
                            while (i < columnSize) {
                                int columnIndex = this.columnIndexes[i];
                                if (columnIndex != -1) {
                                    newDataList[i] = oldDataList[columnIndex];
                                }
                                ++i;
                            }
                        }
                        int oldBookmark = oldRow.getBookmark();
                        maxBookmark = oldBookmark > maxBookmark ? oldBookmark : maxBookmark;
                        newRow.impl_SetBookmarkSeed(oldBookmark);
                        newRow.setParentBookmark(oldRow.getParentBookmark());
                        newRow.stateUpdate();
                        ++size;
                    }
                }
                HashMap<Integer, Integer> bookmarkMap = DataTableExUtil.getBookmarkMap(dt);
                bookmarkMap.clear();
                int rowIndex = 0;
                int size2 = dt.size();
                while (rowIndex < size2) {
                    bookmarkMap.put(dt.getBookmark(rowIndex), rowIndex);
                    ++rowIndex;
                }
                if (bookmark >= 0) {
                    dt.setBookmark(bookmark);
                }
                dt.impl_SetBookmarkSeed(maxBookmark + 1);
                this.bookmarkMap = bookmarkMap;
                DataTableExUtil.getFieldBookmarkMap().set((Object)this, bookmarkMap);
                this.writable = dt;
            }
            catch (Throwable e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
        return this.writable;
    }

    private Row getRow(int rowIndex) {
        Row row = this.writable == null ? (this.readOnlyRows == null ? this.readOnly.getRowByIndex(rowIndex) : this.readOnlyRows[rowIndex]) : this.writable.getRowByIndex(rowIndex);
        return row;
    }

    public int addColumn(ColumnInfo column) throws StructException {
        return this.getWritableNotNull().addColumn(column);
    }

    public int addColumn(int columnIndex, ColumnInfo column) throws StructException {
        return this.getWritableNotNull().addColumn(columnIndex, column);
    }

    public void removeColumn(String columnKey) throws StructException {
        this.getWritableNotNull().removeColumn(columnKey);
    }

    private final void doColumnDataChange(int index, boolean add) {
    }

    public DataTableMetaData getMetaData() {
        DataTable writable = this.getWritable();
        if (writable != null) {
            return writable.getMetaData();
        }
        return this.getNewMetaData();
    }

    public void setFilter(String sFilter) throws Throwable {
        this.getWritableNotNull().setFilter(sFilter);
    }

    public void setFilterEval(FilterEval filterEval) {
        this.getWritableNotNull().setFilterEval(filterEval);
    }

    public String getFilter() {
        return this.getWritableNotNull().getFilter();
    }

    public void filter() throws Throwable {
        this.getWritableNotNull().filter();
    }

    public ArrayList<Integer> filter(String sFilter) throws Throwable {
        return this.getWritableNotNull().filter(sFilter);
    }

    public ArrayList<Integer> filter(FilterEval filterEval) throws Throwable {
        return this.getWritableNotNull().filter(filterEval);
    }

    public void setSort(String columnKey, boolean ascending) throws StructException {
        this.getWritableNotNull().setSort(columnKey, ascending);
    }

    public void setSort(SortCriteria[] vCriteria) throws StructException {
        this.getWritableNotNull().setSort(vCriteria);
    }

    public SortCriteria[] getSortCriteria() {
        return this.getWritableNotNull().getSortCriteria();
    }

    public void clearCriteria() {
        this.getWritableNotNull().clearCriteria();
    }

    public void sort() throws Throwable {
        this.getWritableNotNull().sort();
    }

    public void setShowDeleted(boolean showDeleted) throws Throwable {
        this.getWritableNotNull().setShowDeleted(showDeleted);
    }

    @Deprecated
    public void setShowDeletedFlag(boolean showDeleted) {
        this.getWritableNotNull().setShowDeletedFlag(showDeleted);
    }

    public void clearFilter() throws Throwable {
        this.getWritableNotNull().clearFilter();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.getWritableNotNull().writeExternal(out);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.getWritableNotNull().readExternal(in);
    }

    public DataTable deepClone() {
        return this.getWritableNotNull().deepClone();
    }

    public void setPos(int pos) throws StructException {
        if (this.writable == null) {
            this.readOnlyPos = pos;
        } else {
            this.writable.setPos(pos);
        }
    }

    public int getPos() {
        if (this.writable == null) {
            return this.readOnlyPos;
        }
        return this.writable.getPos();
    }

    public void beforeFirst() {
        this.setPos(-1);
    }

    public void afterLast() {
        if (this.writable == null) {
            int length;
            this.readOnlyPos = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
        } else {
            this.writable.afterLast();
        }
    }

    public boolean next() {
        if (this.writable == null) {
            if (this.isAfterLast()) {
                return false;
            }
            ++this.readOnlyPos;
            return !this.isAfterLast();
        }
        return this.writable.next();
    }

    public boolean next(boolean fetch) {
        return this.getWritableNotNull().next(fetch);
    }

    public boolean previous() {
        if (this.writable == null) {
            if (this.isBeforeFirst()) {
                return false;
            }
            --this.readOnlyPos;
            return !this.isBeforeFirst();
        }
        return this.writable.previous();
    }

    public boolean first() {
        if (this.writable == null) {
            int length;
            int n = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            if (length == 0) {
                return false;
            }
            this.readOnlyPos = 0;
            return true;
        }
        return this.writable.first();
    }

    public boolean last() {
        if (this.writable == null) {
            int length;
            int n = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            if (length == 0) {
                return false;
            }
            this.readOnlyPos = length - 1;
            return true;
        }
        return this.writable.last();
    }

    public int size() {
        if (this.writable == null) {
            int length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return length;
        }
        return this.writable.size();
    }

    public boolean isEmpty() {
        if (this.writable == null) {
            int length;
            int n = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return length == 0;
        }
        return this.writable.isEmpty();
    }

    public boolean isBeforeFirst() {
        if (this.writable == null) {
            return this.readOnlyPos == -1;
        }
        return this.writable.isBeforeFirst();
    }

    public boolean isAfterLast() {
        if (this.writable == null) {
            int length;
            int n = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return this.readOnlyPos == length;
        }
        return this.writable.isAfterLast();
    }

    public boolean isFirst() {
        if (this.writable == null) {
            int length;
            int n = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return length != 0 && this.readOnlyPos == 0;
        }
        return this.writable.isFirst();
    }

    public boolean isLast() {
        if (this.writable == null) {
            int length;
            int n = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return length != 0 && this.readOnlyPos == length - 1;
        }
        return this.writable.isLast();
    }

    public boolean isValid() {
        if (this.writable == null) {
            int length;
            int n = length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            return length != 0 && this.readOnlyPos >= 0 && this.readOnlyPos < length;
        }
        return this.writable.isValid();
    }

    public Object getOriginalObject(int rowIndex, int columnIndex) {
        return this.getWritableNotNull().getOriginalObject(rowIndex, columnIndex);
    }

    public Object getOriginalObject(int rowIndex, String columnKey) throws StructException {
        return this.getWritableNotNull().getOriginalObject(rowIndex, columnKey);
    }

    public Object getOriginalObject(int columnIndex) {
        return this.getWritableNotNull().getOriginalObject(columnIndex);
    }

    public Object getOriginalObject(String columnKey) throws StructException {
        return this.getWritableNotNull().getOriginalObject(columnKey);
    }

    public Object getObject(int rowIndex, int columnIndex) {
        if (this.writable == null) {
            if (this.columnIndexes != null) {
                if (columnIndex >= this.columnIndexes.length) {
                    return null;
                }
                if ((columnIndex = this.columnIndexes[columnIndex]) == -1) {
                    return null;
                }
            }
            Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(rowIndex) : this.readOnlyRows[rowIndex];
            return row.getObject(columnIndex);
        }
        return this.writable.getObject(rowIndex, columnIndex);
    }

    public void setObject(int rowIndex, int columnIndex, Object value) {
        this.getWritableNotNull().setObject(rowIndex, columnIndex, value);
    }

    public void setObject(int rowIndex, int columnIndex, Object value, boolean changeState) {
        this.getWritableNotNull().setObject(rowIndex, columnIndex, value, changeState);
    }

    public Object getObject(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.findColumnIndexByKey(columnKey);
        if (col == -1) {
            throw new StructException(6, StructException.formatMessage(null, (int)6, (Object[])new Object[]{columnKey}));
        }
        return this.getObject(rowIndex, col);
    }

    public Object impl_getObject(int rowIndex, String columnKey) throws StructException {
        int col = this.metaData.impl_findColumnIndexByKey(columnKey);
        return this.getObject(rowIndex, col);
    }

    public void setObject(int rowIndex, String columnKey, Object value) throws StructException {
        this.getWritableNotNull().setObject(rowIndex, columnKey, value);
    }

    public Object getObject(int columnIndex) {
        if (this.writable == null) {
            if (this.columnIndexes != null) {
                if (columnIndex >= this.columnIndexes.length) {
                    return null;
                }
                if ((columnIndex = this.columnIndexes[columnIndex]) == -1) {
                    return null;
                }
            }
            Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos];
            return row.getObject(columnIndex);
        }
        return this.writable.getObject(columnIndex);
    }

    public void setObject(int columnIndex, Object value) {
        this.getWritableNotNull().setObject(columnIndex, value);
    }

    public Object getObject(String columnKey) throws StructException {
        if (this.writable == null) {
            int columnIndex = this.metaData.findColumnIndexByKey(columnKey);
            if (this.columnIndexes != null) {
                if (columnIndex >= this.columnIndexes.length) {
                    return null;
                }
                if ((columnIndex = this.columnIndexes[columnIndex]) == -1) {
                    return null;
                }
            }
            Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos];
            return row.getObject(columnIndex);
        }
        return this.writable.getObject(columnKey);
    }

    public Object impl_getObject(String columnKey) throws StructException {
        if (this.writable == null) {
            int columnIndex = this.metaData.impl_findColumnIndexByKey(columnKey);
            if (this.columnIndexes != null) {
                if (columnIndex >= this.columnIndexes.length) {
                    return null;
                }
                if ((columnIndex = this.columnIndexes[columnIndex]) == -1) {
                    return null;
                }
            }
            Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos];
            return row.getObject(columnIndex);
        }
        return this.writable.impl_getObject(columnKey);
    }

    public void setObject(String columnKey, Object value) throws StructException {
        this.getWritableNotNull().setObject(columnKey, value);
    }

    public void setObject(String columnKey, Object value, boolean changeState) throws StructException {
        this.getWritableNotNull().setObject(columnKey, value, changeState);
    }

    public Integer getInt(int rowIndex, int columnIndex) {
        Object o = this.getObject(rowIndex, columnIndex);
        return TypeConvertor.toInteger((Object)o);
    }

    public void setInt(int rowIndex, int columnIndex, Integer value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public Integer getInt(int rowIndex, String columnKey) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        return this.getInt(rowIndex, col);
    }

    public void setInt(int rowIndex, String columnKey, Integer value) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        this.setInt(rowIndex, col, value);
    }

    public Integer getInt(int columnIndex) {
        Object o = this.getObject(columnIndex);
        return TypeConvertor.toInteger((Object)o);
    }

    public void setInt(int columnIndex, Integer value) {
        this.getWritableNotNull().setInt(columnIndex, value);
    }

    public Integer getInt(String columnKey) throws StructException {
        Object o = this.getObject(columnKey);
        return TypeConvertor.toInteger((Object)o);
    }

    public void setInt(String columnKey, Integer value) throws StructException {
        this.getWritableNotNull().setInt(columnKey, value);
    }

    public String getString(int rowIndex, int columnIndex) {
        return TypeConvertor.toString((Object)this.getObject(rowIndex, columnIndex));
    }

    public void setString(int rowIndex, int columnIndex, String value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public String getString(int rowIndex, String columnKey) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        return this.getString(rowIndex, col);
    }

    public void setString(int rowIndex, String columnKey, String value) throws StructException {
        this.getWritableNotNull().setString(rowIndex, columnKey, value);
    }

    public String getString(int columnIndex) {
        Object o = this.getObject(columnIndex);
        return (String)o;
    }

    public void setString(int columnIndex, String value) {
        this.getWritableNotNull().setString(columnIndex, value);
    }

    public String getString(String columnKey) throws StructException {
        Object o = this.getObject(columnKey);
        return (String)o;
    }

    public void setString(String columnKey, String value) throws StructException {
        this.getWritableNotNull().setString(columnKey, value);
    }

    public Date getDateTime(int rowIndex, int columnIndex) {
        return (Date)this.getObject(rowIndex, columnIndex);
    }

    public void setDateTime(int rowIndex, int columnIndex, Date value) {
        this.getWritableNotNull().setDateTime(rowIndex, columnIndex, value);
    }

    public Date getDateTime(int rowIndex, String columnKey) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        return this.getDateTime(rowIndex, col);
    }

    public void setDateTime(int rowIndex, String columnKey, Date value) throws StructException {
        this.getWritableNotNull().setDateTime(rowIndex, columnKey, value);
    }

    public Date getDateTime(int columnIndex) {
        Object o = this.getObject(columnIndex);
        return (Date)o;
    }

    public void setDateTime(int columnIndex, Date value) {
        this.getWritableNotNull().setDateTime(columnIndex, value);
    }

    public Date getDateTime(String columnKey) throws StructException {
        Object o = this.getObject(columnKey);
        return (Date)o;
    }

    public void setDateTime(String columnKey, Date value) throws StructException {
        this.getWritableNotNull().setDateTime(columnKey, value);
    }

    public BigDecimal getNumeric(int rowIndex, int columnIndex) {
        return TypeConvertor.toBigDecimal((Object)this.getObject(rowIndex, columnIndex));
    }

    public void setNumeric(int rowIndex, int columnIndex, BigDecimal value) {
        this.getWritableNotNull().setNumeric(rowIndex, columnIndex, value);
    }

    public BigDecimal getNumeric(int rowIndex, String columnKey) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        return this.getNumeric(rowIndex, col);
    }

    public void setNumeric(int rowIndex, String columnKey, BigDecimal value) throws StructException {
        this.getWritableNotNull().setNumeric(rowIndex, columnKey, value);
    }

    public BigDecimal getNumeric(int columnIndex) {
        Object o = this.getObject(columnIndex);
        return TypeConvertor.toBigDecimal((Object)o);
    }

    public void setNumeric(int columnIndex, BigDecimal value) {
        this.getWritableNotNull().setNumeric(columnIndex, value);
    }

    public BigDecimal getNumeric(String columnKey) throws StructException {
        Object o = this.getObject(columnKey);
        return TypeConvertor.toBigDecimal((Object)o);
    }

    public void setNumeric(String columnKey, BigDecimal value) throws StructException {
        this.getWritableNotNull().setNumeric(columnKey, value);
    }

    public byte[] getBinary(int rowIndex, int columnIndex) {
        return (byte[])this.getObject(rowIndex, columnIndex);
    }

    public void setBinary(int rowIndex, int columnIndex, byte[] value) {
        this.getWritableNotNull().setBinary(rowIndex, columnIndex, value);
    }

    public byte[] getBinary(int rowIndex, String columnKey) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        return this.getBinary(rowIndex, col);
    }

    public void setBinary(int rowIndex, String columnKey, byte[] value) throws StructException {
        this.getWritableNotNull().setBinary(rowIndex, columnKey, value);
    }

    public byte[] getBinary(int columnIndex) {
        Object o = this.getObject(columnIndex);
        return (byte[])o;
    }

    public void setBinary(int columnIndex, byte[] value) {
        this.getWritableNotNull().setBinary(columnIndex, value);
    }

    public byte[] getBinary(String columnKey) throws StructException {
        Object o = this.getObject(columnKey);
        return (byte[])o;
    }

    public void setBinary(String columnKey, byte[] value) throws StructException {
        this.getWritableNotNull().setBinary(columnKey, value);
    }

    public Long getLong(int rowIndex, int columnIndex) {
        Object o = this.getObject(rowIndex, columnIndex);
        return TypeConvertor.toLong((Object)o);
    }

    public void setLong(int rowIndex, int columnIndex, Long value) {
        this.getWritableNotNull().setLong(rowIndex, columnIndex, value);
    }

    public Long getLong(int rowIndex, String columnKey) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        return this.getLong(rowIndex, col);
    }

    public void setLong(int rowIndex, String columnKey, Long value) throws StructException {
        this.getWritableNotNull().setLong(rowIndex, columnKey, value);
    }

    public Long getLong(int columnIndex) {
        Object o = this.getObject(columnIndex);
        return TypeConvertor.toLong((Object)o);
    }

    public void setLong(int columnIndex, Long value) {
        this.getWritableNotNull().setLong(columnIndex, value);
    }

    public Long getLong(String columnKey) throws StructException {
        Object o = this.getObject(columnKey);
        return TypeConvertor.toLong((Object)o);
    }

    public void setLong(String columnKey, Long value) throws StructException {
        this.getWritableNotNull().setLong(columnKey, value);
    }

    public Boolean getBoolean(int rowIndex, int columnIndex) {
        return TypeConvertor.toBoolean((Object)this.getObject(rowIndex, columnIndex));
    }

    public void setBoolean(int rowIndex, int columnIndex, Boolean value) {
        this.setObject(rowIndex, columnIndex, (Object)value);
    }

    public Boolean getBoolean(int rowIndex, String columnKey) throws StructException {
        int col = this.getNewMetaData().findColumnIndexByKey(columnKey);
        return this.getBoolean(rowIndex, col);
    }

    public void setBoolean(int rowIndex, String columnKey, Boolean value) throws StructException {
        this.getWritableNotNull().setBoolean(rowIndex, columnKey, value);
    }

    public Boolean getBoolean(int columnIndex) {
        Object o = this.getObject(columnIndex);
        return TypeConvertor.toBoolean((Object)o);
    }

    public void setBoolean(int columnIndex, Boolean value) {
        this.getWritableNotNull().setBoolean(columnIndex, value);
    }

    public Boolean getBoolean(String columnKey) throws StructException {
        Object o = this.getObject(columnKey);
        return TypeConvertor.toBoolean((Object)o);
    }

    public void setBoolean(String columnKey, Boolean value) throws StructException {
        this.getWritableNotNull().setBoolean(columnKey, value);
    }

    public int insert(int rowIndex) {
        return this.getWritableNotNull().insert(rowIndex);
    }

    public int insert() {
        return this.getWritableNotNull().insert();
    }

    public int append() {
        return this.getWritableNotNull().append();
    }

    public void delete(int rowIndex) {
        this.getWritableNotNull().delete(rowIndex);
    }

    public void deleteAll() {
        this.getWritableNotNull().deleteAll();
    }

    public void batchUpdate() {
        if (this.writable != null) {
            this.writable.batchUpdate();
        }
    }

    @Deprecated
    public void clearOriginalData() {
        if (this.writable != null) {
            this.writable.clearOriginalData();
        }
    }

    @Deprecated
    public void batchUpdate(boolean reserveOrgData) {
        if (this.writable != null) {
            this.writable.batchUpdate(reserveOrgData);
        }
    }

    public void delete() {
        this.getWritableNotNull().delete();
    }

    public void forceRemove(int rowIndex) {
        this.getWritableNotNull().forceRemove(rowIndex);
    }

    public int getState() {
        if (this.writable == null) {
            return this.getState(this.readOnlyPos);
        }
        return this.writable.getState();
    }

    public void setState(int state) {
        this.getWritableNotNull().setState(state);
    }

    public int getState(int rowIndex) {
        return this.getRow(rowIndex).getState();
    }

    public int compare(Row o1, Row o2) {
        return this.getWritableNotNull().compare(o1, o2);
    }

    public int applyNewBookMark() {
        return this.getWritableNotNull().applyNewBookMark();
    }

    public int getBookmark() {
        if (this.writable == null) {
            Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos];
            return row.getBookmark();
        }
        return this.writable.getBookmark();
    }

    public int getParentBookmark() {
        if (this.writable == null) {
            Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos];
            return row.getParentBookmark();
        }
        return this.writable.getParentBookmark();
    }

    public void setParentBookmark(int bookmark) {
        if (this.writable == null) {
            int oldParentBookmark = this.getParentBookmark();
            if (oldParentBookmark != bookmark) {
                if (oldParentBookmark == -1) {
                    Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(this.readOnlyPos) : this.readOnlyRows[this.readOnlyPos];
                    row.setParentBookmark(bookmark);
                } else {
                    this.getWritableNotNull().setParentBookmark(bookmark);
                }
            }
        } else {
            this.writable.setParentBookmark(bookmark);
        }
    }

    public int getParentBookmark(int rowIndex) {
        return this.getRow(rowIndex).getParentBookmark();
    }

    public void setParentBookmark(int rowIndex, int bookmark) {
        if (this.writable == null) {
            int oldParentBookmark = this.getParentBookmark(rowIndex);
            if (oldParentBookmark != bookmark) {
                if (oldParentBookmark == -1) {
                    Row row = this.readOnlyRows == null ? this.readOnly.getRowByIndex(rowIndex) : this.readOnlyRows[rowIndex];
                    row.setParentBookmark(bookmark);
                } else {
                    this.getWritableNotNull().setParentBookmark(bookmark);
                }
            }
        } else {
            this.writable.setParentBookmark(bookmark);
        }
    }

    public int getBookmark(int rowIndex) {
        return this.getRow(rowIndex).getBookmark();
    }

    public void setBookmark(int bookmark) throws StructException {
        if (this.writable == null) {
            Integer index = this.bookmarkMap.get(bookmark);
            if (index != null) {
                this.readOnlyPos = index;
                return;
            }
            int length = this.readOnlyRows == null ? this.readOnly.size() : this.readOnlyRows.length;
            throw new StructException(1, "bookmark: " + bookmark + ", Size: " + length);
        }
        this.writable.setBookmark(bookmark);
    }

    public boolean isBookmarkExist(int bookmark) {
        if (this.writable == null) {
            return this.bookmarkMap.containsKey(bookmark);
        }
        return this.writable.isBookmarkExist(bookmark);
    }

    public String getKey() {
        DataTable writable = this.getWritable();
        if (writable != null) {
            return writable.getKey();
        }
        return super.getKey();
    }

    public void setKey(String key) {
        super.setKey(key);
        this.getWritableNotNull().setKey(key);
    }

    public JSONObject toJSONWithNoData() throws SerializationException, JSONException {
        return this.getWritableNotNull().toJSONWithNoData();
    }

    public JSONObject toJSON() throws Throwable {
        return this.getWritableNotNull().toJSON();
    }

    public void fromJSON(JSONObject tableObj) throws SerializationException, JSONException {
        this.getWritableNotNull().fromJSON(tableObj);
    }

    public boolean isShowDeleted() {
        if (this.writable != null) {
            return this.writable.isShowDeleted();
        }
        return super.isShowDeleted();
    }

    public int findRow(String columnKey, Object value) {
        return this.getWritableNotNull().findRow(columnKey, value);
    }

    public int findRow(int columnIndex, Object value) {
        return this.getWritableNotNull().findRow(columnIndex, value);
    }

    public void clear() {
        super.clear();
        if (this.writable != null) {
            this.writable.clear();
        }
    }

    @Deprecated
    public Row getRowByIndex(int rowIndex) {
        return this.getWritableNotNull().getRowByIndex(rowIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendString(sb, false);
        return sb.toString();
    }

    public void appendString(StringBuilder sb, boolean enter) {
        if (this.writable == null) {
            if (enter) {
                sb.append("\t");
            }
            sb.append("<Table key=\"");
            sb.append(this.readOnly.getKey());
            sb.append("\" curRowIndex=\"");
            sb.append(this.readOnlyPos);
            sb.append("\">\n");
            if (this.readOnlyRows != null) {
                Row[] rowArray = this.readOnlyRows;
                int n = this.readOnlyRows.length;
                int n2 = 0;
                while (n2 < n) {
                    Row r = rowArray[n2];
                    sb.append(enter ? "\t\t" : "\t");
                    r.appendString(sb);
                    ++n2;
                }
            } else {
                int rowIndex = 0;
                int size = this.readOnly.size();
                while (rowIndex < size) {
                    Row r = this.readOnly.getRowByIndex(rowIndex);
                    sb.append(enter ? "\t\t" : "\t");
                    r.appendString(sb);
                    ++rowIndex;
                }
            }
            if (enter) {
                sb.append("\t");
            }
            sb.append("</Table>\n");
        } else {
            this.getWritableNotNull().appendString(sb, enter);
        }
    }

    public String toShortString() {
        if (this.writable == null) {
            if (this.readOnlyRows != null ? this.readOnlyRows.length == 0 : this.readOnly.isEmpty()) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            DataTableMetaData md = this.getMetaData();
            int i = 0;
            while (i < md.getColumnCount()) {
                ColumnInfo ci = md.getColumnInfo(i);
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(ci.getColumnKey());
                ++i;
            }
            if (this.readOnlyRows != null) {
                Row[] rowArray = this.readOnlyRows;
                int n = this.readOnlyRows.length;
                int ci = 0;
                while (ci < n) {
                    Row r = rowArray[ci];
                    sb.append(";");
                    int i2 = 0;
                    while (i2 < md.getColumnCount()) {
                        if (i2 != 0) {
                            sb.append(",");
                        }
                        ColumnInfo ci2 = md.getColumnInfo(i2);
                        sb.append(ci2.getDataTypeAction().toString(r.getDataList()[i2]));
                        ++i2;
                    }
                    ++ci;
                }
            } else {
                int rowIndex = 0;
                int size = this.readOnly.size();
                while (rowIndex < size) {
                    Row r = this.readOnly.getRowByIndex(rowIndex);
                    sb.append(";");
                    int i3 = 0;
                    while (i3 < md.getColumnCount()) {
                        if (i3 != 0) {
                            sb.append(",");
                        }
                        ColumnInfo ci = md.getColumnInfo(i3);
                        sb.append(ci.getDataTypeAction().toString(r.getDataList()[i3]));
                        ++i3;
                    }
                    ++rowIndex;
                }
            }
            return sb.toString();
        }
        return this.getWritableNotNull().toShortString();
    }

    public DataTable cloneEmpty() throws StructException {
        return this.getWritableNotNull().cloneEmpty();
    }

    public void setNew() {
        this.getWritableNotNull().setNew();
    }

    public Object[] impl_getRow() {
        if (this.writable == null) {
            if (this.columnIndexes == null) {
                return DataTableExUtil.getRowByIndex(this.readOnly, this.readOnlyPos).getDataList();
            }
            int size = this.columnIndexes.length;
            Object[] result = new Object[size];
            Object[] tmp = DataTableExUtil.getRowByIndex(this.readOnly, this.readOnlyPos).getDataList();
            int i = 0;
            while (i < size) {
                result[i] = tmp[this.columnIndexes[i]];
                ++i;
            }
            return result;
        }
        return this.writable.impl_getRow();
    }

    public IJSONHandler newHandler(String token) {
        return this.getWritable().newHandler(token);
    }

    public void putAttr(String name, String value) {
        this.getWritable().putAttr(name, value);
    }

    public void endHandler() {
    }

    public void endChildHandler(IJSONHandler handler) {
    }

    public void setCache(ICacheProvider cache) {
        this.getWritableNotNull().setCache(cache);
    }

    public ICacheProvider getCache() {
        return this.getWritableNotNull().getCache();
    }

    public void close() {
        DataTable writable = this.getWritable();
        if (writable != null) {
            writable.close();
        }
    }

    public CacheDataTable copyReadOnly() throws Throwable {
        CacheDataTable result = new CacheDataTable(this.readOnly, this.metaData, this.columnIndexes, null);
        if (this.readOnlyRows != null) {
            int rowSize = this.readOnlyRows.length;
            Row[] rows = new Row[rowSize];
            System.arraycopy(this.readOnlyRows, 0, rows, 0, rowSize);
            result.readOnlyRows = rows;
            HashMap<Integer, Integer> bookMarks = new HashMap<Integer, Integer>();
            int i = 0;
            while (i < rowSize) {
                Row r = rows[i];
                bookMarks.put(r.getBookmark(), i);
                ++i;
            }
            result.bookmarkMap = bookMarks;
            DataTableExUtil.getFieldBookmarkMap().set((Object)result, bookMarks);
            result.readOnlyPos = 0;
        }
        return result;
    }

    public CacheDataTable copyReadOnlyByMaxRows(int maxRows) throws Throwable {
        CacheDataTable result = new CacheDataTable(this.readOnly, this.metaData, this.columnIndexes, null);
        int resMaxRows = this.size() < maxRows ? this.size() : maxRows;
        Row[] rows = new Row[resMaxRows];
        HashMap<Integer, Integer> bookMarks = new HashMap<Integer, Integer>();
        if (this.readOnlyRows != null) {
            System.arraycopy(this.readOnlyRows, 0, rows, 0, resMaxRows);
        } else {
            int i = 0;
            while (i < resMaxRows) {
                Row r;
                rows[i] = r = this.readOnly.getRowByIndex(i);
                ++i;
            }
        }
        int maxBookmark = -1;
        int i = 0;
        while (i < resMaxRows) {
            int bookmark = rows[i].getBookmark();
            maxBookmark = Integer.max(maxBookmark, bookmark);
            bookMarks.put(bookmark, i);
            ++i;
        }
        result.readOnlyRows = rows;
        result.bookmarkMap = bookMarks;
        DataTableExUtil.getFieldBookmarkMap().set((Object)result, bookMarks);
        result.readOnlyPos = 0;
        return result;
    }

    public int fastFindFirst(String[] filterColumns, Object[] filterValues) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastFindFirst(filterColumns, filterValues);
        }
        if (this.readOnlyRows == null) {
            return this.readOnly.fastFindFirst(filterColumns, filterValues);
        }
        return this.getWritableNotNull().fastFindFirst(filterColumns, filterValues);
    }

    public int[] fastFilter(String[] filterColumns, Object[] filterValues) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastFilter(filterColumns, filterValues);
        }
        if (this.readOnlyRows == null) {
            int i = 0;
            int length = filterColumns.length;
            while (i < length) {
                boolean isColumnNotExist;
                ColumnInfo columnInfo = this.metaData.getColumnInfo(filterColumns[i]);
                int columnIndex = columnInfo.getColumnIndex();
                boolean bl = isColumnNotExist = this.columnIndexes != null && (columnIndex >= this.columnIndexes.length || this.columnIndexes[columnIndex] == -1);
                if (isColumnNotExist) {
                    Object filterValue;
                    int dataType = columnInfo.getDataType();
                    Object val = Index.convertType(null, (int)dataType);
                    if (!CacheDataTable.isSameObj(val, filterValue = filterValues[i])) {
                        return ArrayUtils.EMPTY_INT_ARRAY;
                    }
                    filterColumns[i] = filterColumns[length - 1];
                    filterColumns = Arrays.copyOf(filterColumns, length - 1);
                    filterValues[i] = filterValues[length - 1];
                    filterValues = Arrays.copyOf(filterValues, length - 1);
                }
                ++i;
            }
            if (filterColumns.length == 0) {
                int[] result = new int[this.readOnly.size()];
                int rowIndex = 0;
                while (rowIndex < this.readOnly.size()) {
                    result[rowIndex] = rowIndex;
                    ++rowIndex;
                }
                return result;
            }
            return this.readOnly.fastFilter(filterColumns, filterValues);
        }
        return this.getWritableNotNull().fastFilter(filterColumns, filterValues);
    }

    public int[] fastFilter(String filterColumn, Object filterValue) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastFilter(filterColumn, filterValue);
        }
        if (this.readOnlyRows == null) {
            return this.readOnly.fastFilter(filterColumn, filterValue);
        }
        return this.getWritableNotNull().fastFilter(filterColumn, filterValue);
    }

    public int[] fastSort(int[] rowIndexes, SortCriteria[] vCriteria) throws Throwable {
        if (this.writable != null) {
            return this.writable.fastSort(rowIndexes, vCriteria);
        }
        if (this.readOnlyRows == null) {
            return this.readOnly.fastSort(rowIndexes, vCriteria);
        }
        return this.getWritableNotNull().fastSort(rowIndexes, vCriteria);
    }

    public static boolean isSame(Object[] values1, Object[] values2) {
        if (values1 == values2) {
            return true;
        }
        int i = values1.length - 1;
        while (i >= 0) {
            if (!CacheDataTable.isSameObj(values1[i], values2[i])) {
                return false;
            }
            --i;
        }
        return true;
    }

    private static boolean isSameObj(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof Integer) {
            return obj2 instanceof Integer && obj1.equals(obj2);
        }
        if (obj1 instanceof Long) {
            return obj2 instanceof Long && obj1.equals(obj2);
        }
        if (obj1 instanceof String) {
            return obj2 instanceof String && obj1.equals(obj2);
        }
        if (obj1 instanceof BigDecimal) {
            return obj2 instanceof BigDecimal && obj1.equals(obj2);
        }
        throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\u6bd4\u8f83\uff0c" + obj1.getClass().getName());
    }

    public void deleteRows(int[] rowIndexes) {
        this.getWritableNotNull().deleteRows(rowIndexes);
    }

    public void setMaintSequence(boolean maintSequence) {
        this.getWritableNotNull().setMaintSequence(maintSequence);
    }

    public boolean isMaintSequence() {
        return this.getWritableNotNull().isMaintSequence();
    }
}

