/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.util;

import com.bokesoft.yes.mid.connection.MdbDSNGroupValues;
import com.bokesoft.yes.mid.connection.MdbDSNItems;
import com.bokesoft.yes.mid.connection.MultiDBDSNItem;
import com.bokesoft.yes.mid.connection.impl.DefaultMultiDSNInitialization;
import com.bokesoft.yes.mid.connection.intf.IMultiDSNInitialization;
import com.bokesoft.yes.mid.mysqls.group.Group;
import com.bokesoft.yes.mid.mysqls.group.GroupConfig;
import com.bokesoft.yes.mid.mysqls.group.Groups;
import com.bokesoft.yigo.mid.connection.DBType;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class MutliDSNUtil {
    private static IMultiDSNInitialization INSTANCE = new DefaultMultiDSNInitialization();

    public static IMultiDSNInitialization getInstance() {
        return INSTANCE;
    }

    public static void initIMultiDSNInitialization(IMultiDSNInitialization multiDSNInitialization) {
        INSTANCE = multiDSNInitialization;
    }

    public static MultiDBDSNItem buildDSN(MdbDSNItems dsnCollection, String dsn, String connectionType, String driver, String url, String user, String password, String dbType, String dbFactory, Map<String, String> extConfigMap, Map<String, String> extConfigMap2, String clsname) {
        MultiDBDSNItem dbItem = new MultiDBDSNItem();
        dbItem.setName(dsn);
        if ("dbcp".equalsIgnoreCase(connectionType)) {
            dbItem.setConnectionType(1);
        } else if ("jndi".equalsIgnoreCase(connectionType)) {
            dbItem.setConnectionType(2);
        } else {
            dbItem.setConnectionType(0);
        }
        dbItem.setDriver(driver);
        dbItem.setURL(url);
        dbItem.setUser(user);
        dbItem.setPassword(password);
        dbItem.setDBType(DBType.parse((String)dbType));
        dbItem.setDriverExt(clsname);
        if (StringUtils.isNotBlank((CharSequence)dbFactory)) {
            dbItem.setDBFactory(dbFactory);
        }
        if (extConfigMap != null && !extConfigMap.isEmpty()) {
            for (String key : extConfigMap.keySet()) {
                dbItem.addExtProp(key, extConfigMap.get(key));
            }
        }
        if (extConfigMap2 != null && !extConfigMap2.isEmpty()) {
            for (String key : extConfigMap2.keySet()) {
                dbItem.addExtProp2(key, extConfigMap2.get(key));
            }
        }
        return dbItem;
    }

    public static void initDSN2Group(MdbDSNItems dsnCollection) {
        Groups groups = GroupConfig.instance.getGroups();
        MultiDBDSNItem defaultDSNItem = dsnCollection.getDefaultDSN();
        if (defaultDSNItem.getGroupValuesList().size() != 0) {
            throw new RuntimeException("\u9ed8\u8ba4\u7684\u6570\u636e\u6e90\u5c5e\u4e8e\u4efb\u4e00\u4e2a\u5206\u7ec4\uff0c\u4e0d\u9700\u8981\u4e14\u4e0d\u5f97\u989d\u5916\u8bbe\u7f6e\u3002");
        }
        for (Group group : groups) {
            group.addDSN(defaultDSNItem);
        }
        for (MultiDBDSNItem dsnItem : dsnCollection) {
            if (dsnItem == defaultDSNItem) continue;
            for (MdbDSNGroupValues groupValues : dsnItem.getGroupValuesList()) {
                groupValues.group.addDSN(dsnItem);
            }
        }
    }
}

