/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid.connection.dbmanager;

import com.bokesoft.yes.mid.mysqls.processselect.InTableGroups;
import com.bokesoft.yes.mid.mysqls.processselect.ParsedSqlUtil;
import com.bokesoft.yigo.mid.util.DBManagerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.boke.jsqlparser.expression.Expression;
import net.boke.jsqlparser.expression.MySQLIndexHint;
import net.boke.jsqlparser.expression.OracleHint;
import net.boke.jsqlparser.expression.SQLServerHints;
import net.boke.jsqlparser.schema.Column;
import net.boke.jsqlparser.schema.Table;
import net.boke.jsqlparser.statement.select.OrderByElement;
import net.boke.jsqlparser.statement.select.PlainSelect;
import net.boke.jsqlparser.statement.select.SubSelect;
import net.boke.jsqlparser.statement.select.Top;
import net.boke.jsqlparser.util.deparser.SelectDeParser;
import org.apache.commons.lang3.StringUtils;

class SelectDeParserEx
extends SelectDeParser {
    private boolean isSubSelect = false;
    private final List<Integer> emptyStringIndexList;
    private Map<PlainSelect, Map<String, Table>> allTablesMap = new ConcurrentHashMap<PlainSelect, Map<String, Table>>();

    SelectDeParserEx(int dbType, List<Integer> emptyStringIndexList) {
        this.dbType = dbType;
        this.emptyStringIndexList = emptyStringIndexList;
    }

    public boolean isSubSelect() {
        return this.isSubSelect;
    }

    public void setSubSelect(boolean isSubSelect) {
        this.isSubSelect = isSubSelect;
    }

    @Override
    public void visit(PlainSelect plainSelect) {
        this.convertIndexHint(plainSelect);
        if (this.isSubSelect() && DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType)) {
            List orderByElements = plainSelect.getOrderByElements();
            String forXmlPath = plainSelect.getForXmlPath();
            Top top = plainSelect.getTop();
            if (orderByElements != null && forXmlPath == null && top == null) {
                top = new Top();
                top.setRowCount(100L);
                top.setRowCountJdbcParameter(false);
                top.setPercentage(true);
                plainSelect.setTop(top);
                this.setChange();
            }
        }
        super.visit(plainSelect);
    }

    private void convertIndexHint(PlainSelect plainSelect) {
        if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType)) {
            this.convert2OracleHint(plainSelect);
        } else {
            this.convertOracleHint2MySQLHint(plainSelect);
        }
    }

    private void convert2OracleHint(PlainSelect plainSelect) {
        Map<String, Table> allTables = this.getAllTables(plainSelect);
        for (Map.Entry<String, Table> entry : allTables.entrySet()) {
            Table table = entry.getValue();
            if (table == null) continue;
            this.convertMySQLIndexHint2OracleHint(plainSelect, table);
            this.convertSQLServerIndexHint2OracleHint(plainSelect, table);
        }
    }

    private void convertMySQLIndexHint2OracleHint(PlainSelect plainSelect, Table table) {
        MySQLIndexHint indexHint = table.getIndexHint();
        if (indexHint == null) {
            return;
        }
        String aliasName = table.getAliasName();
        List<String> indexNames = indexHint.getIndexNames();
        this.addOracleIndexHint(plainSelect, aliasName, indexNames);
        table.setHint(null);
        this.setChange();
    }

    private void convertSQLServerIndexHint2OracleHint(PlainSelect plainSelect, Table table) {
        SQLServerHints indexHints = table.getSqlServerHints();
        if (indexHints == null) {
            return;
        }
        String aliasName = table.getAliasName();
        List<String> indexNames = Collections.singletonList(indexHints.getIndexName());
        this.addOracleIndexHint(plainSelect, aliasName, indexNames);
        table.setSqlServerHints(null);
        this.setChange();
    }

    private void addOracleIndexHint(PlainSelect plainSelect, String aliasName, List<String> indexNames) {
        OracleHint oracleHint = plainSelect.getOracleHint();
        if (oracleHint == null) {
            oracleHint = new OracleHint();
            oracleHint.addIndexName(aliasName, indexNames);
            plainSelect.setOracleHint(oracleHint);
        } else {
            oracleHint.addIndexName(aliasName, indexNames);
        }
    }

    private void convertOracleHint2MySQLHint(PlainSelect plainSelect) {
        OracleHint oracleHint = plainSelect.getOracleHint();
        if (oracleHint == null) {
            return;
        }
        Map<String, Set<String>> oracleHintIndexNames = oracleHint.getTableIndexNames();
        if (oracleHintIndexNames == null) {
            return;
        }
        boolean isChange = false;
        Map<String, Table> allTables = this.getAllTables(plainSelect);
        for (Map.Entry<String, Set<String>> entry : oracleHintIndexNames.entrySet()) {
            List<String> hintIndexNames;
            String aliasName = entry.getKey();
            Set<String> indexNames = entry.getValue();
            Table table = allTables.get(aliasName);
            if (table == null) continue;
            MySQLIndexHint indexHint = table.getIndexHint();
            if (indexHint == null) {
                hintIndexNames = new ArrayList<String>();
                hintIndexNames.addAll(indexNames);
                indexHint = new MySQLIndexHint("force", "index", hintIndexNames);
                table.setHint(indexHint);
            } else {
                hintIndexNames = indexHint.getIndexNames();
                for (String indexName : indexNames) {
                    if (hintIndexNames.contains(indexName)) continue;
                    hintIndexNames.add(indexName);
                }
            }
            isChange = true;
        }
        if (isChange) {
            this.setChange();
            plainSelect.setOracleHint(null);
        }
    }

    private Map<String, Table> getAllTables(PlainSelect plainSelect) {
        return this.allTablesMap.computeIfAbsent(plainSelect, key -> {
            InTableGroups inTableGroups = new InTableGroups();
            List<Table> allTables = ParsedSqlUtil.getAllTableBySelectBody(plainSelect, inTableGroups);
            ConcurrentHashMap<String, Table> map = new ConcurrentHashMap<String, Table>();
            for (Table table : allTables) {
                String aliasName = table.getAliasName();
                map.put(aliasName, table);
            }
            return map;
        });
    }

    @Override
    public void visit(SubSelect subSelect) {
        this.setSubSelect(true);
        super.visit(subSelect);
        this.setSubSelect(false);
    }

    @Override
    public void visit(OrderByElement orderBy) {
        Expression expression = orderBy.getExpression();
        OrderByElement.NullOrdering nullOrdering = orderBy.getNullOrdering();
        expression.accept(this.expressionVisitor);
        if (!orderBy.isAsc()) {
            this.buffer.append(" DESC");
        }
        if (DBManagerUtil.isOracleLikeDatabase((int)this.dbType)) {
            if (nullOrdering == null && expression instanceof Column) {
                this.buffer.append(' ');
                this.buffer.append(orderBy.isAsc() ? "NULLS FIRST" : "NULLS LAST");
                this.setChange();
            } else {
                this.buffer.append(' ');
                this.buffer.append(nullOrdering == OrderByElement.NullOrdering.NULLS_FIRST ? "NULLS FIRST" : "NULLS LAST");
            }
        } else if (nullOrdering != null) {
            this.setChange();
        }
    }

    public boolean isEmptyStringJdbcParameter(int jdbcParameterIndex) {
        if (this.emptyStringIndexList == null || this.emptyStringIndexList.size() <= 0) {
            return false;
        }
        return this.emptyStringIndexList.contains(jdbcParameterIndex);
    }

    @Override
    public void visit(Table table) {
        this.convertMySQLIndexHint2SQLServerHint(table);
        this.convertSQLServerIndexHint2MySQLHint(table);
        super.visit(table);
    }

    private void convertSQLServerIndexHint2MySQLHint(Table table) {
        if (!DBManagerUtil.isMySQLLikeDatabase((int)this.dbType)) {
            return;
        }
        SQLServerHints sqlServerHints = table.getSqlServerHints();
        if (sqlServerHints == null) {
            return;
        }
        String indexName = sqlServerHints.getIndexName();
        MySQLIndexHint indexHint = table.getIndexHint();
        if (indexHint == null) {
            ArrayList<String> hintIndexNames = new ArrayList<String>();
            hintIndexNames.add(indexName);
            indexHint = new MySQLIndexHint("force", "index", hintIndexNames);
            table.setHint(indexHint);
        } else {
            List<String> hintIndexNames = indexHint.getIndexNames();
            if (!hintIndexNames.contains(indexName)) {
                hintIndexNames.add(indexName);
            }
        }
        table.setSqlServerHints(null);
        this.setChange();
    }

    private void convertMySQLIndexHint2SQLServerHint(Table table) {
        if (!DBManagerUtil.isSQLServerLikeDatabase((int)this.dbType)) {
            return;
        }
        MySQLIndexHint mySQLIndexHint = table.getIndexHint();
        if (mySQLIndexHint == null) {
            return;
        }
        List<String> indexNames = mySQLIndexHint.getIndexNames();
        String indexName = StringUtils.join(indexNames, (String)", ");
        SQLServerHints sqlServerHints = table.getSqlServerHints();
        if (sqlServerHints == null) {
            sqlServerHints = new SQLServerHints();
            sqlServerHints.setIndexName(indexName);
            table.setSqlServerHints(sqlServerHints);
        } else {
            String oldIndexName = sqlServerHints.getIndexName();
            sqlServerHints.setIndexName(String.valueOf(oldIndexName) + ", " + indexName);
        }
        table.setHint(null);
        this.setChange();
    }
}

