/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.mid;

import com.bokesoft.yes.erp.lock.ServerUtil;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.mid.base.DefaultContext;
import com.bokesoft.yigo.mid.connection.IDBManager;
import com.bokesoft.yigo.mid.util.ContextBuilder;
import com.bokesoft.yigo.struct.datatable.DataTable;

public class ServerID {
    private static int serverID = -1;
    private static final String STR_Sys_ServerIDPool = "Sys_ServerIDPool";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getServerID(IDBManager dbManager) {
        if (serverID != -1) return serverID;
        Class<ServerID> clazz = ServerID.class;
        synchronized (ServerID.class) {
            if (serverID != -1) return serverID;
            try {
                String macAddress = ServerUtil.getMacAddress();
                int serverPort = ServerUtil.getServerPort();
                serverID = ServerID.genServerID(dbManager, macAddress, serverPort);
            }
            catch (Throwable e) {
                throw new RuntimeException("\u7533\u8bf7\u5e94\u7528\u670d\u52a1\u7f16\u53f7\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002", e);
            }
            return serverID;
        }
    }

    private static int genServerID(IDBManager dbManager, String macAddress, int serverPort) throws Throwable {
        DataTable rs = null;
        rs = dbManager.execPrepareQuery("select ID from Sys_ServerIDPool where MacAddress=? and ServerPort=?", new Object[]{macAddress, serverPort});
        int result = -1;
        if (rs != null && rs.first()) {
            result = rs.getInt(0, 0);
        } else {
            try (DefaultContext newContext = null;){
                newContext = ContextBuilder.create();
                IDBManager newDBManager = newContext.getDBManager();
                newDBManager.setRowLockEnsureInSYSLock("GenServerID");
                DataTable dt = newDBManager.execQuery("select max(ID) MaxID from Sys_ServerIDPool");
                int maxID = TypeConvertor.toInteger((Object)dt.getObject(0, 0));
                result = maxID + 1;
                newDBManager.execPrepareUpdate("insert into Sys_ServerIDPool (MacAddress, ServerPort, ID) values (?,?,?)", new Object[]{macAddress, serverPort, result});
                newContext.commit();
            }
        }
        if (result >= 10000 || result == -1) {
            throw new RuntimeException("\u5e94\u7528\u670d\u52a1\u7f16\u53f7\u751f\u6210\u9519\u8bef" + result + "\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\uff0c\u8c22\u8c22\u3002");
        }
        return result;
    }
}

